/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.views.IViewDescriptor;

public class ShowViewAction
extends Action
implements IPluginContribution {
    private IWorkbenchWindow window;
    private IViewDescriptor desc;

    protected ShowViewAction(IWorkbenchWindow window, IViewDescriptor desc, boolean makeFast) {
        super("");
        String accel = null;
        String label = desc.getLabel();
        this.setText(accel == null ? label : String.valueOf(label) + "@" + accel);
        this.setImageDescriptor(desc.getImageDescriptor());
        this.setToolTipText(label);
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.show_view_action_context");
        this.window = window;
        this.desc = desc;
    }

    @Override
    public void run() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            try {
                page.showView(this.desc.getId());
            }
            catch (PartInitException e) {
                ErrorDialog.openError(this.window.getShell(), WorkbenchMessages.ShowView_errorTitle, e.getMessage(), e.getStatus());
            }
        }
    }

    @Override
    public String getLocalId() {
        return this.desc.getId();
    }

    @Override
    public String getPluginId() {
        return this.desc instanceof IPluginContribution ? ((IPluginContribution)((Object)this.desc)).getPluginId() : null;
    }
}

