/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.Headers;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.java.JavaUtils;
import fr.esrf.tango.pogo.generator.java.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class JavaDynamicAttribute {
    @Inject
    @Extension
    private JavaUtils _javaUtils;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private ProtectedArea _protectedArea;

    public CharSequence generateJavaDynamicAttributeClassFile(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header(cls, attribute);
        _builder.append((Object)_header, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dynamic attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(", ");
        String _strJavaType = this._javaUtils.strJavaType(attribute);
        _builder.append((Object)_strJavaType, " ");
        _builder.append(", ");
        String _attType = attribute.getAttType();
        _builder.append((Object)_attType, " ");
        _builder.append(", ");
        String _rwType = attribute.getRwType();
        _builder.append((Object)_rwType, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*     ");
        AttrProperties _properties = attribute.getProperties();
        String _description = _properties.getDescription();
        String _comments = StringUtils.comments(_description, "*     ");
        _builder.append((Object)_comments, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(" implements IAttributeBehavior {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**\tThe attribute name */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String  attributeName;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = attribute.getName();
        String _plus = String.valueOf(_name_2) + ".";
        String _plus_1 = String.valueOf(_plus) + "dataMembers";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1, "Put your data member declarations", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constructor = this.constructor(cls, attribute);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _configurationMethod = this.getConfigurationMethod(cls, attribute);
        _builder.append((Object)_configurationMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _stateMachineMethod = this.stateMachineMethod(cls, attribute);
        _builder.append((Object)_stateMachineMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _valueMethod = this.getValueMethod(cls, attribute);
        _builder.append((Object)_valueMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _setValueMethod = this.setValueMethod(cls, attribute);
        _builder.append((Object)_setValueMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        String _name_3 = attribute.getName();
        String _plus_2 = String.valueOf(_name_3) + ".";
        String _plus_3 = String.valueOf(_plus_2) + "methods";
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_3, "Put your own methods", true);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence header(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = attribute.getName();
        String _plus = String.valueOf(_name) + ".java";
        String _openProtectedArea = this._protectedArea.openProtectedArea(cls, _plus);
        _builder.append((Object)_openProtectedArea, "");
        _builder.newLineIfNotEmpty();
        String _name_1 = attribute.getName();
        String _plus_1 = String.valueOf(_name_1) + ".java";
        String _name_2 = attribute.getName();
        String _plus_2 = "Java source for the dynamic attribute " + _name_2;
        String _plus_3 = String.valueOf(_plus_2) + ".\n";
        String _plus_4 = String.valueOf(_plus_3) + "this attribute belongs to the ";
        String _name_3 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_3;
        String _plus_6 = String.valueOf(_plus_5) + " class.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        String _fileHeader = this._headers.fileHeader(_plus_1, _plus_6, _title, _license, _copyright);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_4 = attribute.getName();
        String _plus_7 = String.valueOf(_name_4) + ".java";
        String _closeProtectedArea = this._protectedArea.closeProtectedArea(cls, _plus_7);
        _builder.append((Object)_closeProtectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("package ");
        String _javaDevicePackage = this._javaUtils.javaDevicePackage(cls);
        _builder.append((Object)_javaDevicePackage, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.tango.DeviceState;");
        _builder.newLine();
        _builder.append("import org.tango.server.StateMachineBehavior;");
        _builder.newLine();
        _builder.append("import org.tango.server.attribute.IAttributeBehavior;");
        _builder.newLine();
        _builder.append("import org.tango.server.attribute.AttributeValue;");
        _builder.newLine();
        _builder.append("import org.tango.server.attribute.AttributeConfiguration;");
        _builder.newLine();
        _builder.append("import org.tango.server.attribute.AttributePropertiesImpl;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("//\tImport Tango IDL types");
        _builder.newLine();
        _builder.append("import fr.esrf.Tango.*;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        String _name_5 = attribute.getName();
        String _plus_8 = String.valueOf(_name_5) + ".";
        String _plus_9 = String.valueOf(_plus_8) + "addImports";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_9);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dynamic attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" constructor");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @param attributeName The dynamic attribute name");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("(String attributeName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.attributeName = attributeName;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getConfigurationMethod(PogoDeviceClass cls, Attribute attribute) {
        String _polledPeriod_1;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Build and return the configuration for dynamic attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return the configuration for dynamic attribute ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @throws DevFailed in case of configuration error.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public AttributeConfiguration getConfiguration() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("AttributeConfiguration  config = new AttributeConfiguration();");
        _builder.newLine();
        _builder.append("\t");
        String _setDynamicAttributeConfig = this._javaUtils.setDynamicAttributeConfig("Name", "attributeName");
        _builder.append((Object)_setDynamicAttributeConfig, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _strJavaType = this._javaUtils.strJavaType(attribute);
        String _plus = String.valueOf(_strJavaType) + ".class";
        String _setDynamicAttributeConfig_1 = this._javaUtils.setDynamicAttributeConfig("Type", _plus);
        _builder.append((Object)_setDynamicAttributeConfig_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _attType = attribute.getAttType();
        String _upperCase = _attType.toUpperCase();
        String _setDynamicAttributeConfig_2 = this._javaUtils.setDynamicAttributeConfig("Format", _upperCase, "AttrDataFormat.");
        _builder.append((Object)_setDynamicAttributeConfig_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _rwType = attribute.getRwType();
        String _setDynamicAttributeConfig_3 = this._javaUtils.setDynamicAttributeConfig("Writable", _rwType, "AttrWriteType.");
        _builder.append((Object)_setDynamicAttributeConfig_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _displayLevel = attribute.getDisplayLevel();
        String _setDynamicAttributeConfig_4 = this._javaUtils.setDynamicAttributeConfig("DispLevel", _displayLevel, "DispLevel.");
        _builder.append((Object)_setDynamicAttributeConfig_4, "\t");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        String _polledPeriod = attribute.getPolledPeriod();
        boolean bl = _notEquals = !Objects.equal(_polledPeriod, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal(_polledPeriod_1 = attribute.getPolledPeriod(), "0"));
        if (_and) {
            _builder.append("\t");
            String _setDynamicAttributeConfig_5 = this._javaUtils.setDynamicAttributeConfig("Polled", "true");
            _builder.append((Object)_setDynamicAttributeConfig_5, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _polledPeriod_2 = attribute.getPolledPeriod();
            String _setDynamicAttributeConfig_6 = this._javaUtils.setDynamicAttributeConfig("PollingPeriod", _polledPeriod_2);
            _builder.append((Object)_setDynamicAttributeConfig_6, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        String _memorized = attribute.getMemorized();
        String _setDynamicAttributeConfig_7 = this._javaUtils.setDynamicAttributeConfig("Memorized", _memorized);
        _builder.append((Object)_setDynamicAttributeConfig_7, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _memorizedAtInit = attribute.getMemorizedAtInit();
        String _setDynamicAttributeConfig_8 = this._javaUtils.setDynamicAttributeConfig("MemorizedAtInit", _memorizedAtInit);
        _builder.append((Object)_setDynamicAttributeConfig_8, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _buildSetProperties = this.buildSetProperties(attribute);
        _builder.append((Object)_buildSetProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return config;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence buildSetProperties(Attribute attribute) {
        EventCriteria _evArchiveCriteria;
        boolean _notEquals_2;
        EventCriteria _eventCriteria;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tSet attribute properties");
        _builder.newLine();
        _builder.append("AttributePropertiesImpl\tproperties = new AttributePropertiesImpl();");
        _builder.newLine();
        AttrProperties _properties = attribute.getProperties();
        boolean bl = _notEquals = !Objects.equal(_properties, null);
        if (_notEquals) {
            AttrProperties _properties_1 = attribute.getProperties();
            String _description = _properties_1.getDescription();
            String _setDynamicAttributePropertyConfig = this._javaUtils.setDynamicAttributePropertyConfig("Description", _description);
            _builder.append((Object)_setDynamicAttributePropertyConfig, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_2 = attribute.getProperties();
            String _label = _properties_2.getLabel();
            String _setDynamicAttributePropertyConfig_1 = this._javaUtils.setDynamicAttributePropertyConfig("Label", _label);
            _builder.append((Object)_setDynamicAttributePropertyConfig_1, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_3 = attribute.getProperties();
            String _unit = _properties_3.getUnit();
            String _setDynamicAttributePropertyConfig_2 = this._javaUtils.setDynamicAttributePropertyConfig("Unit", _unit);
            _builder.append((Object)_setDynamicAttributePropertyConfig_2, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_4 = attribute.getProperties();
            String _standardUnit = _properties_4.getStandardUnit();
            String _setDynamicAttributePropertyConfig_3 = this._javaUtils.setDynamicAttributePropertyConfig("StandardUnit", _standardUnit);
            _builder.append((Object)_setDynamicAttributePropertyConfig_3, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_5 = attribute.getProperties();
            String _displayUnit = _properties_5.getDisplayUnit();
            String _setDynamicAttributePropertyConfig_4 = this._javaUtils.setDynamicAttributePropertyConfig("DisplayUnit", _displayUnit);
            _builder.append((Object)_setDynamicAttributePropertyConfig_4, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_6 = attribute.getProperties();
            String _format = _properties_6.getFormat();
            String _setDynamicAttributePropertyConfig_5 = this._javaUtils.setDynamicAttributePropertyConfig("Format", _format);
            _builder.append((Object)_setDynamicAttributePropertyConfig_5, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_7 = attribute.getProperties();
            String _maxValue = _properties_7.getMaxValue();
            String _setDynamicAttributePropertyConfig_6 = this._javaUtils.setDynamicAttributePropertyConfig("MaxValue", _maxValue);
            _builder.append((Object)_setDynamicAttributePropertyConfig_6, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_8 = attribute.getProperties();
            String _minValue = _properties_8.getMinValue();
            String _setDynamicAttributePropertyConfig_7 = this._javaUtils.setDynamicAttributePropertyConfig("MinValue", _minValue);
            _builder.append((Object)_setDynamicAttributePropertyConfig_7, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_9 = attribute.getProperties();
            String _maxAlarm = _properties_9.getMaxAlarm();
            String _setDynamicAttributePropertyConfig_8 = this._javaUtils.setDynamicAttributePropertyConfig("MaxAlarm", _maxAlarm);
            _builder.append((Object)_setDynamicAttributePropertyConfig_8, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_10 = attribute.getProperties();
            String _minAlarm = _properties_10.getMinAlarm();
            String _setDynamicAttributePropertyConfig_9 = this._javaUtils.setDynamicAttributePropertyConfig("MinAlarm", _minAlarm);
            _builder.append((Object)_setDynamicAttributePropertyConfig_9, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_11 = attribute.getProperties();
            String _maxWarning = _properties_11.getMaxWarning();
            String _setDynamicAttributePropertyConfig_10 = this._javaUtils.setDynamicAttributePropertyConfig("MaxWarning", _maxWarning);
            _builder.append((Object)_setDynamicAttributePropertyConfig_10, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_12 = attribute.getProperties();
            String _minWarning = _properties_12.getMinWarning();
            String _setDynamicAttributePropertyConfig_11 = this._javaUtils.setDynamicAttributePropertyConfig("MinWarning", _minWarning);
            _builder.append((Object)_setDynamicAttributePropertyConfig_11, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_13 = attribute.getProperties();
            String _deltaTime = _properties_13.getDeltaTime();
            String _setDynamicAttributePropertyConfig_12 = this._javaUtils.setDynamicAttributePropertyConfig("DeltaT", _deltaTime);
            _builder.append((Object)_setDynamicAttributePropertyConfig_12, "");
            _builder.newLineIfNotEmpty();
            AttrProperties _properties_14 = attribute.getProperties();
            String _deltaValue = _properties_14.getDeltaValue();
            String _setDynamicAttributePropertyConfig_13 = this._javaUtils.setDynamicAttributePropertyConfig("DeltaVal", _deltaValue);
            _builder.append((Object)_setDynamicAttributePropertyConfig_13, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(_eventCriteria = attribute.getEventCriteria(), null);
        if (_notEquals_1) {
            EventCriteria _eventCriteria_1 = attribute.getEventCriteria();
            String _absChange = _eventCriteria_1.getAbsChange();
            String _setDynamicAttributePropertyConfig_14 = this._javaUtils.setDynamicAttributePropertyConfig("EventAbsChange", _absChange);
            _builder.append((Object)_setDynamicAttributePropertyConfig_14, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _eventCriteria_2 = attribute.getEventCriteria();
            String _relChange = _eventCriteria_2.getRelChange();
            String _setDynamicAttributePropertyConfig_15 = this._javaUtils.setDynamicAttributePropertyConfig("EventRelChange", _relChange);
            _builder.append((Object)_setDynamicAttributePropertyConfig_15, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _eventCriteria_3 = attribute.getEventCriteria();
            String _period = _eventCriteria_3.getPeriod();
            String _setDynamicAttributePropertyConfig_16 = this._javaUtils.setDynamicAttributePropertyConfig("EventPeriod", _period);
            _builder.append((Object)_setDynamicAttributePropertyConfig_16, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _notEquals_2 = !Objects.equal(_evArchiveCriteria = attribute.getEvArchiveCriteria(), null);
        if (_notEquals_2) {
            EventCriteria _evArchiveCriteria_1 = attribute.getEvArchiveCriteria();
            String _absChange_1 = _evArchiveCriteria_1.getAbsChange();
            String _setDynamicAttributePropertyConfig_17 = this._javaUtils.setDynamicAttributePropertyConfig("ArchivingEventAbsChange", _absChange_1);
            _builder.append((Object)_setDynamicAttributePropertyConfig_17, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _evArchiveCriteria_2 = attribute.getEvArchiveCriteria();
            String _relChange_1 = _evArchiveCriteria_2.getRelChange();
            String _setDynamicAttributePropertyConfig_18 = this._javaUtils.setDynamicAttributePropertyConfig("ArchivingEventRelChange", _relChange_1);
            _builder.append((Object)_setDynamicAttributePropertyConfig_18, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _evArchiveCriteria_3 = attribute.getEvArchiveCriteria();
            String _period_1 = _evArchiveCriteria_3.getPeriod();
            String _setDynamicAttributePropertyConfig_19 = this._javaUtils.setDynamicAttributePropertyConfig("ArchivingEventPeriod", _period_1);
            _builder.append((Object)_setDynamicAttributePropertyConfig_19, "");
            _builder.newLineIfNotEmpty();
        }
        String _setDynamicAttributeConfig = this._javaUtils.setDynamicAttributeConfig("AttributeProperties", "properties");
        _builder.append((Object)_setDynamicAttributeConfig, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence stateMachineMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Get dynamic attribute state machine");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the attribute state machine");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if the state machine computation failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public StateMachineBehavior getStateMachine() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("StateMachineBehavior stateMachine = new StateMachineBehavior();");
        _builder.newLine();
        _builder.append("\t");
        String _stateMachineForDynamic = this._javaUtils.stateMachineForDynamic(attribute);
        _builder.append((Object)_stateMachineForDynamic, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name = attribute.getName();
        String _plus = String.valueOf(_name) + ".";
        String _plus_1 = String.valueOf(_plus) + "getStateMachine";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return stateMachine;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getValueMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Get dynamic attribute value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return the attribute value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if the read value failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public AttributeValue getValue() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        String _strFullJavaType = this._javaUtils.strFullJavaType(attribute);
        _builder.append((Object)_strFullJavaType, "\t");
        _builder.append("\treadValue;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name = attribute.getName();
        String _plus = String.valueOf(_name) + ".";
        String _plus_1 = String.valueOf(_plus) + "getValue";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return new AttributeValue(readValue);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setValueMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Set dynamic attribute value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param writeValue the attribute value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if the set value failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public void setValue(AttributeValue writeValue) throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        String _name = attribute.getName();
        String _plus = String.valueOf(_name) + ".";
        String _plus_1 = String.valueOf(_plus) + "setValue";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1, "System.out.println(\"Writing \" + writeValue + \"to hardware\");", false);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

