/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.html;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.html.HtmlUtils;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class HtmlAttributes
implements IGenerator {
    @Inject
    @Extension
    private HtmlUtils _htmlUtils;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description = cls.getDescription();
            String _filestogenerate = _description.getFilestogenerate();
            boolean _contains = _filestogenerate.contains("html");
            if (!_contains) continue;
            StringUtils.printTrace("Generating doc_html/Attributes.html");
            CharSequence _generateHtmlAttributesFile = this.generateHtmlAttributesFile(cls, true);
            fsa.generateFile("doc_html/Attributes.html", _generateHtmlAttributesFile);
            EList<Attribute> _attributes = cls.getAttributes();
            for (Attribute attribute : _attributes) {
                String _name = attribute.getName();
                String _plus = "Generating doc_html/Attr" + _name;
                String _plus_1 = String.valueOf(_plus) + ".html";
                StringUtils.printTrace(_plus_1);
                String _name_1 = attribute.getName();
                String _plus_2 = "doc_html/Attr" + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + ".html";
                CharSequence _generateHtmlOneAttributeFile = this.generateHtmlOneAttributeFile(cls, attribute, true);
                fsa.generateFile(_plus_3, _generateHtmlOneAttributeFile);
            }
            EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
            for (Attribute attribute_1 : _dynamicAttributes) {
                String _name = attribute_1.getName();
                String _plus = "Generating doc_html/Attr" + _name;
                String _plus_1 = String.valueOf(_plus) + ".html";
                StringUtils.printTrace(_plus_1);
                String _name_1 = attribute_1.getName();
                String _plus_2 = "doc_html/Attr" + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + ".html";
                CharSequence _generateHtmlOneAttributeFile = this.generateHtmlOneAttributeFile(cls, attribute_1, true);
                fsa.generateFile(_plus_3, _generateHtmlOneAttributeFile);
            }
        }
    }

    public CharSequence generateHtmlAttributesFile(PogoDeviceClass cls, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, "Attributes");
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br><br>");
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        String _name = cls.getName();
        String _htmlAttributesTable = this._htmlUtils.htmlAttributesTable(_attributes, _name, false);
        _builder.append((Object)_htmlAttributesTable, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("<br><br>");
        _builder.newLine();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        String _name_1 = cls.getName();
        String _htmlAttributesTable_1 = this._htmlUtils.htmlAttributesTable(_dynamicAttributes, _name_1, true);
        _builder.append((Object)_htmlAttributesTable_1, "");
        _builder.newLineIfNotEmpty();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateHtmlOneAttributeFile(PogoDeviceClass cls, Attribute attribute, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _name = attribute.getName();
            String _plus = "Attribute " + _name;
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, _plus);
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br>");
        _builder.newLine();
        String _isDynamic = attribute.getIsDynamic();
        boolean _isTrue = StringUtils.isTrue(_isDynamic);
        if (_isTrue) {
            String _name_1 = attribute.getName();
            String _plus_1 = "Dynamic attribute " + _name_1;
            String _plus_2 = String.valueOf(_plus_1) + " :";
            String _htmlTitle = this._htmlUtils.htmlTitle(_plus_2);
            _builder.append((Object)_htmlTitle, "");
            _builder.newLineIfNotEmpty();
        } else {
            String _name_2 = attribute.getName();
            String _plus_3 = "Attribute " + _name_2;
            String _plus_4 = String.valueOf(_plus_3) + " :";
            String _htmlTitle_1 = this._htmlUtils.htmlTitle(_plus_4);
            _builder.append((Object)_htmlTitle_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("<ul>");
        _builder.newLine();
        _builder.append("\t");
        AttrProperties _properties = attribute.getProperties();
        String _description = _properties.getDescription();
        String _checkSpecialChars = HtmlUtils.checkSpecialChars(_description);
        String _htmlStringWithBreak = this._htmlUtils.htmlStringWithBreak(_checkSpecialChars);
        _builder.append((Object)_htmlStringWithBreak, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</ul>");
        _builder.newLine();
        _builder.append("<br><br><br>");
        _builder.newLine();
        _builder.append("<Table Border=0 Cellpadding=0 CELLSPACING=20>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<TR>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<TD ALIGN=\"left\" VALIGN=top>");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _htmlOneAttributeDefinitionTable = this._htmlUtils.htmlOneAttributeDefinitionTable(attribute);
        _builder.append((Object)_htmlOneAttributeDefinitionTable, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</td>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<TD ALIGN=\"Center\" VALIGN=top>");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _htmlOneAttributePropertiesTable = this._htmlUtils.htmlOneAttributePropertiesTable(attribute);
        _builder.append((Object)_htmlOneAttributePropertiesTable, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</td>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<TD ALIGN=\"Right\" VALIGN=top>");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _htmlOneAttributeEventCriteriaTable = this._htmlUtils.htmlOneAttributeEventCriteriaTable(attribute);
        _builder.append((Object)_htmlOneAttributeEventCriteriaTable, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</td>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</TR>");
        _builder.newLine();
        _builder.append("</table>");
        _builder.newLine();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }
}

