/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.projects;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.cpp.projects.MakefileUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class LinuxMakefile {
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private MakefileUtils _makefileUtils;

    public CharSequence generateLinuxMakefileMultiClasses(PogoMultiClasses multi) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = multi.getName();
        CharSequence _makefileHeader = this._headers.makefileHeader(_name, false);
        _builder.append((Object)_makefileHeader, "");
        _builder.newLineIfNotEmpty();
        String _makeEnv = this._makefileUtils.makeEnv(multi, false);
        _builder.append((Object)_makeEnv, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_1 = multi.getName();
        CharSequence _addMiscellaneousDefinitions = this.addMiscellaneousDefinitions(_name_1);
        _builder.append((Object)_addMiscellaneousDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _addClassesDefinitions = this._makefileUtils.addClassesDefinitions(multi);
        _builder.append((Object)_addClassesDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _makefileIncludes = this._makefileUtils.makefileIncludes(multi);
        _builder.append((Object)_makefileIncludes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _addMiscellaneous2Definitions = this.addMiscellaneous2Definitions();
        _builder.append((Object)_addMiscellaneous2Definitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _addObjectFiles = this._makefileUtils.addObjectFiles(multi);
        _builder.append((Object)_addObjectFiles, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("#\tinclude common targets");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("include $(MAKE_ENV)/common_target.opt");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# Following are dependancies of the classes used by project");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        String _dependancies = this._makefileUtils.dependancies(multi);
        _builder.append((Object)_dependancies, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateLinuxMakefile(PogoDeviceClass cls) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = cls.getName();
        CharSequence _makefileHeader = this._headers.makefileHeader(_name, false);
        _builder.append((Object)_makefileHeader, "");
        _builder.newLineIfNotEmpty();
        String _makeEnv = this._makefileUtils.makeEnv(cls, false);
        _builder.append((Object)_makeEnv, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_1 = cls.getName();
        CharSequence _addMiscellaneousDefinitions = this.addMiscellaneousDefinitions(_name_1);
        _builder.append((Object)_addMiscellaneousDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _addInheritanceDefinitions = this._makefileUtils.addInheritanceDefinitions(cls);
        _builder.append((Object)_addInheritanceDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _makefileIncludes = this._makefileUtils.makefileIncludes(cls);
        _builder.append((Object)_makefileIncludes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _addMiscellaneous2Definitions = this.addMiscellaneous2Definitions();
        _builder.append((Object)_addMiscellaneous2Definitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# SVC_OBJS is the list of all objects needed to make the output");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("SVC_INCL =  $(PACKAGE_NAME).h $(PACKAGE_NAME)Class.h ");
        String _addInheritancIncludeReference = this._makefileUtils.addInheritancIncludeReference(cls);
        _builder.append((Object)_addInheritancIncludeReference, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("SVC_OBJS =      \\");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("$(LIB_OBJS) \\");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("$(OBJDIR)/ClassFactory.o  \\");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("$(OBJDIR)/main.o");
        _builder.newLine();
        _builder.newLine();
        _builder.append("LIB_OBJS = \\");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("$(OBJDIR)/$(PACKAGE_NAME).o \\");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("$(OBJDIR)/$(PACKAGE_NAME)Class.o \\");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("$(OBJDIR)/$(PACKAGE_NAME)StateMachine.o \\");
        _builder.newLine();
        _builder.append("\t\t");
        String _dynamicAttrObjects = this._makefileUtils.dynamicAttrObjects(cls);
        _builder.append((Object)_dynamicAttrObjects, "\t\t");
        String _inheritanceObjects = this._makefileUtils.inheritanceObjects(cls);
        _builder.append((Object)_inheritanceObjects, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("$(ADDITIONAL_OBJS) ");
        _builder.newLine();
        _builder.newLine();
        String _addInheritanceObjectFiles = this._inheritanceUtils.addInheritanceObjectFiles(cls);
        _builder.append((Object)_addInheritanceObjectFiles, "");
        _builder.newLineIfNotEmpty();
        String _addAdditionalObjectFiles = this._makefileUtils.addAdditionalObjectFiles(cls);
        _builder.append((Object)_addAdditionalObjectFiles, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("#\tinclude common targets");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("include $(MAKE_ENV)/common_target.opt");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        boolean _hasInheritanceClass = this._inheritanceUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            String _inheritanceDependancies = this._makefileUtils.inheritanceDependancies(cls);
            _builder.append((Object)_inheritanceDependancies, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<AdditionalFile> _additionalFiles = cls.getAdditionalFiles();
        boolean _isEmpty = _additionalFiles.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            String _additionalDependencies = this._makefileUtils.additionalDependencies(cls);
            _builder.append((Object)_additionalDependencies, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence addMiscellaneousDefinitions(String project) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# PACKAGE_NAME is the name of the library/device/exe you want to build");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("PACKAGE_NAME = ");
        _builder.append((Object)project, "");
        _builder.newLineIfNotEmpty();
        _builder.append("MAJOR_VERS   = 1");
        _builder.newLine();
        _builder.append("MINOR_VERS   = 0");
        _builder.newLine();
        _builder.append("RELEASE      = Release_$(MAJOR_VERS)_$(MINOR_VERS)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# #=============================================================================");
        _builder.newLine();
        _builder.append("# # RELEASE_TYPE");
        _builder.newLine();
        _builder.append("# # - DEBUG     : debug symbols - no optimization");
        _builder.newLine();
        _builder.append("# # - OPTIMIZED : no debug symbols - optimization level set to O2");
        _builder.newLine();
        _builder.append("# #-----------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("RELEASE_TYPE = DEBUG");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# OUTPUT_TYPE can be one of the following :");
        _builder.newLine();
        _builder.append("#   - 'STATIC_LIB' for a static library (.a)");
        _builder.newLine();
        _builder.append("#   - 'SHARED_LIB' for a dynamic library (.so)");
        _builder.newLine();
        _builder.append("#   - 'DEVICE' for a device server (will automatically include and link");
        _builder.newLine();
        _builder.append("#            with Tango dependencies)");
        _builder.newLine();
        _builder.append("#   - 'SIMPLE_EXE' for an executable with no dependency (for exemple the test tool");
        _builder.newLine();
        _builder.append("#                of a library with no Tango dependencies)");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("OUTPUT_TYPE = DEVICE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# OUTPUT_DIR  is the directory which contains the build result.");
        _builder.newLine();
        _builder.append("# if not set, the standard location is :");
        _builder.newLine();
        _builder.append("#\t- ./shlib if OUTPUT_TYPE is SHARED_LIB");
        _builder.newLine();
        _builder.append("#\t- ./lib   if OUTPUT_TYPE is STATIC_LIB");
        _builder.newLine();
        _builder.append("#\t- ./bin for others");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#OUTPUT_DIR =");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addMiscellaneous2Definitions() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# LIB_DIR_USER is the list of user library directories");
        _builder.newLine();
        _builder.append("#   - for a device server, tango libraries directories are automatically appended");
        _builder.newLine();
        _builder.append("#   - '-L ../lib' is automatically appended in all cases");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("LIB_DIR_USER=");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# LFLAGS_USR is the list of user link flags");
        _builder.newLine();
        _builder.append("#   - for a device server, tango libraries directories are automatically appended");
        _builder.newLine();
        _builder.append("#   - '-ldl -lpthread' is automatically appended in all cases");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# !!! ATTENTION !!!");
        _builder.newLine();
        _builder.append("# Be aware that the order matters. ");
        _builder.newLine();
        _builder.append("# For example if you must link with libA, and if libA depends itself on libB");
        _builder.newLine();
        _builder.append("# you must use '-lA -lB' in this order as link flags, otherwise you will get");
        _builder.newLine();
        _builder.append("# 'undefined reference' errors");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#LFLAGS_USR+=");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# CXXFLAGS_USR lists the compilation flags specific for your library/device/exe");
        _builder.newLine();
        _builder.append("# This is the place where to put your compile-time macros using '-Dmy_macro'");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# -DACE_HAS_EXCEPTIONS -D__ACE_INLINE__ for ACE");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#CXXFLAGS_USR+= -Wall");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# TANGO_REQUIRED ");
        _builder.newLine();
        _builder.append("# - TRUE  : your project depends on TANGO");
        _builder.newLine();
        _builder.append("# - FALSE : your project does not depend on TANGO");
        _builder.newLine();
        _builder.append("#-----------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("# - NOTE : if PROJECT_TYPE is set to DEVICE, TANGO will be auto. added");
        _builder.newLine();
        _builder.append("#-----------------------------------------------------------------------------  ");
        _builder.newLine();
        _builder.append("TANGO_REQUIRED = TRUE");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("#\tinclude Standard TANGO compilation options");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("include $(MAKE_ENV)/tango.opt");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("#\tPOST_PROCESSING: action to be done after normal make.");
        _builder.newLine();
        _builder.append("#\te.g.:  change executable file name, .....");
        _builder.newLine();
        _builder.append("#POST_PROCESSING = \\");
        _builder.newLine();
        _builder.append("#\tmv bin/$(BIN_DIR)/$(PACKAGE_NAME) bin/$(BIN_DIR)/$(PACKAGE_NAME)_DS");
        _builder.newLine();
        return _builder;
    }
}

