/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import fr.esrf.Tango.DevFailed;
import java.util.Vector;
import pogo.class2www.Family;
import pogo.class2www.FamilyList;
import pogo.class2www.Module;
import pogo.class2www.Repository;
import pogo.gene.PogoUtil;

public class TangoDsRepository
extends Repository {
    private static final String cvs_path = "tango-ds/cvsroot";

    public TangoDsRepository(String backup_home, boolean check_svn) throws DevFailed {
        super(backup_home + "/" + cvs_path);
        this.name = "tango-ds";
        this.url = "http://tango-ds.cvs.sourceforge.net/viewvc/tango-ds/";
        this.home = ".";
        this.default_family = "Acquisition";
        this.families = new FamilyList(cvs_path);
        this.check_svn = check_svn;
    }

    public void parseCvsModule() {
        String[] lines = PogoUtil.string2array(this.str_module, "\n");
        Family family = null;
        boolean libraries = false;
        for (String line : lines) {
            String[] tmp;
            if ((line = line.trim()).startsWith("###")) {
                tmp = PogoUtil.string2array(line);
                String f_name = tmp[1];
                for (int i = 2; i < tmp.length; ++i) {
                    f_name = f_name + "_" + tmp[i];
                }
                libraries = f_name.equals("Libraries");
                if (libraries) continue;
                family = new Family(f_name);
                this.families.add(family);
                continue;
            }
            if (libraries || line.startsWith("#") || family == null) continue;
            tmp = PogoUtil.string2array(line);
            Module module = new Module(tmp[0], tmp[1], this, family, 0);
            family.add(module);
            this.cvs_modules.add(tmp[0]);
        }
    }

    public String getCvsSvnSummary() {
        try {
            int cnt = 0;
            String code = "CVS: " + this.cvs_modules.size() + " classes\n";
            for (String cvsModule : this.cvs_modules) {
                code = code + ++cnt + ": " + cvsModule + "\n";
            }
            cnt = 0;
            code = code + "SVN: " + this.svn_modules.size() + " classes\n";
            for (String svnModule : this.svn_modules) {
                code = code + ++cnt + ": " + svnModule + "\n";
            }
            PogoUtil.writeFile("/segfs/tango/backup/log/tango-ds", code);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        String numbers = "CVS: " + this.cvs_modules.size() + " classes\n" + "SVN: " + this.svn_modules.size() + " classes\n";
        Vector<String> duplic = new Vector<String>();
        for (String cvsModule : this.cvs_modules) {
            for (String svnModule : this.svn_modules) {
                if (!cvsModule.toLowerCase().equals(svnModule.toLowerCase())) continue;
                duplic.add(cvsModule + " - " + svnModule);
            }
        }
        String duplications = "Duplications found:\n";
        for (String s : duplic) {
            duplications = duplications + s + "\n";
        }
        return numbers + "\n" + duplications;
    }
}

