/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;

public class Utils {
    private static Utils instance = null;
    private static ImageIcon tango_icon = null;
    public ImageIcon logoIcon;
    public ImageIcon rootIcon = this.getIcon("TangoSplash.jpg", 0.2);
    public ImageIcon classIcon;
    public ImageIcon collectionIcon;
    public ImageIcon classPropertyIcon;
    public ImageIcon cmdIcon;
    public ImageIcon cmdExpertIcon;
    public ImageIcon scalarIcon;
    public ImageIcon scalarExpertIcon;
    public ImageIcon spectrumIcon;
    public ImageIcon spectrumExpertIcon;
    public ImageIcon imageIcon;
    public ImageIcon imageExpertIcon;
    public ImageIcon forwardedIcon;
    public ImageIcon pipeIcon;
    public ImageIcon devicePropertyIcon;
    public ImageIcon stateIcon;
    public ImageIcon inheritanceIcon;
    public ImageIcon removeIcon;
    public ImageIcon abstractIcon;
    public ImageIcon inheritedIcon;
    public ImageIcon overloadedIcon;
    public ImageIcon unknownIcon;
    public ImageIcon reloadIcon;
    public ImageIcon newIcon;
    public ImageIcon newFromTemplateIcon;
    public ImageIcon openIcon;
    public ImageIcon saveIcon;
    public ImageIcon cppLogo;
    public ImageIcon javaLogo;
    public ImageIcon pythonLogo;
    public ImageIcon pythonHLLogo;
    public ImageIcon errorIcon;
    private static double pogoGuiRevision = -1.0;
    private static final String tooltipHeader = "<html><BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFD0\">";
    private static HashMap<String, Color> foregroundMap = null;
    private static HashMap<String, Color> stateMap = null;
    private static Splash splash = null;
    private static boolean splashOn;
    private SplashRefresher splash_refresher;
    private static boolean useDisplay;
    private boolean splashInit = false;

    private Utils() {
        this.logoIcon = this.classIcon = this.getIcon("TangoClass.gif", 0.12);
        this.collectionIcon = this.getIcon("tools.gif");
        this.classPropertyIcon = this.getIcon("class.gif");
        this.cmdIcon = this.getIcon("command.gif");
        this.cmdExpertIcon = this.getIcon("command_expert.gif");
        this.scalarIcon = this.getIcon("scalar.gif");
        this.scalarExpertIcon = this.getIcon("scalar_expert.gif");
        this.spectrumIcon = this.getIcon("spectrum.gif");
        this.spectrumExpertIcon = this.getIcon("spectrum_expert.gif");
        this.imageIcon = this.getIcon("image.gif", 0.25);
        this.imageExpertIcon = this.getIcon("image_expert.gif", 0.25);
        this.forwardedIcon = this.getIcon("forward.gif", 0.2);
        this.pipeIcon = this.getIcon("pipe.gif", 0.16);
        this.devicePropertyIcon = this.getIcon("device.gif");
        this.stateIcon = this.getIcon("state.gif");
        this.inheritanceIcon = this.getIcon("inherite.gif", 0.5);
        this.removeIcon = this.getIcon("remove.gif");
        this.abstractIcon = this.getIcon("abstract.gif");
        this.inheritedIcon = this.getIcon("inherited.gif");
        this.overloadedIcon = this.getIcon("concrete.gif");
        this.unknownIcon = this.getIcon("greyball.gif");
        this.reloadIcon = this.getIcon("reload_icon.gif", 0.8);
        this.newIcon = this.getIcon("new_icon.gif", 1.0);
        this.newFromTemplateIcon = this.getIcon("new_templ_icon.gif", 1.0);
        this.openIcon = this.getIcon("open_icon.gif", 1.0);
        this.saveIcon = this.getIcon("save_icon.gif", 1.0);
        this.cppLogo = this.getIcon("CppLogo.gif", 0.66);
        this.javaLogo = this.getIcon("JavaLogo.gif", 0.12);
        this.pythonLogo = this.getIcon("PythonLogo.gif", 0.33);
        this.pythonHLLogo = this.getIcon("PythonHLLogo.gif", 0.33);
        this.errorIcon = this.getIcon("error.gif");
        Utils.getPogoGuiRevision();
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static double getPogoGuiRevision() {
        if (pogoGuiRevision < 0.0) {
            StringTokenizer stringTokenizer = new StringTokenizer("9.2.9b  -  04-08-2016  15:23:08");
            String string = stringTokenizer.nextToken();
            int n = string.indexOf(46);
            if (n > 0) {
                if ((n = string.indexOf(46, n + 1)) > 0) {
                    string = string.substring(0, n);
                }
                try {
                    pogoGuiRevision = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("When trying to get PogoGuiRevision :\n" + numberFormatException);
                }
            }
            System.out.println("********* Pogo GUI Release : " + pogoGuiRevision + ".x *********");
        }
        return pogoGuiRevision;
    }

    public ImageIcon getIcon(String string, double d) {
        ImageIcon imageIcon = this.getIcon(string);
        return this.getIcon(imageIcon, d);
    }

    public ImageIcon getIcon(ImageIcon imageIcon, double d) {
        if (imageIcon != null) {
            int n = imageIcon.getIconWidth();
            int n2 = imageIcon.getIconHeight();
            n = (int)(d * (double)n);
            n2 = (int)(d * (double)n2);
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(n, n2, 4));
        }
        return imageIcon;
    }

    public URL getImageUrl(String string) {
        return this.getClass().getResource("/org/tango/pogo/pogo_gui/img/" + string);
    }

    public ImageIcon getIcon(String string) {
        URL uRL = this.getImageUrl(string);
        if (uRL == null) {
            System.err.println("Icon file  " + string + "  not found");
            return null;
        }
        return new ImageIcon(uRL);
    }

    public static String getRelativeFilename(String string) {
        String string2 = string;
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getPath(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        String string3 = "./";
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        return string3;
    }

    public static int getLanguage(String string) {
        for (int i = 0; i < PogoConst.strLang.length; ++i) {
            if (!string.toLowerCase().equals(PogoConst.strLang[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public static String getFileExtension(String string) {
        return PogoConst.fileExtension[Utils.getLanguage(string)];
    }

    public static String buildCppExecuteMethodName(String string) {
        if (string.equals("State")) {
            return "dev_state";
        }
        if (string.equals("Status")) {
            return "dev_status";
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= 'A' && string.charAt(i) <= 'Z') {
                if (i > 0 && (string.charAt(i - 1) < 'A' || string.charAt(i - 1) > 'Z')) {
                    string2 = string2 + '_';
                }
                string2 = string2 + (char)(string.charAt(i) + 32);
                continue;
            }
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public static int getCommandIndex(EList<Command> eList, Command command) {
        int n = -1;
        int n2 = 0;
        for (Command command2 : eList) {
            if (command2 == command) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getAttributeIndex(EList<Attribute> eList, Attribute attribute) {
        int n = -1;
        int n2 = 0;
        for (Attribute attribute2 : eList) {
            if (attribute2 == attribute) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getForwardedAttributeIndex(EList<ForwardedAttribute> eList, ForwardedAttribute forwardedAttribute) {
        int n = -1;
        int n2 = 0;
        for (ForwardedAttribute forwardedAttribute2 : eList) {
            if (forwardedAttribute2 == forwardedAttribute) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getPipeIndex(EList<Pipe> eList, Pipe pipe) {
        int n = -1;
        int n2 = 0;
        for (Pipe pipe2 : eList) {
            if (pipe2 == pipe) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getStateIndex(EList<State> eList, State state) {
        int n = -1;
        int n2 = 0;
        for (State state2 : eList) {
            if (state2 == state) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getPropertyIndex(EList<Property> eList, Property property) {
        int n = -1;
        int n2 = 0;
        for (Property property2 : eList) {
            if (property2 == property) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static String strReplaceSpecialCharToCode(String string) {
        if (string == null) {
            return null;
        }
        string = Utils.strReplace(string, "\"", "``").trim();
        string = Utils.strReplace(string, "'", "`").trim();
        return string;
    }

    public static String strReplaceSpecialCharToDisplay(String string) {
        if (string == null) {
            return null;
        }
        string = Utils.strReplace(string, "\\\"", "\"").trim();
        string = Utils.strReplace(string, "\\'", "'").trim();
        return string;
    }

    public static String strReplace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        int n = 0;
        while ((n = string.indexOf(string2, n)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n += string3.length();
        }
        return string;
    }

    public static String checkNameSyntax(String string, String string2, boolean bl) throws PogoException {
        return Utils.checkNameSyntax(string, string2, bl, false);
    }

    public static String checkNameSyntax(String string, String string2, boolean bl, boolean bl2) throws PogoException {
        int n;
        if (string == null || string.length() == 0) {
            throw new PogoException(string2 + " (" + string + ") not valid !");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + stringTokenizer.nextToken();
        }
        string = string3;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z' || c == '_') continue;
            throw new PogoException("Syntax error in " + string2 + ": Do not use '" + c + "' char.");
        }
        n = string.toUpperCase().charAt(0);
        if (!(n >= 65 && n <= 90 || n == 95 && bl2)) {
            throw new PogoException(string + ":\nSyntax error in " + string2 + ": The first char must be a letter");
        }
        if (!bl && (string.equals("State") || string.equals("Status"))) {
            throw new PogoException(string + "  is reserved");
        }
        return string;
    }

    public static String strBoolean(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String strBoolean(String string) {
        return Utils.isTrue(string) ? "true" : "false";
    }

    public static boolean isTrue(String string) {
        return string != null && string.equals("true");
    }

    public static boolean isFalse(String string) {
        return !Utils.isTrue(string);
    }

    public static boolean isSet(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean isEquals(String string, String string2) {
        return string != null && string2 != null && string.equals(string2);
    }

    public static boolean isExpert(Command command) {
        return Utils.isEquals(command.getDisplayLevel(), PogoConst.strLevel[1]);
    }

    public static boolean isExpert(Attribute attribute) {
        return Utils.isEquals(attribute.getDisplayLevel(), PogoConst.strLevel[1]);
    }

    public static void popupError(Component component, String string) {
        try {
            throw new PogoException(string);
        }
        catch (PogoException pogoException) {
            Utils.getInstance().stopSplashRefresher();
            pogoException.popup(component);
            return;
        }
    }

    public List<String> getFileList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return arrayList;
        }
        for (String string2 : stringArray) {
            String string3 = string + "/" + string2;
            File file2 = new File(string3);
            if (file2.isDirectory()) continue;
            arrayList.add(string2);
        }
        Collections.sort(arrayList, new StringCompare());
        return arrayList;
    }

    public static String searchFileFromDirectory(String string, String string2) {
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        for (String string3 : stringArray) {
            String string4 = string2 + "/" + string3;
            File file2 = new File(string4);
            if (file2.isDirectory()) {
                String string5 = Utils.searchFileFromDirectory(string, file2.toString());
                if (string5 == null) continue;
                return string5;
            }
            if (!string3.equals(string)) continue;
            return string4;
        }
        return null;
    }

    public static boolean osIsUnix() {
        String string = System.getProperty("os.name");
        return !string.toLowerCase().startsWith("windows");
    }

    public static void showInHtmBrowser(String string) {
        String string2 = System.getProperty("BROWSER");
        if (string2 == null) {
            string2 = Utils.osIsUnix() ? "firefox - turbo" : "explorer";
        }
        String string3 = string2 + " " + string;
        try {
            Utils.executeShellCmdAndReturn(string3);
        }
        catch (Exception exception) {
            PogoException.popup((Component)new JFrame(), exception.toString());
        }
    }

    public static void executeShellCmdAndReturn(String string) throws IOException {
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        new BufferedReader(new InputStreamReader(inputStream));
    }

    public static String getXmiFile(boolean bl) {
        String[] stringArray;
        File file = new File(".");
        for (String string : stringArray = file.list()) {
            if (!new File(string).isFile()) continue;
            if (!bl && string.endsWith(".xmi") && !string.contains(".multi.")) {
                return string;
            }
            if (!bl || !string.endsWith(".multi.xmi")) continue;
            return string;
        }
        return null;
    }

    static void manageHtmlDirectory(PogoDeviceClass pogoDeviceClass, boolean bl) {
        String string = "./doc_html";
        if (!PogoProperty.docHome.equals(string) && pogoDeviceClass.getDescription().getFilestogenerate().contains("html")) {
            File file = new File(pogoDeviceClass.getDescription().getSourcePath() + "/" + string);
            File file2 = new File(pogoDeviceClass.getDescription().getSourcePath() + "/" + PogoProperty.docHome);
            if (bl) {
                if (file2.renameTo(file)) {
                    System.err.println("Failed to move html dir to " + string);
                }
            } else if (file.renameTo(file2)) {
                System.err.println("Failed to move html dir to " + file2);
            }
        }
    }

    private static String getAbsolutePath(String string) {
        File file = new File(string);
        if (file.isFile()) {
            return file.getParent();
        }
        return file.getAbsolutePath();
    }

    public static String getRelativePath(String string, String string2) {
        int n;
        String string3 = System.getProperty("file.separator");
        string = Utils.getAbsolutePath(string);
        string2 = Utils.getAbsolutePath(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string2, string3);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken());
        }
        if (((String)arrayList2.get(0)).endsWith(":") && ((String)arrayList.get(0)).endsWith(":") && !((String)arrayList2.get(0)).equalsIgnoreCase((String)arrayList.get(0))) {
            return string;
        }
        for (int i = ((String)arrayList2.get(0)).equalsIgnoreCase((String)arrayList.get(0)) ? 1 : 0; i < arrayList2.size() && i < arrayList.size() && ((String)arrayList2.get(i)).equals(arrayList.get(i)); ++i) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = i; n < arrayList2.size(); ++n) {
            stringBuilder.append("..").append(string3);
        }
        for (n = i; n < arrayList.size(); ++n) {
            stringBuilder.append((String)arrayList.get(n)).append(string3);
        }
        String string4 = stringBuilder.toString();
        if (string4.endsWith(string3)) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if (!string4.startsWith("..")) {
            string4 = "./" + string4;
        }
        string4 = Utils.strReplace(string4, "\\", "/");
        while (string4.startsWith("././")) {
            string4 = string4.substring("./".length());
        }
        return string4;
    }

    public static String getAbsolutePath(String string, String string2) {
        String string3 = System.getProperty("file.separator");
        string2 = Utils.getAbsolutePath(string2);
        return new File(string2 + string3 + string).getAbsolutePath();
    }

    public static void main(String[] stringArray) {
        String string = "../../CounterTimer/trunk/src";
        String string2 = "Y:/tango/tmp/pascal/rel_path/SimCounterTimer/trunk/SimCounterTimer.xmi";
        String string3 = "y:/tango/tmp/pascal/rel_path/CounterTimer/trunk/src";
        System.out.println("Absolute: " + Utils.getAbsolutePath(string, string2));
        System.out.println("Relative: " + Utils.getRelativePath(string3, string2));
    }

    public static String buildToolTip(String string) {
        return Utils.buildToolTip(null, string);
    }

    public static String buildToolTip(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(tooltipHeader);
        if (string != null && string.length() > 0) {
            stringBuilder.append("<b><Center>").append(Utils.strReplace(string, "\n", "<br>\n")).append("</center></b><HR WIDTH=\"100%\">");
        }
        if (string2 != null && string2.length() > 0) {
            string2 = Utils.strReplace(string2, "\n", "<br>\n");
            string2 = Utils.strReplace(string2, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static Color getForeground4State(String string) {
        Color color;
        if (foregroundMap == null) {
            foregroundMap = new HashMap();
            foregroundMap.put("ON", Color.black);
            foregroundMap.put("OFF", Color.black);
            foregroundMap.put("CLOSE", Color.black);
            foregroundMap.put("OPEN", Color.black);
            foregroundMap.put("INSERT", Color.black);
            foregroundMap.put("EXTRACT", Color.black);
            foregroundMap.put("MOVING", Color.white);
            foregroundMap.put("STANDBY", Color.black);
            foregroundMap.put("FAULT", Color.white);
            foregroundMap.put("INIT", Color.black);
            foregroundMap.put("RUNNING", Color.white);
            foregroundMap.put("ALARM", Color.black);
            foregroundMap.put("DISABLE", Color.black);
            foregroundMap.put("UNKNOWN", Color.white);
        }
        if ((color = foregroundMap.get(string)) == null) {
            color = foregroundMap.get("UNKNOWN");
        }
        return color;
    }

    public static Color getColor4State(String string) {
        Color color;
        if (stateMap == null) {
            stateMap = new HashMap();
            stateMap.put("ON", new Color(0, 255, 0));
            stateMap.put("OFF", new Color(255, 255, 255));
            stateMap.put("CLOSE", new Color(255, 255, 255));
            stateMap.put("OPEN", new Color(0, 255, 0));
            stateMap.put("INSERT", new Color(255, 255, 255));
            stateMap.put("EXTRACT", new Color(0, 255, 0));
            stateMap.put("MOVING", new Color(128, 160, 255));
            stateMap.put("STANDBY", new Color(255, 255, 0));
            stateMap.put("FAULT", new Color(255, 0, 0));
            stateMap.put("INIT", new Color(204, 204, 122));
            stateMap.put("RUNNING", new Color(0, 125, 0));
            stateMap.put("ALARM", new Color(255, 140, 0));
            stateMap.put("DISABLE", new Color(255, 0, 255));
            stateMap.put("UNKNOWN", new Color(125, 125, 125));
        }
        if ((color = stateMap.get(string)) == null) {
            color = stateMap.get("UNKNOWN");
        }
        return color;
    }

    private void createSplash() {
        try {
            if (tango_icon == null) {
                tango_icon = this.getIcon("TangoSplash.gif");
            }
            JSmoothProgressBar jSmoothProgressBar = new JSmoothProgressBar();
            jSmoothProgressBar.setStringPainted(true);
            jSmoothProgressBar.setBackground(Color.lightGray);
            jSmoothProgressBar.setProgressBarColors(Color.gray, Color.lightGray, Color.darkGray);
            splash = new Splash(tango_icon, Color.black, jSmoothProgressBar);
            splash.setMessage("POGO: Tango code generator");
            splash.setMaxProgress(100);
            splash.setTitle("POGO");
            splash.setCopyright("9.2.9b  -  04-08-2016  15:23:08");
        }
        catch (Exception exception) {
            useDisplay = false;
            System.err.println("Cannot create Splah: " + exception);
        }
    }

    public void stopSplashRefresher() {
        if (splash != null && useDisplay) {
            this.splash_refresher.setSplashOn(false, "");
        }
    }

    public void startSplashRefresher(String string) {
        String string2;
        if (!this.splashInit && (string2 = System.getenv("Classes2www")) != null && string2.equals("true")) {
            useDisplay = false;
        }
        this.splashInit = true;
        if (splash == null && useDisplay) {
            this.createSplash();
        }
        if (!useDisplay) {
            splash = null;
        }
        if (useDisplay) {
            splashOn = true;
            this.splash_refresher = new SplashRefresher();
            this.splash_refresher.start();
            this.splash_refresher.setSplashOn(true, string);
        }
    }

    static {
        useDisplay = true;
    }

    class StringCompare
    implements Comparator<String> {
        StringCompare() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }

    private class SplashRefresher
    extends Thread {
        private SplashRefresher() {
        }

        private synchronized void setSplashOn(boolean bl, String string) {
            if (useDisplay) {
                splashOn = bl;
                splash.setMessage(string);
            }
        }

        @Override
        public void run() {
            int n = 1;
            splash.initProgress();
            splash.setVisible(true);
            splash.repaint();
            while (splashOn) {
                splash.progress(n);
                if (n++ > 98) {
                    n = 10;
                }
                this.doSleep(100L);
            }
            splash.progress(100);
            splash.setVisible(false);
        }

        private synchronized void doSleep(long l) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

