/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.tools.Utils;

public class StateMachineTable
extends JTable {
    private EList<Command> commands = null;
    private EList<Command> dynCommands = null;
    private EList<Attribute> attributes = null;
    private EList<Attribute> dynAttributes = null;
    private EList<Pipe> pipes = null;
    private EList<State> stateList;
    private List<String> columnNames = new ArrayList<String>();
    private List<RowItem> itemList = new ArrayList<RowItem>();
    private TablePopupMenu popupMenu = new TablePopupMenu(this);
    private int width = 0;
    private static Color headerBackground;
    private boolean sortUp = true;
    public static final int COMMAND = 0;
    public static final int ATTRIBUTE = 1;
    public static final int PIPE = 2;
    private static final String[] ItemNames;
    private static final int FIRST_COLUMN_WIDTH = 200;
    private static final int STATE_COLUMN_WIDTH = 60;
    public static final int MAX_HEIGHT = 500;
    private static final Boolean READ;
    private static final Boolean WRITE;
    private int selectedColumn;
    private int selectedRow;
    private static final int SELECT_ALL = 0;
    private static final int RESET_ALL = 1;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public StateMachineTable(PogoDeviceClass pogoDeviceClass, int n) {
        this.stateList = pogoDeviceClass.getStates();
        this.columnNames.add(ItemNames[n]);
        for (State eObject : this.stateList) {
            this.columnNames.add(eObject.getName());
        }
        switch (n) {
            case 0: {
                this.commands = pogoDeviceClass.getCommands();
                this.dynCommands = pogoDeviceClass.getDynamicCommands();
                this.manageCommands(this.commands);
                this.manageCommands(this.dynCommands);
                break;
            }
            case 1: {
                this.attributes = pogoDeviceClass.getAttributes();
                this.dynAttributes = pogoDeviceClass.getDynamicAttributes();
                this.manageAttribute(this.attributes);
                this.manageAttribute(this.dynAttributes);
                break;
            }
            case 2: {
                this.pipes = pogoDeviceClass.getPipes();
                for (Pipe pipe : this.pipes) {
                    this.itemList.add(new RowItem(pipe.getName(), pipe.getReadExcludedStates(), READ));
                    boolean bl = !pipe.getRwType().equals(PogoConst.AttrRWtypeArray[0]);
                    if (!bl) continue;
                    this.itemList.add(new RowItem(pipe.getName(), pipe.getWriteExcludedStates(), WRITE));
                }
                break;
            }
        }
        this.buildTable();
    }

    private void manageCommands(EList<Command> eList) {
        for (Command command : eList) {
            String string = command.getName();
            if (string.equals("State") || string.equals("Status")) continue;
            this.itemList.add(new RowItem(string, command.getExcludedStates()));
        }
    }

    private void manageAttribute(EList<Attribute> eList) {
        for (Attribute attribute : eList) {
            this.itemList.add(new RowItem(attribute.getName(), attribute.getReadExcludedStates(), READ));
            boolean bl = !attribute.getRwType().equals(PogoConst.AttrRWtypeArray[0]);
            if (!bl) continue;
            this.itemList.add(new RowItem(attribute.getName(), attribute.getWriteExcludedStates(), WRITE));
        }
    }

    public Dimension getDimension(JDialog jDialog) {
        jDialog.pack();
        int n = this.getHeight() + 30;
        if (n > 500) {
            n = 500;
        }
        return new Dimension(this.width, n);
    }

    private void buildTable() {
        this.setModel(new DataTableModel());
        this.setDefaultRenderer(String.class, new LabelCellRenderer());
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                StateMachineTable.this.tableActionPerformed(mouseEvent);
            }
        });
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2 = n++ == 0 ? 200 : 60;
            this.width += n2;
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(n2);
        }
        this.width += 20;
        this.getTableHeader().setDefaultRenderer(new LabelHeaderRenderer());
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                StateMachineTable.this.tableHeaderActionPerformed(mouseEvent);
            }
        });
        headerBackground = this.getTableHeader().getBackground();
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        int n3 = mouseEvent.getModifiers();
        if ((n3 & 0x10) != 0) {
            if (n2 > 0) {
                RowItem rowItem = this.itemList.get(n);
                rowItem.toggleAllowed(--n2);
                this.repaint();
            }
        } else if ((n3 & 4) != 0) {
            this.selectedRow = n;
            this.popupMenu.showMenu(mouseEvent, false);
        }
    }

    private void tableHeaderActionPerformed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        this.selectedColumn = this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if ((n & 4) != 0) {
            if (this.selectedColumn > 0) {
                this.popupMenu.showMenu(mouseEvent, true);
            }
        } else if ((n & 0x10) != 0 && this.selectedColumn == 0) {
            Collections.sort(this.itemList, new RowItemComparator());
            this.sortUp = !this.sortUp;
        }
    }

    private void setAllFor(boolean bl, boolean bl2) {
        if (bl2) {
            for (RowItem rowItem : this.itemList) {
                rowItem.setAllowed(this.selectedColumn - 1, bl);
            }
        } else {
            this.itemList.get(this.selectedRow).setAllowed(bl);
        }
        this.repaint();
    }

    private void updateExcluded(String string) {
        for (RowItem rowItem : this.itemList) {
            if (!rowItem.name.equals(string)) continue;
            rowItem.updateExcluded();
        }
    }

    public void updateExcluded() {
        if (this.commands != null) {
            for (Command eObject : this.commands) {
                this.updateExcluded(eObject.getName());
            }
        }
        if (this.dynCommands != null) {
            for (Command command : this.dynCommands) {
                this.updateExcluded(command.getName());
            }
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                this.updateExcluded(attribute.getName());
            }
        }
        if (this.dynAttributes != null) {
            for (Attribute attribute : this.dynAttributes) {
                this.updateExcluded(attribute.getName());
            }
        }
        if (this.pipes != null) {
            for (Pipe pipe : this.pipes) {
                this.updateExcluded(pipe.getName());
            }
        }
    }

    static {
        ItemNames = new String[]{"Commands", "Attributes", "Pipes"};
        READ = false;
        WRITE = true;
        menuLabels = new String[]{"Select ALL", "Un select ALL"};
    }

    private class RowItemComparator
    implements Comparator<RowItem> {
        private RowItemComparator() {
        }

        @Override
        public int compare(RowItem rowItem, RowItem rowItem2) {
            switch (StateMachineTable.this.selectedColumn) {
                case 0: {
                    return this.alphabeticalSort(rowItem.toString(), rowItem2.toString());
                }
            }
            return 0;
        }

        private int alphabeticalSort(String string, String string2) {
            if (StateMachineTable.this.sortUp) {
                if (string == null) {
                    return 1;
                }
                if (string2 == null) {
                    return -1;
                }
                return string.compareTo(string2);
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string2.compareTo(string);
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JLabel title;
        private JTable table;
        private boolean forState;

        private TablePopupMenu(JTable jTable) {
            this.table = jTable;
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TablePopupMenu.this.menuActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        private void showMenu(MouseEvent mouseEvent, boolean bl) {
            this.forState = bl;
            if (bl) {
                this.title.setText((String)StateMachineTable.this.columnNames.get(StateMachineTable.this.selectedColumn));
                this.show(this.table.getTableHeader(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.title.setText(((RowItem)StateMachineTable.this.itemList.get(StateMachineTable.this.selectedRow)).toString());
                this.show(this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void menuActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = -1;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    StateMachineTable.this.setAllFor(true, this.forState);
                    break;
                }
                case 1: {
                    StateMachineTable.this.setAllFor(false, this.forState);
                }
            }
        }
    }

    public class LabelHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        public LabelHeaderRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
            this.setBorder(new MatteBorder(null));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            switch (n2) {
                case 0: {
                    this.setText("");
                    this.setBackground(headerBackground);
                    break;
                }
                default: {
                    String string = (String)StateMachineTable.this.columnNames.get(n2);
                    this.setText(string);
                    this.setBackground(Utils.getColor4State((String)StateMachineTable.this.columnNames.get(n2)));
                    this.setForeground(Utils.getForeground4State((String)StateMachineTable.this.columnNames.get(n2)));
                }
            }
            return this;
        }
    }

    public class LabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelCellRenderer() {
            this.setFont(new Font("Dialog", 1, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(((RowItem)StateMachineTable.this.itemList.get(n)).toString());
            this.setBackground(headerBackground);
            return this;
        }
    }

    public class DataTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return StateMachineTable.this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return StateMachineTable.this.itemList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n >= this.getColumnCount()) {
                return (String)StateMachineTable.this.columnNames.get(this.getColumnCount() - 1);
            }
            return (String)StateMachineTable.this.columnNames.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return StateMachineTable.this.itemList.get(n);
            }
            RowItem rowItem = (RowItem)StateMachineTable.this.itemList.get(n);
            return rowItem.allowed[--n2];
        }

        public Class getColumnClass(int n) {
            if (StateMachineTable.this.isVisible()) {
                if (n == 0) {
                    return String.class;
                }
                return Boolean.class;
            }
            return null;
        }
    }

    private class RowItem {
        private String name;
        private boolean write = false;
        private boolean display = false;
        private Boolean[] allowed;
        private EList<String> excluded;

        private RowItem(String string, EList<String> eList) {
            this.name = string;
            this.excluded = eList;
            this.manageAllowed(eList);
        }

        private RowItem(String string, EList<String> eList, boolean bl) {
            this.name = string;
            this.write = bl;
            this.display = true;
            this.excluded = eList;
            this.manageAllowed(eList);
        }

        private void manageAllowed(EList<String> eList) {
            this.allowed = new Boolean[StateMachineTable.this.stateList.size()];
            int n = 0;
            for (State state : StateMachineTable.this.stateList) {
                this.allowed[n++] = this.isAllowed(state.getName(), eList);
            }
        }

        private boolean isAllowed(String string, EList<String> eList) {
            boolean bl = false;
            for (String string2 : eList) {
                if (!string2.equals(string)) continue;
                bl = true;
            }
            return !bl;
        }

        private void setAllowed(boolean bl) {
            for (int i = 0; i < this.allowed.length; ++i) {
                this.allowed[i] = bl;
            }
        }

        private void setAllowed(int n, boolean bl) {
            this.allowed[n] = bl;
        }

        private void toggleAllowed(int n) {
            this.allowed[n] = this.allowed[n] == false;
        }

        private void updateExcluded() {
            this.excluded.clear();
            int n = 0;
            Boolean[] booleanArray = this.allowed;
            int n2 = booleanArray.length;
            for (int i = 0; i < n2; ++i) {
                boolean bl = booleanArray[i];
                if (!bl) {
                    this.excluded.add(((State)StateMachineTable.this.stateList.get(n)).getName());
                }
                ++n;
            }
        }

        public String toString() {
            if (this.display) {
                return this.name + (this.write ? " (Write)" : " (Read)");
            }
            return this.name;
        }
    }
}

