/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PopupTable
extends JDialog {
    private static String[] col_names;
    private List<List<String>> data;
    private JLabel titleLabel;
    private JTable my_table;
    private JScrollPane scrollPane;

    public PopupTable(JDialog jDialog, String string, String[] stringArray, List<List<String>> list) {
        super((Dialog)jDialog, false);
        this.buildObject(string, stringArray, list);
    }

    public PopupTable(JFrame jFrame, String string, String[] stringArray, List<List<String>> list) {
        super((Frame)jFrame, false);
        this.buildObject(string, stringArray, list);
    }

    private void buildObject(String string, String[] stringArray, List<List<String>> list) {
        col_names = stringArray;
        this.initComponents();
        this.data = list;
        this.initMyComponents();
        this.titleLabel.setText(string);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PopupTable.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupTable.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void initMyComponents() {
        DataTableModel dataTableModel = new DataTableModel();
        JTable jTable = new JTable(dataTableModel);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        jTable.setDragEnabled(false);
        jTable.setSelectionMode(0);
        jTable.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.scrollPane = new JScrollPane(jTable);
        this.scrollPane.setPreferredSize(new Dimension(650, 450));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.my_table = jTable;
        dataTableModel.fireTableDataChanged();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.scrollPane.setPreferredSize(dimension);
    }

    public void setPreferredSize(int[] nArray, int n) {
        Enumeration<TableColumn> enumeration = this.my_table.getColumnModel().getColumns();
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n3]);
            n2 += nArray[n3];
            ++n3;
        }
        n3 = (n + 2) * 16;
        this.scrollPane.setPreferredSize(new Dimension(n2, n3));
        this.pack();
    }

    public void setColumnWidth(int[] nArray) {
        Enumeration<TableColumn> enumeration = this.my_table.getColumnModel().getColumns();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n2]);
            n += nArray[n2];
            ++n2;
        }
        Dimension dimension = this.scrollPane.getPreferredSize();
        dimension.width = n;
        System.out.println(dimension.width + ", " + dimension.height);
        this.scrollPane.setPreferredSize(dimension);
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public class DataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8416336946761607744L;

        @Override
        public int getColumnCount() {
            return col_names.length;
        }

        @Override
        public int getRowCount() {
            return PopupTable.this.data.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n >= this.getColumnCount()) {
                return col_names[this.getColumnCount() - 1];
            }
            return col_names[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < PopupTable.this.data.size()) {
                if (n2 < ((List)PopupTable.this.data.get(n)).size()) {
                    return ((List)PopupTable.this.data.get(n)).get(n2);
                }
                return "";
            }
            return "";
        }
    }
}

