/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class PopupHtml
extends JDialog {
    protected JFrame parent;
    protected JEditorPane pane;
    private String urlFile;
    private static final String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> title </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n";
    private static final String footer = "</Body>\n</Html>\n";

    public PopupHtml(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initComponents();
        this.parent = jFrame;
        this.pack();
        if (jFrame != null && jFrame.isVisible() && jFrame.getWidth() > 0) {
            Point point = jFrame.getLocationOnScreen();
            point.x += 10;
            point.y += 10;
            this.setLocation(point);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JButton jButton = new JButton();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PopupHtml.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        jLabel.setText("                     ");
        jPanel.add(jLabel);
        jButton.setText("Dismiss");
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupHtml.this.dismissBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
    }

    protected synchronized void setPage(URL uRL) {
        try {
            this.pane.setCursor(new Cursor(3));
            this.pane.setPage(uRL);
        }
        catch (IOException iOException) {
            PogoException.popup((Component)this.parent, iOException);
        }
        this.pane.setCursor(new Cursor(0));
    }

    private String buildTmpFile(String string) {
        String string2 = null;
        try {
            int n = new Random().nextInt(30000);
            String string3 = System.getProperty("java.io.tmpdir");
            this.urlFile = string3 + "/html." + n;
            ParserTool.writeFile(this.urlFile, header + string + footer);
            string2 = "file:" + this.urlFile;
        }
        catch (Exception exception) {
            PogoException.popup((Component)this.parent, exception);
            exception.printStackTrace();
        }
        return string2;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void dismissBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void doClose() {
        try {
            if (!new File(this.urlFile).delete()) {
                System.err.println("Cannot delete " + this.urlFile);
            }
        }
        catch (Exception exception) {
            PogoException.popup((Component)this.parent, exception);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void show(String string) {
        this.show(string, 700, 750);
    }

    public void show(String string, int n, int n2) {
        try {
            this.pane = new JEditorPane();
            this.pane.setEditable(false);
            this.pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                }
            });
            this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
            this.setSize(n, n2);
            URL uRL = new URL(this.buildTmpFile(string));
            this.setPage(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return;
        }
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
    }
}

