/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PopupColorCode
extends JDialog {
    private final InherStatus[] inherSatus;
    private JPanel centerPanel;
    private JLabel titleLabel;

    public PopupColorCode(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.inherSatus = new InherStatus[]{new InherStatus(Utils.getInstance().abstractIcon, "Abstract item inherited from parent class"), new InherStatus(Utils.getInstance().inheritedIcon, "Concrete item inherited from parent class"), new InherStatus(Utils.getInstance().overloadedIcon, "Concrete item defined in this class")};
        this.initComponents();
        this.buildColorPanel();
        this.titleLabel.setText("Pogo color code");
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void buildColorPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        this.centerPanel.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        for (InherStatus inherStatus : this.inherSatus) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            this.centerPanel.add((Component)new JLabel(inherStatus.icon), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            this.centerPanel.add((Component)new JLabel(inherStatus.description), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 1;
        this.centerPanel.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.centerPanel.add((Component)new JLabel("Value"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.centerPanel.add((Component)new JLabel("Item can be controlled by expert and operator level."), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        Object object = new JLabel("Value");
        ((JComponent)object).setForeground(Color.blue);
        this.centerPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.centerPanel.add((Component)new JLabel("Item can be controlled by expert only."), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        object = new JLabel("Value");
        ((JComponent)object).setForeground(Color.red);
        this.centerPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.centerPanel.add((Component)new JLabel("Inheritance item type has changed."), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.centerPanel.add((Component)new JSeparator(), gridBagConstraints);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PopupColorCode.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupColorCode.this.dismisslBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
    }

    private void dismisslBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new PopupColorCode(new JFrame()).setVisible(true);
    }

    private class InherStatus {
        private ImageIcon icon;
        private String description;

        private InherStatus(ImageIcon imageIcon, String string) {
            this.icon = imageIcon;
            this.description = string;
        }
    }
}

