/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoProperty {
    private static final String packname = "org.tango.pogo";
    private static final String defPropFilename = "/Pogo.default_properties";
    private static final String sitePropFilename = "/Pogo.site_properties";
    private static PogoProperty instance = null;
    public static List<String> classFamilies = new ArrayList<String>();
    public static List<String> platformNames = new ArrayList<String>();
    public static List<String> busNames = new ArrayList<String>();
    private static final String copyrightProp = "copyright";
    private static final String docHomeProp = "doc_home";
    private static final String makefileHomeProp = "makefile_home";
    private static final String installHomeProp = "install_home";
    private static final String classFamiliesProp = "class_families";
    private static final String platformNamesProp = "platform_names";
    private static final String busNamesProp = "bus_names";
    private static final String siteNameProp = "site.name";
    private static final String siteClassFamiliesProp = "site.class_families";
    public static String siteName = null;
    public static String copyright = "";
    public static String docHome = "./doc_html";
    public static String makefileHome = "$(TANGO_HOME)";
    public static String installHome = "$(TANGO_HOME)";
    public static List<String> siteClassFamilies = new ArrayList<String>();
    private static final int ownHistoSize = 20;
    private static final String ownInheritanceHome = "hinerit_home";
    private static final String ownContactAddress = "contact_address";
    private static final String ownLoadPrevious = "load_previous";
    private static final String ownProjectHistory = "project_history";
    private static final String multiProjectHistory = "multi_class_project_history";
    public static String inheritHome = null;
    public static String contactAddress = "";
    public static boolean loadPrevious = true;
    public static List<String> projectHistory = new ArrayList<String>();
    public static List<String> multiClassProjectHistory = new ArrayList<String>();
    public static final Object monitor = new Object();

    public static PogoProperty getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PogoProperty init() throws PogoException {
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                instance = new PogoProperty();
            }
        }
        return instance;
    }

    private PogoProperty() throws PogoException {
        this.checkEnvironment();
        this.loadDefaultProperties();
        this.loadSiteProperties();
        this.loadPogoRcProperties();
        this.displayProperties();
    }

    private void checkEnvironment() {
        String string = System.getProperty("java.class.path");
        if (Utils.osIsUnix()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            string = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (file.exists()) {
                    string = string + string2 + ":";
                    continue;
                }
                System.err.println(string2 + " found in classpath,  does not exist !!!");
            }
            if (string.endsWith(":")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        System.setProperty("java.class.path", string);
    }

    private void loadDefaultProperties() throws PogoException {
        try {
            List<String> list = this.loadProperties(defPropFilename);
            classFamilies = this.getStringListProperty(classFamiliesProp, list);
            platformNames = this.getStringListProperty(platformNamesProp, list);
            busNames = this.getStringListProperty(busNamesProp, list);
            installHome = this.checkOverwritingPropertyString(installHomeProp, installHome, list);
            classFamilies.add(0, "");
            busNames.add(0, "");
        }
        catch (Exception exception) {
            if (exception instanceof PogoException) {
                throw (PogoException)exception;
            }
            throw new PogoException(exception.toString());
        }
    }

    private void loadSiteProperties() {
        try {
            List<String> list = this.loadSiteProperties(sitePropFilename);
            siteName = this.getStringProperty(siteNameProp, list);
            copyright = this.checkOverwritingLinesProperty(copyrightProp, list);
            docHome = this.checkOverwritingPropertyString(docHomeProp, docHome, list);
            makefileHome = this.checkOverwritingPropertyString(makefileHomeProp, makefileHome, list);
            siteClassFamilies = this.getStringListProperty(siteClassFamiliesProp, list);
        }
        catch (Exception exception) {
            System.err.println("\nWARNING:\tNo site specific properties file found !\n");
        }
    }

    private String checkOverwritingLinesProperty(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string2 = "org.tango.pogo." + string + ":";
        for (String object : list) {
            if (object.startsWith(string2)) {
                bl = true;
            } else if (object.startsWith(packname)) {
                bl = false;
            }
            if (!bl) continue;
            if (object.startsWith(string2)) {
                arrayList.add(object.substring(string2.length()).trim());
                continue;
            }
            arrayList.add(object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : arrayList) {
            stringBuilder.append(string3).append("\n");
        }
        return stringBuilder.toString().trim();
    }

    private void loadPogoRcProperties() {
        try {
            String string = PogoProperty.getPogoRCname();
            if (string != null) {
                System.out.println(string);
                List<String> list = this.loadPropertiesRC(string);
                projectHistory = this.getStringListProperty(ownProjectHistory, list);
                multiClassProjectHistory = this.getStringListProperty(multiProjectHistory, list);
                inheritHome = this.getStringProperty(ownInheritanceHome, list);
                contactAddress = this.getStringProperty(ownContactAddress, list);
                String string2 = this.getStringProperty(ownLoadPrevious, list);
                loadPrevious = Utils.isTrue(string2);
                if (projectHistory.size() > 0 && projectHistory.get(0).length() == 0) {
                    projectHistory.remove(0);
                }
                if (multiClassProjectHistory.size() > 0 && multiClassProjectHistory.get(0).length() == 0) {
                    multiClassProjectHistory.remove(0);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("\nWARNING:\t" + exception);
        }
    }

    private String checkOverwritingPropertyString(String string, String string2, List<String> list) {
        String string3 = this.getStringProperty(string, list);
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    private static String getPogoRCname() {
        String string = System.getenv("HOME");
        if (string == null) {
            string = System.getenv("TANGO_ROOT");
        }
        if (string == null) {
            return null;
        }
        return string + "/.pogorc";
    }

    private List<String> loadSiteProperties(String string) throws PogoException, IOException {
        String string2;
        URL uRL = this.getClass().getResource(string);
        System.out.println("Reading properties from " + uRL.getFile());
        InputStream inputStream = uRL.openStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.startsWith("#") || string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    private List<String> loadProperties(String string) throws PogoException, IOException {
        String string2;
        URL uRL = this.getClass().getResource(string);
        System.out.println("Reading properties from " + uRL.getFile());
        InputStream inputStream = uRL.openStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).startsWith("#") || string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    private List<String> loadPropertiesRC(String string) throws PogoException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = ParserTool.readFile(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private List<String> getStringListProperty(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string2 : list) {
            if (string2.trim().startsWith("#")) continue;
            if (!bl) {
                int n;
                if (!string2.startsWith("org.tango.pogo." + string) || (n = string2.indexOf(58)) <= 0) continue;
                bl = true;
                arrayList.add(string2.substring(n + 1).trim());
                continue;
            }
            if (string2.trim().indexOf(58) > 2) {
                bl = false;
                continue;
            }
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getStringProperty(String string, List<String> list) {
        for (String string2 : list) {
            int n;
            if (!string2.startsWith("org.tango.pogo." + string) || (n = string2.indexOf(58)) <= 0) continue;
            String string3 = string2.substring(n + 1).trim();
            if (string3.length() > 0) {
                return string3;
            }
            return null;
        }
        return null;
    }

    public void displayProperties() {
        String string = System.getProperty("DEBUG_PROP");
        if (string != null && string.equals("true")) {
            this.displayProperty(classFamiliesProp, classFamilies);
            this.displayProperty(platformNamesProp, platformNames);
            this.displayProperty(busNamesProp, busNames);
        }
        this.displayProperty(docHomeProp, docHome);
        this.displayProperty(makefileHomeProp, makefileHome);
        this.displayProperty(installHomeProp, installHome);
        this.displayProperty(siteNameProp, siteName);
        this.displayProperty(copyrightProp, copyright);
        if (string != null && string.equals("true")) {
            this.displayProperty(siteClassFamiliesProp, siteClassFamilies);
        }
    }

    private void displayProperty(String string, String string2) {
        System.out.println(string + ":\t" + string2);
    }

    private void displayProperty(String string, List<String> list) {
        System.out.print(string + ":");
        for (String string2 : list) {
            System.out.println("\t" + string2);
        }
        System.out.println();
    }

    public static void addProject(String string, int n) {
        if (n == 0) {
            for (int i = 0; i < projectHistory.size(); ++i) {
                if (!projectHistory.get(i).equals(string)) continue;
                projectHistory.remove(i);
            }
            projectHistory.add(0, string);
            while (projectHistory.size() > 20) {
                projectHistory.remove(19);
            }
        } else {
            for (int i = 0; i < multiClassProjectHistory.size(); ++i) {
                if (!multiClassProjectHistory.get(i).equals(string)) continue;
                multiClassProjectHistory.remove(i);
            }
            multiClassProjectHistory.add(0, string);
            while (multiClassProjectHistory.size() > 20) {
                multiClassProjectHistory.remove(19);
            }
        }
        PogoProperty.updatePogoRC();
    }

    private static String buildPropertyLine(String string) {
        return "org.tango.pogo." + string + ":\t";
    }

    public static void updatePogoRC() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#\n");
        stringBuilder.append("#       This is the Pogo user preferences file\n");
        stringBuilder.append("#\n\n");
        stringBuilder.append(PogoProperty.buildPropertyLine(ownInheritanceHome)).append(inheritHome);
        stringBuilder.append("\n");
        stringBuilder.append(PogoProperty.buildPropertyLine(ownContactAddress)).append(contactAddress);
        stringBuilder.append("\n");
        stringBuilder.append(PogoProperty.buildPropertyLine(ownLoadPrevious)).append(loadPrevious);
        stringBuilder.append("\n\n");
        stringBuilder.append(PogoProperty.buildPropertyLine(ownProjectHistory)).append('\n');
        for (String string2 : projectHistory) {
            stringBuilder.append('\t').append(string2).append('\n');
        }
        stringBuilder.append("\n\n");
        stringBuilder.append(PogoProperty.buildPropertyLine(multiProjectHistory)).append('\n');
        for (String string2 : multiClassProjectHistory) {
            stringBuilder.append('\t').append(string2).append('\n');
        }
        String string3 = PogoProperty.getPogoRCname();
        string2 = "";
        try {
            string2 = ParserTool.readFile(string3);
        }
        catch (Exception exception) {
            System.err.println("\nWARNING:\t" + exception);
        }
        try {
            if (!string2.equals(stringBuilder.toString())) {
                ParserTool.writeFile(string3, stringBuilder.toString());
                System.out.println((String)string3 + " updated");
            }
        }
        catch (Exception exception) {
            System.err.println("\nWARNING:\t" + exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateSitePropertyFile(Component component) throws PogoException {
        int n;
        Object object;
        URL uRL = this.getClass().getResource(sitePropFilename);
        String string = null;
        boolean bl = true;
        if (uRL == null) {
            bl = false;
            Utils.popupError(new JFrame(), "URL for property file (/Pogo.site_properties) is unknown !\n\nSelect a directory to write property file.\nIt will have to be added in  your CLASSPATH environment.");
            object = new JFileChooser();
            ((JFileChooser)object).setFileSelectionMode(1);
            if (((JFileChooser)object).showDialog(component, "Target Dir.") != 0) return false;
            File file = ((JFileChooser)object).getSelectedFile();
            if (file != null && file.isDirectory()) {
                string = file.getAbsolutePath() + sitePropFilename;
            }
        } else {
            string = uRL.toString();
            if (string.startsWith("file:")) {
                string = string.substring("file:".length());
            }
        }
        object = ParserTool.readFile(string);
        boolean bl2 = false;
        int n2 = ((String)object).indexOf(siteNameProp);
        if (n2 > 0) {
            n2 = ((String)object).indexOf(58, n2) + 1;
            n = ((String)object).indexOf(10, n2);
            object = ((String)object).substring(0, n2) + "  " + (siteName == null ? "" : siteName) + ((String)object).substring(n);
            bl2 = true;
        }
        if (copyright != null && !copyright.isEmpty()) {
            n2 = ((String)object).indexOf(copyrightProp);
            if (n2 > 0) {
                n = ((String)object).indexOf("#", n2);
                if (n < 0) {
                    n = ((String)object).indexOf(packname, n2);
                }
                object = n > 0 ? ((String)object).substring(0, n2) + copyrightProp + ":\n" + copyright + "\n\n" + ((String)object).substring(n) : ((String)object).substring(0, n2) + copyrightProp + ":\n" + copyright + "\n";
            } else {
                object = (String)object + "#\n#\tCopyright for generated Tango classes\n#\norg.tango.pogo.copyright:\n" + copyright + "\n";
            }
            bl2 = true;
        }
        if ((n2 = ((String)object).indexOf(siteClassFamiliesProp)) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < siteClassFamiliesProp.length() + packname.length() + 3; ++i) {
                stringBuilder.append(' ');
            }
            StringBuilder stringBuilder2 = new StringBuilder("  ");
            for (String string2 : siteClassFamilies) {
                stringBuilder2.append(string2).append('\n').append((CharSequence)stringBuilder);
            }
            String string3 = "  " + stringBuilder2.toString().trim() + '\n';
            n2 = ((String)object).indexOf(58, n2) + 1;
            int n3 = ((String)object).indexOf(35, n2);
            object = ((String)object).substring(0, n2) + (String)string3 + ((String)object).substring(n3);
            bl2 = true;
        }
        if (!bl2) return true;
        System.out.println("writing  " + string);
        ParserTool.writeFile(string, (String)object);
        if (bl) return true;
        JOptionPane.showMessageDialog(component, "File " + string + "has been written\n\n" + "Add the directory to your CLASSPATH environment to be re-loaded by Pogo !", "Help Window", 1);
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            PogoProperty.init().displayProperties();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

