/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class PogoParser {
    private String fileCode;
    private String filename;
    static final String start_protected = "PROTECTED REGION ID(";
    static final String start_protected_enabled = "ENABLED START";
    static final String end_protected = "PROTECTED REGION END";

    public PogoParser(String string) throws PogoException {
        this.filename = string;
        this.fileCode = ParserTool.readFile(string);
    }

    public void write() throws PogoException {
        ParserTool.writeFile(this.filename, this.fileCode);
    }

    public boolean codeExists(String string) {
        return this.fileCode.contains(string);
    }

    public void insertInProtectedZone(String string, String string2, String string3) {
        this.insertInProtectedZone(string, string2, string3, "::");
    }

    public void insertInProtectedZone(String string, String string2, String string3, String string4) {
        int[] nArray;
        if (string3 == null || string3.length() == 0) {
            return;
        }
        String string5 = start_protected;
        if (string != null && string.length() > 0) {
            string5 = string5 + string + string4;
        }
        if ((nArray = this.indexesOfProtectedZone(string5 = string5 + string2 + ") " + start_protected_enabled)) != null) {
            this.fileCode = this.fileCode.substring(0, nArray[1]).trim() + '\n' + string3 + '\n' + this.fileCode.substring(nArray[1]);
        } else {
            System.err.println(string5 + " not found");
        }
    }

    public void replaceInProtectedZone(String string, String string2, String string3, String string4) {
        if (string3 == null || string3.length() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(start_protected);
        if (string != null && string.length() > 0) {
            stringBuilder.append(string).append(string4);
        }
        stringBuilder.append(string2).append(") ").append(start_protected_enabled);
        int[] nArray = this.indexesOfProtectedZone(stringBuilder.toString());
        if (nArray != null) {
            this.fileCode = this.fileCode.substring(0, nArray[0]).trim() + '\n' + string3 + this.fileCode.substring(nArray[1]);
        } else {
            System.err.println(stringBuilder + " not found");
        }
    }

    public void insertInProtectedZoneAtEnd(String string, String string2, String string3) {
        if (string3 == null || string3.length() == 0) {
            return;
        }
        String string4 = start_protected + string + "::" + string2 + ") " + start_protected_enabled;
        int[] nArray = this.indexesOfProtectedZone(string4);
        if (nArray != null) {
            int n = nArray[1];
            if (n > 0) {
                this.fileCode = this.fileCode.substring(0, n) + '\n' + string3 + '\n' + this.fileCode.substring(nArray[1]);
            }
        } else {
            System.err.println(string4 + " not found");
        }
    }

    public void removeProtectedZone(String string, String string2) {
        String string3 = start_protected + string + "::" + string2 + ") " + start_protected_enabled;
        int[] nArray = this.indexesOfProtectedZone(string3);
        if (nArray != null) {
            this.fileCode = this.fileCode.substring(0, nArray[0]) + this.fileCode.substring(nArray[1]);
        } else {
            System.err.println(string3 + " not found");
        }
    }

    public void removeProtectedZoneAtEnd(String string, String string2, String string3) {
        String string4 = start_protected + string + "::" + string2 + ") " + start_protected_enabled;
        int[] nArray = this.indexesOfProtectedZone(string4);
        if (nArray != null) {
            int n = this.fileCode.indexOf(string3, nArray[0]);
            if (n > 0) {
                this.fileCode = this.fileCode.substring(0, n) + this.fileCode.substring(nArray[1]);
            }
        } else {
            System.err.println(string4 + " not found");
        }
    }

    public void insertIncludeFiles(String string) {
        int n = this.fileCode.indexOf("#include");
        int n2 = this.fileCode.indexOf(end_protected, n);
        n2 = this.fileCode.lastIndexOf(10, n2);
        this.fileCode = this.fileCode.substring(0, n) + string + this.fileCode.substring(n2);
    }

    public void insertAdditionalMethodPrototypes(String string, String string2) {
        this.insertInProtectedZone(string, "Additional Method prototypes", string2);
    }

    public void insertAdditionalClasses(String string, String string2) {
        this.insertInProtectedZone(string, "Additional Classes Definitions", string2);
    }

    public void insertAdditionalClassDefs(String string, String string2) {
        this.insertInProtectedZone(string, "Additional Class Declarations", string2);
    }

    public void addObjFiles(String string) throws PogoException {
        if (this.fileCode.indexOf(string) > 0) {
            return;
        }
        int n = this.fileCode.indexOf("SHLIB_OBJS =");
        if (n < 0) {
            return;
        }
        n = this.fileCode.substring(0, n).trim().length();
        this.fileCode = this.fileCode.substring(0, n) + string + this.fileCode.substring(n);
        this.write();
    }

    private int[] indexesOfProtectedZone(String string) {
        int n = this.fileCode.indexOf(string);
        if (n < 0) {
            System.err.println(string + " not found !");
            return null;
        }
        int n2 = this.fileCode.indexOf(end_protected, n = this.fileCode.indexOf(10, n) + 1);
        if (n2 < 0) {
            System.err.println("No end of protected zone for " + string + " not found !");
            return null;
        }
        n2 = this.fileCode.lastIndexOf(10, n2);
        return new int[]{n, n2};
    }

    public String getProtectedCode(String string) {
        String string2 = start_protected + string + ") " + start_protected_enabled;
        int[] nArray = this.indexesOfProtectedZone(string2);
        if (nArray == null) {
            return "";
        }
        return this.fileCode.substring(nArray[0], nArray[1]);
    }

    public String getDeletedObjectsCode(String string) {
        int n = this.fileCode.lastIndexOf(string);
        if (n > 0) {
            int n2;
            if (string.startsWith("def ")) {
                n = this.fileCode.lastIndexOf("\n", n);
            } else {
                n2 = this.fileCode.lastIndexOf("//-----", n = this.fileCode.lastIndexOf("/**", n));
                if (n2 >= 0) {
                    n = n2;
                }
            }
            n2 = this.fileCode.indexOf(end_protected, n);
            n2 = this.fileCode.indexOf("}", n2);
            n2 = this.fileCode.indexOf("\n", n2) + 1;
            return this.commentCode(this.fileCode.substring(n, n2));
        }
        System.out.println(string + "\tNOT FOUND !!!");
        return null;
    }

    private String commentCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.contains(start_protected) || string2.contains(end_protected)) continue;
            stringBuilder.append("// ").append(string2).append("\n");
        }
        return stringBuilder.toString();
    }

    public void insertDeletedObjectsCode(String string) {
        int n = this.fileCode.lastIndexOf(end_protected);
        n = this.fileCode.lastIndexOf("\n", n);
        this.fileCode = this.fileCode.substring(0, n) + string + this.fileCode.substring(n);
    }

    public String toString() {
        return this.fileCode;
    }
}

