/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class PogoFileFilter
extends FileFilter {
    private List<String> filters = new ArrayList<String>();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    public static final String[] cpp_target = new String[]{"Inherited from class ", ": public Tango::Device_4Impl", ": public Tango::Device_3Impl", ": public Tango::Device_2Impl", ": public Tango::DeviceImpl"};
    public static final String[] java_target = new String[]{" extends DeviceImpl"};
    public static final String[] py_target = new String[]{"(PyTango.Device_4Impl):", "(PyTango.Device_3Impl):"};

    public PogoFileFilter() {
    }

    public PogoFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public PogoFileFilter(String[] stringArray, String string) {
        this();
        for (String string2 : stringArray) {
            this.addExtension(string2);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = PogoFileFilter.getExtension(file);
            if (string != null) {
                for (String string2 : this.filters) {
                    if (!string2.equals(string)) continue;
                    if (this.getDescription().toLowerCase().startsWith("pogo-6")) {
                        return PogoFileFilter.isDeviceImplClass(file.toString());
                    }
                    if (this.getDescription().toLowerCase().startsWith("additional")) {
                        boolean bl = this.isPogoGeneratedFile(file.toString());
                        return !bl;
                    }
                    if (this.getDescription().toLowerCase().startsWith("multi classes")) {
                        return this.isMultiClassXmi(file.toString());
                    }
                    return !this.isMultiClassXmi(file.toString());
                }
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        if (file != null) {
            String string = file.getName();
            return PogoFileFilter.getExtension(string);
        }
        return null;
    }

    public static String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        this.filters.add(string.toLowerCase());
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "" : this.description + "  (";
                for (int i = 0; i < this.filters.size(); ++i) {
                    this.fullDescription = this.fullDescription + "*." + this.filters.get(i);
                    if (i >= this.filters.size() - 1) continue;
                    this.fullDescription = this.fullDescription + ", ";
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    private boolean isPogoGeneratedFile(String string) {
        String string2;
        try {
            string2 = ParserTool.readFile(string);
        }
        catch (PogoException pogoException) {
            return false;
        }
        return string2.contains("PROTECTED REGION ID");
    }

    private boolean isMultiClassXmi(String string) {
        return string.endsWith(".multi.xmi");
    }

    public static boolean isDeviceImplClass(String string) {
        try {
            String string2 = ParserTool.readFile(string);
            if (string2.startsWith("/*----- PROTECTED REGION ID")) {
                return false;
            }
            for (String string3 : cpp_target) {
                if (string2.indexOf(string3) <= 0) continue;
                return true;
            }
            for (String string3 : java_target) {
                if (string2.indexOf(string3) <= 0) continue;
                return true;
            }
            for (String string3 : py_target) {
                if (string2.indexOf(string3) <= 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

