/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoException
extends Exception {
    private String description;
    private StackTraceElement[] stackTraceElements;
    private String origin;

    public PogoException(String string) {
        this.description = string;
        this.origin = this.getCurrentCodeLine();
    }

    private String getCurrentCodeLine() {
        this.stackTraceElements = Thread.currentThread().getStackTrace();
        return this.stackTraceElements[3].toString();
    }

    public void popup(Component component) {
        ErrorPane errorPane = component instanceof JFrame ? new ErrorPane((JFrame)component) : (component instanceof JDialog ? new ErrorPane((JDialog)component) : new ErrorPane((JFrame)null));
        ATKGraphicsUtils.centerDialog(errorPane);
        errorPane.setVisible(true);
    }

    public void print_exception() {
        System.err.println("PogoException:");
        System.err.println("    Description: " + this.description);
        System.err.println("    Origin:      " + this.origin);
    }

    @Override
    public void printStackTrace() {
        StringBuilder stringBuilder = new StringBuilder(this.description + "\n");
        int n = 0;
        for (StackTraceElement stackTraceElement : this.stackTraceElements) {
            if (n++ <= 0 || stackTraceElement.toString().contains("PogoException")) continue;
            stringBuilder.append(stackTraceElement).append("\n");
        }
        System.err.println(stringBuilder);
    }

    public static void popup(Component component, Exception exception) {
        PogoException.popup(component, exception.getMessage());
    }

    public static void popup(Component component, String string) {
        PogoException pogoException = new PogoException(string);
        pogoException.popup(component);
    }

    @Override
    public String getMessage() {
        return "PogoException: " + this.description;
    }

    @Override
    public String toString() {
        return "PogoException: " + this.description;
    }

    private class ErrorPane
    extends JDialog {
        private JTextArea descriptionText;
        private JScrollPane stackScrollPane;
        private JTextArea stackText;

        private ErrorPane(JFrame jFrame) {
            super((Frame)jFrame, true);
            this.initComponents();
            this.displayError();
        }

        private ErrorPane(JDialog jDialog) {
            super((Dialog)jDialog, true);
            this.initComponents();
            this.displayError();
        }

        private void displayError() {
            StringBuilder stringBuilder = new StringBuilder("\n");
            StringTokenizer stringTokenizer = new StringTokenizer(PogoException.this.description, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                stringBuilder.append(string).append(" \n");
            }
            this.descriptionText.setText(stringBuilder.toString());
            this.descriptionText.setRows(2 + stringTokenizer.countTokens());
            stringBuilder = new StringBuilder(PogoException.this.description + "\n");
            int n = 0;
            for (StackTraceElement stackTraceElement : PogoException.this.stackTraceElements) {
                if (n++ <= 0 || stackTraceElement.toString().contains("PogoException")) continue;
                stringBuilder.append(stackTraceElement).append("\n");
            }
            this.stackText.setText(stringBuilder.toString());
            int n2 = PogoException.this.stackTraceElements.length;
            if (n2 > 25) {
                n2 = 25;
            }
            this.stackText.setRows(n2);
            this.pack();
        }

        private void initComponents() {
            this.setTitle("PogoException");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ErrorPane.this.closeDialog();
                }
            });
            this.descriptionText = new JTextArea();
            this.descriptionText.setEditable(false);
            this.descriptionText.setFont(new Font("Dialog", 1, 14));
            this.descriptionText.setBackground(this.getContentPane().getBackground());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JLabel(Utils.getInstance().errorIcon), "West");
            jPanel.add((Component)this.descriptionText, "Center");
            this.getContentPane().add((Component)jPanel, "North");
            this.stackText = new JTextArea();
            this.stackText.setEditable(false);
            this.stackScrollPane = new JScrollPane();
            this.stackScrollPane.setViewportView(this.stackText);
            this.stackScrollPane.setVisible(false);
            this.getContentPane().add((Component)this.stackScrollPane, "Center");
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorPane.this.cancelBtnActionPerformed();
                }
            });
            jPanel2.add(jButton);
            JButton jButton2 = new JButton("Details...");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorPane.this.detailsBtnActionPerformed();
                }
            });
            jPanel2.add(jButton2);
            this.getContentPane().add((Component)jPanel2, "South");
        }

        private void detailsBtnActionPerformed() {
            this.stackScrollPane.setVisible(!this.stackScrollPane.isVisible());
            this.pack();
        }

        private void cancelBtnActionPerformed() {
            this.setVisible(false);
            this.dispose();
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

