/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoEditor {
    private static PogoEditor instance = null;
    private static String shellEditor = null;
    private static final String[] exeFiles = new String[]{"nedit-client", "nedit-nc"};

    public static PogoEditor getInstance() {
        if (instance == null) {
            instance = new PogoEditor();
        }
        return instance;
    }

    private PogoEditor() {
        String string = System.getProperty("os.name");
        System.out.println("Running under " + string);
        if (string.toLowerCase().startsWith("shellEditor")) {
            shellEditor = null;
        } else {
            shellEditor = System.getenv("EDITOR");
            if (shellEditor != null) {
                if (shellEditor.startsWith("nedit")) {
                    String string2;
                    String string3 = System.getenv("PATH");
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    String[] stringArray = exeFiles;
                    int n = stringArray.length;
                    for (int i = 0; i < n && (shellEditor = this.getEditorExeFile(string2 = stringArray[i], arrayList)) == null; ++i) {
                    }
                    if (shellEditor != null) {
                        System.out.println("using " + shellEditor + " editor");
                    } else {
                        System.out.println("no shellEditor available.");
                    }
                } else if (shellEditor.equals("gedit") || shellEditor.equals("geany")) {
                    System.out.println("using " + shellEditor + " editor");
                } else {
                    shellEditor = null;
                }
            }
            if (shellEditor == null) {
                System.out.println("will Launch default desktop editor....");
            }
        }
    }

    private String getEditorExeFile(String string, List<String> list) {
        for (String string2 : list) {
            String string3 = string2 + "/" + string;
            if (!new File(string3).exists()) continue;
            return string3;
        }
        return null;
    }

    private int getLineNumber(String string, String string2) {
        int n;
        String string3 = "";
        try {
            string3 = ParserTool.readFile(string);
        }
        catch (Exception exception) {
            PogoException.popup((Component)new JFrame(), exception);
        }
        int n2 = 0;
        int n3 = 0;
        while ((n = string3.indexOf(10, n2)) > 0) {
            String string4 = string3.substring(n2, n);
            if (string4.contains(string2)) {
                return n3 + 1;
            }
            n2 = n + 1;
            ++n3;
        }
        System.out.println(string2 + " not found !");
        return -1;
    }

    private int getLineNumber(String string, String string2, int n, Property property, boolean bl) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = "void " + string2;
                if (!bl) {
                    string3 = string3 + "Class";
                }
                string3 = string3 + "::get_";
                string3 = bl ? string3 + "device" : string3 + "class";
                string3 = string3 + "_property(";
                break;
            }
            case 0: {
                string3 = "@" + (bl ? "Device" : "Class") + "Property(name=\"" + property.getName() + "\"";
                break;
            }
            case 2: {
                string3 = "'" + property.getName() + "':";
            }
        }
        if (string3 == null) {
            return -1;
        }
        return this.getLineNumber(string, string3);
    }

    private int getLineNumber(String string, String string2, int n, Command command) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "::" + command.getExecMethod() + "(";
                break;
            }
            case 0: {
                string3 = "* Execute command \"" + command.getName() + "\"";
                break;
            }
            case 2: {
                string3 = "def " + command.getName() + "(self):";
            }
        }
        if (string3 == null) {
            return -1;
        }
        return this.getLineNumber(string, string3);
    }

    private int getLineNumber(String string, String string2, int n, Attribute attribute) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "::read_" + attribute.getName() + "(Tango::Attribute &attr)";
                break;
            }
            case 0: {
                if (Utils.isTrue(attribute.getIsDynamic())) {
                    string3 = "public AttributeValue getValue() throws DevFailed {";
                    break;
                }
                string3 = "@Attribute(name=\"" + attribute.getName() + "\"";
                break;
            }
            case 2: {
                string3 = "def read_" + attribute.getName() + "(self, attr):";
            }
        }
        if (string3 == null) {
            return -1;
        }
        return this.getLineNumber(string, string3);
    }

    private int getLineNumber(String string, String string2, int n, Pipe pipe) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "::read_" + pipe.getName() + "(Tango::Pipe &pipe)";
                break;
            }
            case 0: {
                string3 = "@Pipe(name=\"" + pipe.getName() + "\"";
                break;
            }
            case 2: {
                string3 = "def read_" + pipe.getName() + "(self, pipe):";
            }
        }
        if (string3 == null) {
            return -1;
        }
        return this.getLineNumber(string, string3);
    }

    private int getLineNumber(String string, String string2, int n) {
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = "namespace " + string2 + "_ns";
                break;
            }
            case 0: {
                string3 = "public class " + string2 + " {";
                break;
            }
            case 2: {
                string3 = "class " + string2 + " {";
            }
        }
        if (string3 == null) {
            return -1;
        }
        return this.getLineNumber(string, string3);
    }

    public void editFile(String[] stringArray, Property property, boolean bl) throws PogoException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Utils.getLanguage(stringArray[2]);
        String string3 = null;
        switch (n) {
            case 1: {
                if (bl) {
                    string3 = string2 + "/" + string + ".cpp";
                    break;
                }
                string3 = string2 + "/" + string + "Class.cpp";
                break;
            }
            case 0: {
                string3 = string2 + "/org/tango/" + string.toLowerCase() + "/" + string + ".java";
                break;
            }
            case 2: {
                string3 = string2 + "/" + string + ".py";
            }
        }
        if (string3 != null) {
            int n2 = this.getLineNumber(string3, string, n, property, bl);
            this.startEditor(string3, n2);
        }
    }

    public void editFile(String[] stringArray, Attribute attribute) throws PogoException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Utils.getLanguage(stringArray[2]);
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "/" + string + ".cpp";
                break;
            }
            case 0: {
                string3 = string2 + "/org/tango/" + string.toLowerCase() + "/";
                string3 = Utils.isTrue(attribute.getIsDynamic()) ? string3 + attribute.getName() : string3 + string;
                string3 = string3 + ".java";
                break;
            }
            case 2: {
                string3 = string2 + "/" + string + ".py";
            }
        }
        if (string3 != null) {
            int n2 = this.getLineNumber(string3, string, n, attribute);
            this.startEditor(string3, n2);
        }
    }

    public void editFile(String[] stringArray, Pipe pipe) throws PogoException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Utils.getLanguage(stringArray[2]);
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "/" + string + ".cpp";
                break;
            }
            case 0: {
                string3 = string2 + "/org/tango/" + string.toLowerCase() + "/" + string;
                string3 = string3 + ".java";
                break;
            }
            case 2: {
                string3 = string2 + "/" + string + ".py";
            }
        }
        if (string3 != null) {
            int n2 = this.getLineNumber(string3, string, n, pipe);
            this.startEditor(string3, n2);
        }
    }

    public void editFile(String[] stringArray, Command command) throws PogoException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Utils.getLanguage(stringArray[2]);
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "/" + string + ".cpp";
                break;
            }
            case 0: {
                string3 = string2 + "/org/tango/" + string.toLowerCase() + "/" + string + ".java";
                break;
            }
            case 2: {
                string3 = string2 + "/" + string + ".py";
            }
        }
        if (string3 != null) {
            int n2 = this.getLineNumber(string3, string, n, command);
            this.startEditor(string3, n2);
        }
    }

    public void editFile(String[] stringArray, State state) throws PogoException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Utils.getLanguage(stringArray[2]);
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = string2 + "/" + string + "StateMachine.cpp";
                break;
            }
            case 0: {
                string3 = string2 + "/org/tango/" + string.toLowerCase() + "/" + string + ".java";
                break;
            }
            case 2: {
                string3 = string2 + "/" + string + ".py";
            }
        }
        if (string3 != null) {
            int n2 = this.getLineNumber(string3, string, n);
            this.startEditor(string3, n2);
        }
    }

    private void startEditor(String string, int n) throws PogoException {
        if (shellEditor == null) {
            this.launchDesktopEditor(string);
        } else if (n >= 0) {
            String string2 = shellEditor.startsWith("nedit") ? shellEditor + " -noask -line " + n + " " + string : shellEditor + " +" + n + " " + string;
            try {
                Utils.executeShellCmdAndReturn(string2);
            }
            catch (IOException iOException) {
                throw new PogoException(iOException.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void launchDesktopEditor(String string) throws PogoException {
        if (!Desktop.isDesktopSupported()) throw new PogoException("Desktop  not supported");
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) throw new PogoException("Desktop.Action.EDIT not supported");
        try {
            desktop.open(new File(string));
            return;
        }
        catch (Exception exception) {
            PogoException.popup((Component)new JFrame(), exception);
        }
    }
}

