/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoConfiguration
extends JDialog {
    private Component parent;
    private List<String> families;
    private int retVal = 2;
    private JTextArea copyrightText;
    private JList<String> familyList;
    private JTextField siteLabel;
    private JLabel titleLabel;

    public PogoConfiguration(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        this.titleLabel.setToolTipText(Utils.buildToolTip("Class Families", "If you use your own repository with specific class families\nAdd your  institute name on right fields\n&nbsp; &nbsp; and the specific family names below.\nIt will ne used for Class Identification Window."));
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel2 = new JPanel();
        JButton jButton3 = new JButton();
        JButton jButton4 = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.familyList = new JList();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.copyrightText = new JTextArea();
        JPanel jPanel4 = new JPanel();
        this.titleLabel = new JLabel();
        this.siteLabel = new JTextField();
        JLabel jLabel2 = new JLabel();
        JButton jButton5 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PogoConfiguration.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoConfiguration.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoConfiguration.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new GridBagLayout());
        jButton3.setText("Add");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoConfiguration.this.addBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(60, 0, 5, 0);
        jPanel2.add((Component)jButton3, gridBagConstraints);
        jButton4.setText("Remove");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoConfiguration.this.removeBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jButton4, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "After");
        jScrollPane.setPreferredSize(new Dimension(300, 360));
        jScrollPane.setViewportView(this.familyList);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jPanel3.setLayout(new BorderLayout());
        jLabel.setText("Copyright:");
        jPanel3.add((Component)jLabel, "North");
        jScrollPane2.setPreferredSize(new Dimension(400, 100));
        this.copyrightText.setColumns(40);
        this.copyrightText.setFont(new Font("Monospaced", 1, 12));
        this.copyrightText.setRows(5);
        jScrollPane2.setViewportView(this.copyrightText);
        jPanel3.add((Component)jScrollPane2, "Center");
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setText("Specific Class Family Names for  ");
        jPanel4.add(this.titleLabel);
        this.siteLabel.setColumns(10);
        this.siteLabel.setFont(new Font("Dialog", 1, 14));
        jPanel4.add(this.siteLabel);
        jLabel2.setText("        ");
        jPanel4.add(jLabel2);
        jButton5.setText("?");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoConfiguration.this.helpBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(jButton5);
        jPanel3.add((Component)jPanel4, "South");
        this.getContentPane().add((Component)jPanel3, "North");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        try {
            PogoProperty.siteName = this.siteLabel.getText();
            PogoProperty.copyright = this.copyrightText.getText();
            if (PogoProperty.getInstance().updateSitePropertyFile(this)) {
                this.retVal = 0;
                this.doClose();
            }
        }
        catch (Exception exception) {
            PogoException.popup((Component)this, exception);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        String string = "";
        boolean bl = false;
        while (!bl) {
            if ((string = (String)JOptionPane.showInputDialog(this, "Family Name ", "Input Dialog", 1, null, null, string)) == null || string.length() == 0) {
                return;
            }
            boolean bl2 = false;
            for (String string2 : this.families) {
                if (!string2.equalsIgnoreCase(string)) continue;
                bl2 = true;
            }
            if (bl2) {
                Utils.popupError(this, string + " family  already exists");
                continue;
            }
            bl = true;
        }
        this.families.add(string);
        MyCompare myCompare = new MyCompare();
        Collections.sort(this.families, myCompare);
        this.setFamilyList();
    }

    private void setFamilyList() {
        this.familyList.setListData((String[])this.families.toArray(new String[this.families.size()]));
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        List<String> list = this.familyList.getSelectedValuesList();
        if (list.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Nothing selected to be removed !", "Error Window", 0);
        } else {
            Iterator<String> iterator = list.iterator();
            block0: while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                for (String string3 : this.families) {
                    if (!string3.equals(string2)) continue;
                    this.families.remove(string3);
                    continue block0;
                }
            }
            this.setFamilyList();
        }
    }

    private void helpBtnActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "If you use your own repository with specific class families,\nenter your site name and use the list to add or remove your \nspecific families.", "Help Window", 1);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void displayProperties() throws PogoException {
        this.siteLabel.setText(PogoProperty.siteName);
        this.copyrightText.setText(PogoProperty.copyright);
        this.families = PogoProperty.siteClassFamilies;
        this.setFamilyList();
        this.pack();
    }

    public int showDialog() {
        try {
            this.displayProperties();
            this.setVisible(true);
        }
        catch (Exception exception) {
            PogoException.popup((Component)new JFrame(), exception);
        }
        return this.retVal;
    }

    public static void main(String[] stringArray) {
        try {
            PogoProperty.init();
            new PogoConfiguration(null).showDialog();
        }
        catch (Exception exception) {
            PogoException.popup((Component)new JFrame(), exception);
            System.exit(0);
        }
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                String string = object.toString().toLowerCase();
                String string2 = object2.toString().toLowerCase();
                if (string.equals("miscellaneous")) {
                    return 0;
                }
                if (string2.equals("miscellaneous")) {
                    return 1;
                }
                return string.compareTo(string2);
            }
            return object.toString().compareTo(object2.toString());
        }
    }
}

