/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ParserTool {
    public static String readFile(String string) throws PogoException {
        String string2 = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            n = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n > 0) {
                string2 = ParserTool.takeOffWindowsChar(byArray);
            }
        }
        catch (Exception exception) {
            throw new PogoException(exception.toString());
        }
        return string2;
    }

    public static List<String> readFileLines(String string, boolean bl) throws PogoException {
        String string2 = ParserTool.readFile(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith("#") && !bl) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static String takeOffWindowsChar(byte[] byArray) {
        int n = 0;
        for (byte by : byArray) {
            if (by == 13) continue;
            ++n;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray2[n2++] = byArray[i];
        }
        return new String(byArray2);
    }

    private static String checkOsFormat(String string) {
        if (!Utils.osIsUnix()) {
            return ParserTool.setWindowsFileFormat(string);
        }
        return string;
    }

    public static String setWindowsFileFormat(String string) {
        byte[] byArray = new byte[]{13, 10};
        String string2 = new String(byArray);
        string = string.replaceAll("\n", string2);
        return string;
    }

    public static void writeFile(String string, String string2) throws PogoException {
        try {
            String string3 = System.getenv("LINUX");
            if (string3 == null || !string3.equals("true")) {
                string2 = ParserTool.checkOsFormat(string2);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new PogoException(exception.toString());
        }
    }

    public static void modifyProtectedAreaID(String string, String string2, String string3, String string4) throws PogoException {
        String string5;
        string3 = "PROTECTED REGION ID(" + string3 + ") ENABLED START";
        string4 = "PROTECTED REGION ID(" + string4 + ") ENABLED START";
        try {
            string5 = ParserTool.readFile(string + '/' + string2);
        }
        catch (PogoException pogoException) {
            return;
        }
        int n = string5.indexOf(string3);
        if (n < 0) {
            return;
        }
        int n2 = n + string3.length();
        String string6 = string5.substring(0, n) + string4 + string5.substring(n2);
        ParserTool.writeFile(string + '/' + string2, string6);
    }

    public static void removeXmiKey(String string, String string2) throws PogoException {
        CharSequence charSequence;
        boolean bl = false;
        string = " " + string + "=\"";
        String string3 = ParserTool.readFile(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            int n = ((String)charSequence).indexOf(string);
            if (n > 0) {
                int n2 = ((String)charSequence).indexOf("\"", n + string.length());
                if (n2 < 0) {
                    System.err.println("XMI syntax error !!!");
                    return;
                }
                charSequence = ((String)charSequence).substring(0, n) + ((String)charSequence).substring(n2 + 1);
                bl = true;
            }
            arrayList.add(charSequence);
        }
        if (bl) {
            charSequence = new StringBuilder();
            for (String string4 : arrayList) {
                ((StringBuilder)charSequence).append(string4).append("\n");
            }
            string3 = ((StringBuilder)charSequence).toString();
            string3 = string3.substring(0, string3.length() - 1);
            ParserTool.writeFile(string2, string3);
        }
    }

    public static void renameXmiKey(String string, String string2, String string3) throws PogoException {
        CharSequence charSequence;
        boolean bl = false;
        boolean bl2 = string.startsWith("<");
        if (!bl2) {
            string = " " + string + "=";
        }
        String string4 = ParserTool.readFile(string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            int n = ((String)charSequence).indexOf(string);
            if (n >= 0) {
                System.out.println("--------> replace " + string + " by " + string2);
                int n2 = n + string.length();
                if (!bl2) {
                    ++n;
                    --n2;
                }
                charSequence = ((String)charSequence).substring(0, n) + string2 + ((String)charSequence).substring(n2);
                bl = true;
            }
            arrayList.add(charSequence);
        }
        if (bl) {
            charSequence = new StringBuilder();
            for (String string5 : arrayList) {
                ((StringBuilder)charSequence).append(string5).append("\n");
            }
            string4 = ((StringBuilder)charSequence).toString();
            string4 = string4.substring(0, string4.length() - 1);
            ParserTool.writeFile(string3, string4);
        }
    }

    public static void convertProtectedAreaKey(String string, String string2, String string3) throws PogoException {
        CharSequence charSequence;
        int n;
        boolean bl = false;
        String string4 = ParserTool.readFile(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string4.indexOf(10, n2)) > 0) {
            int n3;
            charSequence = string4.substring(n2, n);
            if (((String)charSequence).contains(" PROTECTED REGION ") && (n3 = ((String)charSequence).indexOf(string)) > 0) {
                int n4 = n3 + string.length();
                charSequence = ((String)charSequence).substring(0, n3) + string2 + ((String)charSequence).substring(n4);
                bl = true;
            }
            arrayList.add((String)charSequence);
            n2 = n + 1;
        }
        arrayList.add(string4.substring(n2));
        if (bl) {
            charSequence = new StringBuilder();
            for (String string5 : arrayList) {
                ((StringBuilder)charSequence).append(string5).append('\n');
            }
            ParserTool.writeFile(string3, ((StringBuilder)charSequence).toString().trim());
            System.out.println("Replaced \"" + string + "\"  by  \"" + string2 + "\" \t in " + string3);
        }
    }

    public static void convertProtectedAreaKeyForStateMachine(List<String> list, String string, boolean bl) throws PogoException {
        CharSequence charSequence;
        int n;
        boolean bl2 = false;
        String string2 = ParserTool.readFile(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string2.indexOf(10, n2)) > 0) {
            charSequence = string2.substring(n2, n);
            if (((String)charSequence).contains(" PROTECTED REGION ")) {
                for (String string3 : list) {
                    int n3;
                    String string4 = "read_" + string3 + "StateAllowed_READ";
                    String string5 = string3 + "StateAllowed";
                    if (!bl) {
                        String string6 = string5;
                        string5 = string4;
                        string4 = string6;
                    }
                    if ((n3 = ((String)charSequence).indexOf(string4)) <= 0) continue;
                    int n4 = n3 + string4.length();
                    charSequence = ((String)charSequence).substring(0, n3) + string5 + ((String)charSequence).substring(n4);
                    bl2 = true;
                }
            }
            arrayList.add((String)charSequence);
            n2 = n + 1;
        }
        arrayList.add(string2.substring(n2));
        if (bl2) {
            charSequence = new StringBuilder();
            for (String string7 : arrayList) {
                ((StringBuilder)charSequence).append(string7).append('\n');
            }
            ParserTool.writeFile(string, ((StringBuilder)charSequence).toString().trim());
            System.out.println("Replaced protected region keys in " + string);
        }
    }

    void convertForXTendCompatibility(PogoDeviceClass pogoDeviceClass, boolean bl) {
        try {
            if (bl) {
                String string = pogoDeviceClass.getDescription().getSourcePath() + "/" + pogoDeviceClass.getName();
                String string2 = string + "Class.cpp";
                Object object = pogoDeviceClass.getName() + "::Class::";
                Object object2 = pogoDeviceClass.getName() + "Class::";
                ParserTool.convertProtectedAreaKey((String)object, (String)object2, string2);
                string2 = string + "Class.h";
                object = pogoDeviceClass.getName() + "::";
                object2 = pogoDeviceClass.getName() + "Class::";
                ParserTool.convertProtectedAreaKey((String)object, (String)object2, string2);
                string2 = string + "StateMachine.cpp";
                object = new ArrayList();
                for (Attribute attribute : pogoDeviceClass.getAttributes()) {
                    object.add(attribute.getName());
                }
                ParserTool.convertProtectedAreaKeyForStateMachine((List<String>)object, string2, true);
            } else {
                new Back2Height(pogoDeviceClass);
            }
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException.getMessage());
        }
    }

    static void manageWindowsProjects(PogoDeviceClass pogoDeviceClass) {
        byte[] byArray = new byte[]{-17, -69, -65};
        try {
            String[] stringArray;
            String string = pogoDeviceClass.getDescription().getSourcePath() + "/vc12_proj";
            File file = new File(string);
            for (String string2 : stringArray = file.list()) {
                String string3;
                String string4;
                if (!string2.contains(".vcxproj") || !(string4 = ParserTool.readFile(string3 = string + "/" + string2)).startsWith("<?xml ")) continue;
                string4 = new String(byArray) + string4;
                ParserTool.writeFile(string3, string4);
            }
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
    }

    private class Back2Height {
        private PogoDeviceClass cls = null;
        private String className;
        private String path = ".";
        private String xmiFileName;

        private Back2Height(PogoDeviceClass pogoDeviceClass) throws PogoException {
            this.className = pogoDeviceClass.getName();
            this.path = pogoDeviceClass.getDescription().getSourcePath();
            this.xmiFileName = this.path + "/" + this.className + ".xmi";
            this.convert();
        }

        private Back2Height(String string) throws PogoException {
            this.xmiFileName = string;
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            int n2 = string.lastIndexOf(46);
            if (n > 0) {
                this.path = string.substring(0, n);
                this.className = string.substring(n + 1, n2);
            } else {
                this.className = string.substring(0, n2);
            }
            this.convert();
        }

        private void convert() throws PogoException {
            System.out.println("Path = " + this.path);
            System.out.println("ClassName = " + this.className);
            System.out.println("cleaning " + this.xmiFileName);
            ParserTool.removeXmiKey("pogoRevision", this.xmiFileName);
            if (this.cls == null) {
                this.cls = OAWutils.getInstance().loadDeviceClassModel(this.xmiFileName, false);
            }
            String string = this.path + "/" + this.className + "Class.cpp";
            this.manageDevClassCpp(string);
            string = this.path + "/" + this.className + "Class.h";
            this.manageDevClassH(string);
            string = this.path + '/' + this.className + "StateMachine.cpp";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Attribute attribute : this.cls.getAttributes()) {
                arrayList.add(attribute.getName());
            }
            ParserTool.convertProtectedAreaKeyForStateMachine(arrayList, string, true);
        }

        private void manageDevClassCpp(String string) throws PogoException {
            System.out.println("cleaning protected regions in " + string);
            String string2 = this.className + "Class::";
            String string3 = this.className + "::Class::";
            ParserTool.convertProtectedAreaKey(string2, string3, string);
        }

        private void manageDevClassH(String string) throws PogoException {
            CharSequence charSequence;
            int n;
            System.out.println("cleaning protected regions in " + string);
            boolean bl = false;
            String string2 = ParserTool.readFile(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            int n3 = 0;
            String string3 = this.className + "Class";
            while ((n = string2.indexOf(10, n2)) > 0) {
                int n4;
                charSequence = string2.substring(n2, n);
                if (((String)charSequence).contains(" PROTECTED REGION ") && (n4 = ((String)charSequence).indexOf(string3)) > 0 && ++n3 >= 3) {
                    System.out.println("Replace " + string3 + " by " + this.className);
                    int n5 = n4 + string3.length();
                    charSequence = ((String)charSequence).substring(0, n4) + this.className + ((String)charSequence).substring(n5);
                    bl = true;
                }
                arrayList.add((String)charSequence);
                n2 = n + 1;
            }
            arrayList.add(string2.substring(n2));
            if (bl) {
                charSequence = new StringBuilder();
                for (String string4 : arrayList) {
                    ((StringBuilder)charSequence).append(string4).append('\n');
                }
                ParserTool.writeFile(string, ((StringBuilder)charSequence).toString().trim());
                System.out.println("Replaced \"" + string3 + "\"  by  \"" + this.className + "\" \t in " + string);
            }
        }
    }
}

