/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;

public class OldModelParser {
    private String fileCode;
    private PogoClass pogo_class;
    private List<String> methods = new ArrayList<String>();
    private List<String> signatures = new ArrayList<String>();
    private static final String[] cpp_constructors = new String[]{"(Tango::DeviceClass *cl,string &s)", "(Tango::DeviceClass *cl,const char *s)", "(Tango::DeviceClass *cl,const char *s,const char *d)"};
    private static final String[] cpp_expected_sig = new String[]{"void ::delete_device()", "void ::init_device()", "void ::get_device_property()", "void ::always_executed_hook()", "void ::read_attr_hardware(vector<long> &attr_list)"};

    public OldModelParser(String string) throws SecurityException, IOException, PogoException {
        try {
            this.pogo_class = new PogoClass(string);
        }
        catch (pogo.gene.PogoException pogoException) {
            throw new PogoException(pogoException.toString());
        }
        this.initialize(string);
    }

    public OldModelParser(String string, PogoClass pogoClass) throws SecurityException, IOException, PogoException {
        this.pogo_class = pogoClass;
        this.initialize(string);
    }

    private void initialize(String string) throws SecurityException, IOException, PogoException {
        this.fileCode = ParserTool.readFile(string);
        int n = this.fileCode.indexOf("namespace ");
        if (string.endsWith("main.cpp") || string.endsWith(".html")) {
            return;
        }
        if (n < 0) {
            throw new PogoException("namespace not found in " + string);
        }
        if ((n = this.fileCode.indexOf("{", n) + 2) < 0) {
            throw new PogoException("Namespace not found");
        }
        this.parseMethodCode(n);
    }

    public String getCode() {
        return this.fileCode;
    }

    private void parseMethodCode(int n) {
        int n2;
        while ((n2 = this.fileCode.indexOf("{", n)) > 0) {
            ++n2;
            int n3 = 1;
            while (n3 > 0) {
                if (this.fileCode.charAt(n2) == '{') {
                    ++n3;
                } else if (this.fileCode.charAt(n2) == '}') {
                    --n3;
                }
                ++n2;
            }
            String string = this.fileCode.substring(n, n2).trim();
            this.methods.add(string);
            String string2 = this.getMethodSignature(string);
            this.signatures.add(string2);
            n = n2;
        }
    }

    private String getMethodSignature(String string) {
        int n;
        int n2 = string.indexOf("{");
        String string2 = string.substring(0, n2);
        int n3 = 0;
        int n4 = -1;
        while ((n = string2.indexOf("//", n3)) >= 0 && n3 > n4) {
            n4 = n3;
            n3 = string2.indexOf("\n", n) + 1;
        }
        string2 = string2.substring(n3);
        n3 = 0;
        while ((n = string2.indexOf("/*", n3)) >= 0) {
            n3 = string2.indexOf("*/", n) + 2;
        }
        string2 = string2.substring(n3);
        return string2.trim();
    }

    private String getCode(int n) {
        String string = this.methods.get(n);
        int n2 = string.indexOf("{") + 1;
        int n3 = string.lastIndexOf("}");
        return string.substring(n2, n3).trim();
    }

    public List<String> getMethodSignatures() {
        return this.signatures;
    }

    public String getMethodCode(String string) {
        for (int i = 0; i < this.signatures.size(); ++i) {
            String string2 = this.signatures.get(i);
            if (!string2.equals(string.trim())) continue;
            return this.getCode(i);
        }
        return null;
    }

    public String getMethod(String string) {
        for (int i = 0; i < this.signatures.size(); ++i) {
            String string2 = this.signatures.get(i);
            if (!string2.equals(string.trim())) continue;
            System.out.println("inserting code for " + string);
            return this.methods.get(i);
        }
        return null;
    }

    private String getExpectedSig(int n) {
        int n2 = cpp_expected_sig[n].indexOf("::");
        return cpp_expected_sig[n].substring(0, n2) + this.pogo_class.class_name + cpp_expected_sig[n].substring(n2);
    }

    private boolean isCommandMethod(String string) {
        for (int i = 0; i < this.pogo_class.commands.size(); ++i) {
            Cmd cmd = this.pogo_class.commands.cmdAt(i);
            String string2 = cmd.buildCppExecCmdMethodSignature(this.pogo_class.class_name);
            if (string2.equals(string)) {
                return true;
            }
            int n = string2.indexOf("argin");
            if (n <= 0 || !string.startsWith(string2 = string2.substring(0, n))) continue;
            return true;
        }
        return false;
    }

    private boolean isAttributeMethod(String string) {
        boolean bl = false;
        for (int i = 0; i < this.pogo_class.attributes.size(); ++i) {
            Attrib attrib = this.pogo_class.attributes.attributeAt(i);
            String string2 = "void " + this.pogo_class.class_name + "::" + "read_" + attrib.name + "(Tango::Attribute &attr)";
            if (string2.equals(string)) {
                bl = true;
                continue;
            }
            string2 = "void " + this.pogo_class.class_name + "::" + "write_" + attrib.name + "(Tango::WAttribute &attr)";
            if (!string2.equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isExpected(String string) {
        boolean bl = false;
        for (int i = 0; i < cpp_expected_sig.length; ++i) {
            String string2 = this.getExpectedSig(i);
            if (!string2.equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            if (this.isCommandMethod(string)) {
                bl = true;
            } else if (this.isAttributeMethod(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isConstructor(String string) {
        String string2 = this.pogo_class.class_name + "::" + this.pogo_class.class_name;
        for (String string3 : cpp_constructors) {
            if (!string.startsWith(string2 + string3)) continue;
            return true;
        }
        return false;
    }

    public String getUnexpectedMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.signatures) {
            if (this.isConstructor(string) || this.isExpected(string)) continue;
            stringBuffer.append(this.getMethod(string)).append("\n");
        }
        return stringBuffer.toString();
    }

    public String getIncludeFiles() {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.fileCode.indexOf("#include", n2)) > 0) {
            n2 = this.fileCode.indexOf(10, n) + 1;
            int n3 = this.fileCode.lastIndexOf(10, n - 1);
            if (this.fileCode.substring(n3 = this.fileCode.lastIndexOf(10, n3 - 1) + 1).startsWith("#ifdef")) {
                n = n3;
            }
            if (this.fileCode.substring(n2).startsWith("#endif")) {
                n2 = this.fileCode.indexOf(10, n2) + 1;
            }
            stringBuffer.append(this.fileCode.substring(n, n2));
        }
        return stringBuffer.toString();
    }

    public String getDefinitions() {
        int n = this.fileCode.indexOf("Add your own constant");
        if (n < 0) {
            return null;
        }
        n = this.fileCode.indexOf(10, n) + 1;
        n = this.fileCode.indexOf(10, n) + 1;
        int n2 = this.fileCode.indexOf("namespace", n);
        return this.fileCode.substring(n, n2);
    }

    public String getDataMembers() {
        int n = this.fileCode.indexOf("Add your own data members here");
        if (n < 0) {
            return null;
        }
        n = this.fileCode.indexOf(10, n) + 1;
        n = this.fileCode.indexOf(10, n) + 1;
        int n2 = this.fileCode.indexOf("Here is the Start of the automatic code generation part", n);
        n2 = this.fileCode.lastIndexOf(10, n2);
        return this.fileCode.substring(n, n2);
    }

    public String getAdditionalMethodPrototypes() {
        int n = this.fileCode.indexOf("Here is the end of the automatic code generation part");
        if (n < 0) {
            return null;
        }
        n = this.fileCode.indexOf(10, n) + 1;
        n = this.fileCode.indexOf(10, n) + 1;
        int n2 = this.fileCode.indexOf("};", n);
        String string = this.fileCode.substring(n, n2);
        if ((n = string.indexOf("Add your own data members here")) > 0) {
            n = string.lastIndexOf(10, n) + 1;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            n = string.indexOf(10, n) + 1;
            n = string.indexOf(10, n) + 1;
            stringBuffer.append(string.substring(n));
            string = stringBuffer.toString();
        }
        return string.trim();
    }

    public String getAdditionalClassDeclarations() {
        int n = this.fileCode.indexOf("namespace " + this.pogo_class.class_name + "_ns");
        if (n < 0) {
            return null;
        }
        n = this.fileCode.indexOf("{", n) + 2;
        int n2 = this.fileCode.indexOf("class " + this.pogo_class.class_name + ":");
        String string = this.fileCode.substring(n, n2);
        if ((n = string.indexOf("Class Description")) > 0) {
            n = string.lastIndexOf("/*", n);
            n2 = string.indexOf("*/", n);
            n2 = string.indexOf("\n", n2) + 1;
            string = string.substring(0, n) + string.substring(n2);
        }
        if ((n = string.indexOf("States Description")) > 0) {
            n = string.lastIndexOf("/*", n);
            n2 = string.indexOf("*/", n);
            n2 = string.indexOf("\n", n2) + 1;
            string = string.substring(0, n) + string.substring(n2);
        }
        return string.trim();
    }

    public String getAdditionalClasses() {
        String string;
        int n;
        int n2 = this.fileCode.indexOf("Here is the end of the automatic code generation part");
        if (n2 < 0) {
            return null;
        }
        boolean bl = false;
        while (!bl && (n = this.fileCode.indexOf("\n", n2)) > 0) {
            string = this.fileCode.substring(n2, n);
            if (string.trim().equals("};")) {
                n2 += string.length() + 1;
                bl = true;
                continue;
            }
            n2 = n + 1;
        }
        if (!bl) {
            return null;
        }
        n = this.fileCode.indexOf("namespace", n2);
        n = this.fileCode.lastIndexOf("\n", n) + 1;
        string = this.fileCode.substring(n2, n);
        return string.trim();
    }

    public String manageWriteValue(String string, String string2) {
        String string3 = System.getenv("MANAGE_WRITE_METHOD");
        if (string3 == null || !string3.equals("true")) {
            return "\t// the variable w_val will not be used !\n" + string;
        }
        if (string != null) {
            int n;
            String string4 = "attr_" + string2 + "_write";
            String string5 = "w_val";
            int n2 = string.indexOf("attr.get_write_value(" + string4);
            if (n2 >= 0) {
                n = string.indexOf(10, n2);
                if ((n2 = string.lastIndexOf(10, n2)) < 0) {
                    n2 = 0;
                }
                string = string.substring(0, n2) + string.substring(n + 1);
            }
            while ((n2 = string.indexOf(string4)) > 0) {
                n = n2 + string4.length();
                string = string.substring(0, n2) + string5 + string.substring(n);
            }
        }
        return string;
    }

    public String getCppMethodCode(String string) {
        String string2 = null;
        for (int i = 0; i < this.signatures.size(); ++i) {
            int n;
            int n2 = string.indexOf("argin");
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            if (!this.signatures.get(i).startsWith(string)) continue;
            string2 = this.methods.get(i);
            n2 = string2.indexOf(string);
            if ((string2 = string2.substring(n2 = string2.indexOf("{", n2) + 1, n = string2.lastIndexOf("}")).trim()).startsWith("DEBUG_STREAM") || string2.startsWith("INFO_STREAM")) {
                n2 = string2.indexOf(10);
                if (n2 < 0) {
                    return null;
                }
                string2 = string2.substring(n2).trim();
            }
            string2 = "\t" + string2;
        }
        return string2;
    }

    public String getCppStaticInit(String string) {
        String string2 = "namespace " + string + "_ns";
        int n = this.fileCode.indexOf(string2);
        if (n < 0) {
            return null;
        }
        n = this.fileCode.indexOf(123, n) + 1;
        int n2 = this.fileCode.indexOf(string + "::" + string + "(", n);
        if (n2 < 0) {
            return null;
        }
        n2 = this.fileCode.lastIndexOf("//", n2);
        n2 = this.fileCode.lastIndexOf("//", n2 - 1);
        n2 = this.fileCode.lastIndexOf("//", n2 - 1);
        return this.fileCode.substring(n, n2).trim();
    }

    public String getCppMethodArginDef(String string) {
        String string2 = null;
        for (int i = 0; i < this.signatures.size(); ++i) {
            int n = string.indexOf("argin");
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (!this.signatures.get(i).startsWith(string)) continue;
            string2 = this.methods.get(i);
            n = string2.indexOf(string);
            n = string2.indexOf(40, n);
            int n2 = string2.indexOf(41, n);
            string2 = string2.substring(n + 1, n2).trim();
        }
        return string2;
    }

    public String getHtmlDescripion() {
        int n = this.fileCode.indexOf("Device Description");
        int n2 = n < 0 ? this.fileCode.toLowerCase().indexOf("</center>\n") : this.fileCode.toLowerCase().indexOf("</center>\n", n);
        if (n2 < 0) {
            return "";
        }
        n = n2 + "</center>\n".length();
        n2 = this.fileCode.toLowerCase().indexOf("</body>\n");
        String string = n2 < 0 ? this.fileCode.substring(n) : this.fileCode.substring(n, n2);
        n = string.indexOf(this.pogo_class.class_desc);
        if (n > 0) {
            string = string.substring(n, this.pogo_class.class_desc.length());
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.signatures) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public static void displaySyntax() {
        System.out.println("OldModelParser <filename>");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            OldModelParser.displaySyntax();
        }
        try {
            OldModelParser oldModelParser = new OldModelParser(stringArray[0]);
            String string = oldModelParser.getUnexpectedMethods();
            System.out.println(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }
}

