/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import com.google.inject.Injector;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoDslFactory;
import fr.esrf.tango.pogo.pogoDsl.PogoDslPackage;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tango.pogo.pogoDsl.PogoSystem;
import fr.esrf.tango.pogo.pogoDsl.Preferences;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tango.pogo.pogoDsl.Type;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe2.language.Mwe2StandaloneSetup;
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Runner;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class OAWutils {
    private static OAWutils instance = null;
    private static String backend = "/fr/esrf/tango/pogo/generator/PogoDslGeneratorMWE.mwe2";
    public static PogoDslPackage dp = PogoDslPackage.eINSTANCE;
    public static PogoDslFactory factory = PogoDslFactory.eINSTANCE;

    private OAWutils() {
        System.setProperty("file.encoding", "ISO-8859-1");
        String string = System.getenv("backend");
        if (string != null) {
            backend = string;
        }
        System.out.println("backend=" + backend);
    }

    public static OAWutils getInstance() {
        if (instance == null) {
            instance = new OAWutils();
        }
        return instance;
    }

    public PogoMultiClasses loadMultiClassesModel(String string) throws PogoException {
        Object object = this.loadTheModel(string);
        if (!(object instanceof PogoMultiClasses)) {
            throw new PogoException("This is not a Pogo Multi Classes file !");
        }
        PogoMultiClasses pogoMultiClasses = (PogoMultiClasses)object;
        this.reverseClassOrder(pogoMultiClasses);
        this.setProjectPath(pogoMultiClasses, string);
        return pogoMultiClasses;
    }

    private void setProjectPath(PogoMultiClasses pogoMultiClasses, String string) {
        if (string.endsWith(".xmi")) {
            String string2 = Utils.getPath(string);
            pogoMultiClasses.setSourcePath(string2);
        }
    }

    public PogoDeviceClass loadDeviceClassModel(String string) throws PogoException {
        return this.loadDeviceClassModel(string, true);
    }

    public PogoDeviceClass loadDeviceClassModel(String string, boolean bl) throws PogoException {
        Object object;
        if (bl) {
            ParserTool.renameXmiKey("<inheritance ", "<inheritances ", string);
        }
        if (!((object = this.loadTheModel(string)) instanceof PogoDeviceClass)) {
            throw new PogoException("This is not a Pogo Device Class file !");
        }
        return (PogoDeviceClass)object;
    }

    private Object loadTheModel(String string) throws PogoException {
        ParserTool.removeXmiKey("htmlInheritance", string);
        System.out.println("Loading " + string);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI uRI = URI.createFileURI(new File(string).getAbsolutePath());
        Resource resource = new ResourceSetImpl().createResource(uRI);
        try {
            resource.load(null);
        }
        catch (IOException iOException) {
            throw new PogoException(iOException.toString());
        }
        PogoSystem pogoSystem = (PogoSystem)resource.getContents().get(0);
        if (pogoSystem.getMultiClasses().size() > 0) {
            return pogoSystem.getMultiClasses().get(0);
        }
        return pogoSystem.getClasses().get(0);
    }

    private String generateXmiFile(PogoDeviceClass pogoDeviceClass) throws PogoException {
        if (pogoDeviceClass.getDescription().getIdentification() == null) {
            pogoDeviceClass.getDescription().setIdentification(factory.createClassIdentification());
        }
        PogoSystem pogoSystem = this.buildPogoSystem(pogoDeviceClass);
        pogoDeviceClass.setPogoRevision(Double.toString(Utils.getPogoGuiRevision()));
        String string = pogoDeviceClass.getDescription().getSourcePath() + "/" + pogoDeviceClass.getName() + ".xmi";
        if (!Utils.osIsUnix()) {
            string = "//" + string;
        }
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI uRI = URI.createFileURI(new File(string).getAbsolutePath());
        Resource resource = resourceSetImpl.createResource(uRI);
        resource.getContents().add(pogoSystem);
        try {
            resource.save(Collections.EMPTY_MAP);
            System.out.println(string + " generated");
        }
        catch (IOException iOException) {
            throw new PogoException(iOException.toString());
        }
        return string;
    }

    public void generate(PogoDeviceClass pogoDeviceClass) throws PogoException {
        String string = this.generateXmiFile(pogoDeviceClass);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("targetDir", pogoDeviceClass.getDescription().getSourcePath());
        hashMap.put("targetLanguage", pogoDeviceClass.getDescription().getLanguage());
        hashMap.put("modelPath", string);
        System.setProperty("targetDir", pogoDeviceClass.getDescription().getSourcePath());
        System.setProperty("className", pogoDeviceClass.getName());
        System.setProperty("targetLanguage", this.generateCodeFiles(pogoDeviceClass.getDescription()) ? pogoDeviceClass.getDescription().getLanguage() : "");
        System.setProperty("python package", pogoDeviceClass.getDescription().getFilestogenerate().contains("Python Package") ? "true" : "false");
        Utils.manageHtmlDirectory(pogoDeviceClass, true);
        try {
            System.out.println("Running Workflow for " + pogoDeviceClass.getDescription().getFilestogenerate() + "\tfrom:\n" + string);
            this.runWorkflow(hashMap);
        }
        catch (PogoException pogoException) {
            Utils.manageHtmlDirectory(pogoDeviceClass, false);
            throw pogoException;
        }
        Utils.manageHtmlDirectory(pogoDeviceClass, false);
        if (pogoDeviceClass.getDescription().getFilestogenerate().contains("VC")) {
            ParserTool.manageWindowsProjects(pogoDeviceClass);
        }
    }

    private boolean generateCodeFiles(ClassDescription classDescription) {
        String string = classDescription.getFilestogenerate().toLowerCase();
        return string.contains("code files");
    }

    public void generate(PogoMultiClasses pogoMultiClasses) throws PogoException {
        PogoSystem pogoSystem = factory.createPogoSystem();
        this.reverseClassOrder(pogoMultiClasses);
        pogoSystem.getMultiClasses().add(pogoMultiClasses);
        pogoMultiClasses.setPogoRevision(Double.toString(Utils.getPogoGuiRevision()));
        String string = pogoMultiClasses.getSourcePath() + "/" + pogoMultiClasses.getName() + ".multi.xmi";
        if (!Utils.osIsUnix()) {
            string = "//" + string;
        }
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI uRI = URI.createFileURI(new File(string).getAbsolutePath());
        Resource resource = resourceSetImpl.createResource(uRI);
        resource.getContents().add(pogoSystem);
        try {
            resource.save(Collections.EMPTY_MAP);
            System.out.println(string + " generated");
        }
        catch (IOException iOException) {
            throw new PogoException(iOException.toString());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("targetDir", pogoMultiClasses.getSourcePath());
        hashMap.put("targetLanguage", "MultiCpp");
        hashMap.put("modelPath", string);
        System.setProperty("targetDir", pogoMultiClasses.getSourcePath());
        System.setProperty("targetLanguage", "MultiCpp");
        this.runWorkflow(hashMap);
    }

    public void runWorkflow(HashMap<String, String> hashMap) throws PogoException {
        try {
            URL uRL = this.getClass().getResource(backend);
            URI uRI = URI.createURI(uRL.toString());
            long l = System.currentTimeMillis();
            Injector injector = new Mwe2StandaloneSetup().createInjectorAndDoEMFRegistration();
            Mwe2Runner mwe2Runner = injector.getInstance(Mwe2Runner.class);
            mwe2Runner.run(uRI, hashMap);
            long l2 = System.currentTimeMillis();
            System.out.println("elapsed time : " + (l2 - l) + " ms");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PogoException(exception.toString());
        }
    }

    private void doPreProcessing(PogoDeviceClass pogoDeviceClass) throws PogoException {
        Object object;
        String string = System.getenv("INSTITUTE");
        if (string == null) {
            string = System.getProperty("INSTITUTE");
        }
        if (string != null) {
            pogoDeviceClass.setInstitute(string.toUpperCase());
        }
        Preferences preferences = factory.createPreferences();
        preferences.setMakefileHome(PogoProperty.makefileHome);
        preferences.setDocHome(PogoProperty.docHome);
        pogoDeviceClass.setPreferences(preferences);
        if (pogoDeviceClass.getDescription().getFilestogenerate().toLowerCase().contains("code") && pogoDeviceClass.getDescription().getLanguage().toLowerCase().equals("cpp")) {
            ParserTool.modifyProtectedAreaID(pogoDeviceClass.getDescription().getSourcePath(), "ClassFactory.cpp", "ClassFactory.cpp", pogoDeviceClass.getName() + "::ClassFactory.cpp");
            new ParserTool().convertForXTendCompatibility(pogoDeviceClass, true);
        }
        if (pogoDeviceClass.getDescription().getFilestogenerate().contains("html")) {
            object = pogoDeviceClass.getDescription().getSourcePath() + "/" + pogoDeviceClass.getPreferences().getDocHome() + "/Description.html";
            pogoDeviceClass.getDescription().setDescriptionHtmlExists(Utils.strBoolean(new File((String)object).exists()));
        }
        object = pogoDeviceClass.getDeviceProperties();
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (Utils.isTrue(property.getMandatory())) {
                bl = true;
            }
            if (!Utils.isFalse(property.getStatus().getInherited())) continue;
            bl2 = true;
        }
        pogoDeviceClass.getDescription().setHasMandatoryProperty(Utils.strBoolean(bl));
        pogoDeviceClass.getDescription().setHasConcreteProperty(Utils.strBoolean(bl2));
    }

    public static Command[] createStateStatusCommand() {
        Command[] commandArray = new Command[2];
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            String string3;
            String string4;
            if (i == 0) {
                string4 = "State";
                string3 = "This command gets the device state (stored in its device_state data member) and returns it to the caller.";
                string2 = "State";
                string = "Device state";
            } else {
                string4 = "Status";
                string3 = "This command gets the device status (stored in its device_status data member) and returns it to the caller.";
                string2 = "ConstDevString";
                string = "Device status";
            }
            Command command = factory.createCommand();
            command.setName(string4);
            command.setExecMethod(Utils.buildCppExecuteMethodName(string4));
            command.setDescription(string3);
            Argument argument = factory.createArgument();
            Argument argument2 = factory.createArgument();
            Type type = OAWutils.tango2pogoType("DevVoid");
            Type type2 = OAWutils.tango2pogoType(string2);
            argument.setType(type);
            argument2.setType(type2);
            argument.setDescription("none");
            argument2.setDescription(string);
            command.setArgin(argument);
            command.setArgout(argument2);
            InheritanceStatus inheritanceStatus = factory.createInheritanceStatus();
            inheritanceStatus.setAbstract("true");
            inheritanceStatus.setInherited("true");
            inheritanceStatus.setConcrete("true");
            command.setStatus(inheritanceStatus);
            commandArray[i] = command;
        }
        return commandArray;
    }

    public static Type createType(Type type) {
        return OAWutils.tango2pogoType(OAWutils.pogo2tangoType(type.toString()));
    }

    public static Type tango2pogoType(String string) {
        if (string.startsWith("Tango::")) {
            string = string.substring("Tango::".length());
        }
        if (string.equals("void")) {
            string = "DevVoid";
        }
        if (string.equals("DevVoid")) {
            return factory.createVoidType();
        }
        if (string.equals("DevBoolean")) {
            return factory.createBooleanType();
        }
        if (string.equals("DevShort")) {
            return factory.createShortType();
        }
        if (string.equals("DevLong")) {
            return factory.createIntType();
        }
        if (string.equals("DevFloat")) {
            return factory.createFloatType();
        }
        if (string.equals("DevDouble")) {
            return factory.createDoubleType();
        }
        if (string.equals("DevUShort")) {
            return factory.createUShortType();
        }
        if (string.equals("DevULong")) {
            return factory.createUIntType();
        }
        if (string.equals("DevString")) {
            return factory.createStringType();
        }
        if (string.equals("DevVarCharArray")) {
            return factory.createCharArrayType();
        }
        if (string.equals("DevVarShortArray")) {
            return factory.createShortArrayType();
        }
        if (string.equals("DevVarLongArray") || string.equals("DevVarIntArray")) {
            return factory.createIntArrayType();
        }
        if (string.equals("DevVarFloatArray")) {
            return factory.createFloatArrayType();
        }
        if (string.equals("DevVarDoubleArray")) {
            return factory.createDoubleArrayType();
        }
        if (string.equals("DevVarUShortArray")) {
            return factory.createUShortArrayType();
        }
        if (string.equals("DevVarULongArray") || string.equals("DevVarUIntArray")) {
            return factory.createUIntArrayType();
        }
        if (string.equals("DevVarStringArray")) {
            return factory.createStringArrayType();
        }
        if (string.equals("DevVarLongStringArray")) {
            return factory.createLongStringArrayType();
        }
        if (string.equals("DevVarDoubleStringArray")) {
            return factory.createDoubleStringArrayType();
        }
        if (string.equals("DevState") || string.equals("State")) {
            return factory.createStateType();
        }
        if (string.equals("ConstDevString")) {
            return factory.createConstStringType();
        }
        if (string.equals("DevVarBooleanArray")) {
            return factory.createBooleanArrayType();
        }
        if (string.equals("DevUChar")) {
            return factory.createUCharType();
        }
        if (string.equals("DevLong64")) {
            return factory.createLongType();
        }
        if (string.equals("DevULong64")) {
            return factory.createULongType();
        }
        if (string.equals("DevVarLong64Array")) {
            return factory.createLongArrayType();
        }
        if (string.equals("DevVarULong64Array")) {
            return factory.createULongArrayType();
        }
        if (string.equals("DevInt")) {
            return factory.createIntType();
        }
        if (string.equals("DevEncoded")) {
            return factory.createEncodedType();
        }
        if (string.equals("DevEnum")) {
            return factory.createEnumType();
        }
        System.out.println(string + " NOT FOUND !!!");
        return null;
    }

    public static String pogo2tangoType(String string) {
        String string2 = "fr.esrf.tango.pogo.pogoDsl.impl.";
        String string3 = "TypeImpl";
        if (string.startsWith(string2)) {
            String string4 = string.substring(string2.length());
            int n = string4.indexOf(string3);
            if (n > 0) {
                string4 = string4.substring(0, n);
            }
            if (string4.contains("Array")) {
                if (string4.contains("LongString")) {
                    return "DevVarLongStringArray";
                }
                if (string4.contains("DoubleString")) {
                    return "DevVarDoubleStringArray";
                }
                if (string4.contains("ULong")) {
                    return "DevVarULong64Array";
                }
                if (string4.contains("Long")) {
                    return "DevVarLong64Array";
                }
                if (string4.contains("UInt")) {
                    return "DevVarULongArray";
                }
                if (string4.contains("Int")) {
                    return "DevVarLongArray";
                }
                return "DevVar" + string4;
            }
            if (string4.startsWith("Const")) {
                return TangoConst.Tango_CmdArgTypeName[20];
            }
            switch (string4) {
                case "State": {
                    return string4;
                }
                case "Long": {
                    return "DevLong64";
                }
                case "ULong": {
                    return "DevULong64";
                }
                case "Int": {
                    return "DevLong";
                }
                case "UInt": {
                    return "DevULong";
                }
            }
            return "Dev" + string4;
        }
        return "Not a Pogo Type";
    }

    private PogoSystem buildPogoSystem(PogoDeviceClass pogoDeviceClass) throws PogoException {
        PogoSystem pogoSystem = factory.createPogoSystem();
        this.doPreProcessing(pogoDeviceClass);
        pogoSystem.getClasses().add(pogoDeviceClass);
        return pogoSystem;
    }

    private void reverseClassOrder(PogoMultiClasses pogoMultiClasses) {
        EList<OneClassSimpleDef> eList = pogoMultiClasses.getClasses();
        ArrayList<OneClassSimpleDef> arrayList = new ArrayList<OneClassSimpleDef>();
        for (OneClassSimpleDef oneClassSimpleDef : eList) {
            arrayList.add(0, oneClassSimpleDef);
        }
        eList.clear();
        for (OneClassSimpleDef oneClassSimpleDef : arrayList) {
            eList.add(oneClassSimpleDef);
        }
    }

    public static ClassIdentification cloneClassIdentification(ClassIdentification classIdentification) {
        ClassIdentification classIdentification2 = factory.createClassIdentification();
        classIdentification2.setBus(classIdentification.getBus());
        classIdentification2.setClassFamily(classIdentification.getClassFamily());
        classIdentification2.setContact(classIdentification.getContact());
        classIdentification2.setAuthor(classIdentification.getAuthor());
        classIdentification2.setEmailDomain(classIdentification.getEmailDomain());
        classIdentification2.setManufacturer(classIdentification.getManufacturer());
        classIdentification2.setPlatform(classIdentification.getPlatform());
        classIdentification2.setReference(classIdentification.getReference());
        classIdentification2.setSiteSpecific(classIdentification.getSiteSpecific());
        EList<String> eList = classIdentification2.getKeyWords();
        EList<String> eList2 = classIdentification.getKeyWords();
        for (String string : eList2) {
            eList.add(string);
        }
        return classIdentification2;
    }

    public static Type cloneType(Type type) {
        String string = OAWutils.pogo2tangoType(type.toString());
        return OAWutils.tango2pogoType(string);
    }

    public static PropType cloneType(PropType propType) {
        String string = PropertyDialog.pogo2tangoType(propType);
        return PropertyDialog.tango2pogoType(string);
    }

    public static Command cloneCommand(Command command) {
        Command command2 = factory.createCommand();
        String string = command.getName();
        command2.setName(string);
        command2.setExecMethod(Utils.buildCppExecuteMethodName(string));
        command2.setDescription(command.getDescription());
        command2.setIsDynamic(command.getIsDynamic());
        Argument argument = factory.createArgument();
        argument.setType(OAWutils.cloneType(command.getArgin().getType()));
        argument.setDescription(command.getArgin().getDescription());
        command2.setArgin(argument);
        Argument argument2 = factory.createArgument();
        argument2.setType(OAWutils.cloneType(command.getArgout().getType()));
        argument2.setDescription(command.getArgout().getDescription());
        command2.setArgout(argument2);
        if (command.getDisplayLevel() == null) {
            command2.setDisplayLevel("OPERATOR");
        } else {
            command2.setDisplayLevel(command.getDisplayLevel());
        }
        InheritanceStatus inheritanceStatus = factory.createInheritanceStatus();
        InheritanceStatus inheritanceStatus2 = command.getStatus();
        inheritanceStatus.setAbstract(inheritanceStatus2.getAbstract());
        inheritanceStatus.setInherited(inheritanceStatus2.getInherited());
        inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
        inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
        command2.setStatus(inheritanceStatus);
        EList<String> eList = command.getExcludedStates();
        EList<String> eList2 = command2.getExcludedStates();
        for (String string2 : eList) {
            eList2.add(string2);
        }
        command2.setPolledPeriod(command.getPolledPeriod());
        return command2;
    }

    public static Attribute cloneAttribute(Attribute attribute) {
        EObject eObject;
        EventCriteria eventCriteria;
        Attribute attribute2 = factory.createAttribute();
        attribute2.setName(attribute.getName());
        attribute2.setIsDynamic(attribute.getIsDynamic());
        attribute2.setAttType(attribute.getAttType());
        attribute2.setRwType(attribute.getRwType());
        if (attribute.getAssociatedAttr() != null && attribute.getAssociatedAttr().length() > 0) {
            attribute2.setAssociatedAttr(attribute.getAssociatedAttr());
        }
        attribute2.setDataType(OAWutils.cloneType(attribute.getDataType()));
        EList<String> eList = attribute.getEnumLabels();
        EList<String> eList2 = attribute2.getEnumLabels();
        for (String object22 : eList) {
            eList2.add(object22);
        }
        attribute2.setMaxX(attribute.getMaxX());
        attribute2.setMaxY(attribute.getMaxY());
        AttrProperties attrProperties = factory.createAttrProperties();
        AttrProperties attrProperties2 = attribute.getProperties();
        attrProperties.setDescription(attrProperties2.getDescription());
        attrProperties.setLabel(attrProperties2.getLabel());
        attrProperties.setUnit(attrProperties2.getUnit());
        attrProperties.setStandardUnit(attrProperties2.getStandardUnit());
        attrProperties.setDisplayUnit(attrProperties2.getDisplayUnit());
        attrProperties.setFormat(attrProperties2.getFormat());
        attrProperties.setMaxValue(attrProperties2.getMaxValue());
        attrProperties.setMinValue(attrProperties2.getMinValue());
        attrProperties.setMaxAlarm(attrProperties2.getMaxAlarm());
        attrProperties.setMinAlarm(attrProperties2.getMinAlarm());
        attrProperties.setMaxWarning(attrProperties2.getMaxWarning());
        attrProperties.setMinWarning(attrProperties2.getMinWarning());
        attrProperties.setDeltaTime(attrProperties2.getDeltaTime());
        attrProperties.setDeltaValue(attrProperties2.getDeltaValue());
        attribute2.setProperties(attrProperties);
        attribute2.setPolledPeriod(attribute.getPolledPeriod());
        if (attribute.getDisplayLevel() == null) {
            attribute2.setDisplayLevel("OPERATOR");
        } else {
            attribute2.setDisplayLevel(attribute.getDisplayLevel());
        }
        attribute2.setMemorized(attribute.getMemorized());
        attribute2.setMemorizedAtInit(attribute.getMemorizedAtInit());
        InheritanceStatus inheritanceStatus = factory.createInheritanceStatus();
        InheritanceStatus inheritanceStatus2 = attribute.getStatus();
        inheritanceStatus.setAbstract(inheritanceStatus2.getAbstract());
        inheritanceStatus.setInherited(inheritanceStatus2.getInherited());
        inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
        inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
        EList<String> eList3 = attribute.getReadExcludedStates();
        EList<String> eList4 = attribute2.getReadExcludedStates();
        for (String string : eList3) {
            eList4.add(string);
        }
        eList3 = attribute.getWriteExcludedStates();
        eList4 = attribute2.getWriteExcludedStates();
        for (String string : eList3) {
            eList4.add(string);
        }
        attribute2.setStatus(inheritanceStatus);
        attribute2.setAllocReadMember(attribute.getAllocReadMember());
        EventCriteria eventCriteria2 = attribute.getEventCriteria();
        if (OAWutils.eventCriteriaIsSet(eventCriteria2)) {
            EventCriteria eventCriteria3 = factory.createEventCriteria();
            eventCriteria3.setPeriod(eventCriteria2.getPeriod());
            eventCriteria3.setRelChange(eventCriteria2.getRelChange());
            eventCriteria3.setAbsChange(eventCriteria2.getAbsChange());
            attribute2.setEventCriteria(eventCriteria3);
        }
        if (OAWutils.eventCriteriaIsSet(eventCriteria = attribute.getEvArchiveCriteria())) {
            eObject = factory.createEventCriteria();
            eObject.setPeriod(eventCriteria.getPeriod());
            eObject.setRelChange(eventCriteria.getRelChange());
            eObject.setAbsChange(eventCriteria.getAbsChange());
            attribute2.setEvArchiveCriteria((EventCriteria)eObject);
        }
        if (attribute.getChangeEvent() != null) {
            eObject = factory.createFireEvents();
            eObject.setFire(attribute.getChangeEvent().getFire());
            eObject.setLibCheckCriteria(attribute.getChangeEvent().getLibCheckCriteria());
            attribute2.setChangeEvent((FireEvents)eObject);
        }
        if (attribute.getArchiveEvent() != null) {
            eObject = factory.createFireEvents();
            eObject.setFire(attribute.getArchiveEvent().getFire());
            eObject.setLibCheckCriteria(attribute.getArchiveEvent().getLibCheckCriteria());
            attribute2.setArchiveEvent((FireEvents)eObject);
        }
        if (attribute.getDataReadyEvent() != null) {
            eObject = factory.createFireEvents();
            eObject.setFire(attribute.getDataReadyEvent().getFire());
            eObject.setLibCheckCriteria(attribute.getDataReadyEvent().getLibCheckCriteria());
            attribute2.setDataReadyEvent((FireEvents)eObject);
        }
        return attribute2;
    }

    private static boolean eventCriteriaIsSet(EventCriteria eventCriteria) {
        return eventCriteria != null && (eventCriteria.getPeriod().length() > 0 || eventCriteria.getRelChange().length() > 0 || eventCriteria.getAbsChange().length() > 0);
    }

    public static Property cloneProperty(Property property) {
        Property property2 = factory.createProperty();
        property2.setName(property.getName());
        property2.setDescription(property.getDescription());
        property2.setType(OAWutils.cloneType(property.getType()));
        EList<String> eList = property2.getDefaultPropValue();
        EList<String> eList2 = property.getDefaultPropValue();
        for (String object2 : eList2) {
            eList.add(object2);
        }
        InheritanceStatus inheritanceStatus = factory.createInheritanceStatus();
        InheritanceStatus inheritanceStatus2 = property.getStatus();
        inheritanceStatus.setAbstract(inheritanceStatus2.getAbstract());
        inheritanceStatus.setInherited(inheritanceStatus2.getInherited());
        inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
        inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
        property2.setStatus(inheritanceStatus);
        if (Utils.isTrue(property.getMandatory())) {
            property2.setMandatory("true");
        }
        return property2;
    }

    public static State cloneState(State state) {
        State state2 = factory.createState();
        state2.setName(state.getName());
        state2.setDescription(state.getDescription());
        InheritanceStatus inheritanceStatus = factory.createInheritanceStatus();
        InheritanceStatus inheritanceStatus2 = state.getStatus();
        inheritanceStatus.setAbstract(inheritanceStatus2.getAbstract());
        inheritanceStatus.setInherited(inheritanceStatus2.getInherited());
        inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
        inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
        state2.setStatus(inheritanceStatus);
        return state2;
    }

    public static ForwardedAttribute cloneForwardedAttribute(ForwardedAttribute forwardedAttribute) {
        ForwardedAttribute forwardedAttribute2 = factory.createForwardedAttribute();
        forwardedAttribute2.setName(forwardedAttribute.getName());
        forwardedAttribute2.setLabel(forwardedAttribute.getLabel());
        InheritanceStatus inheritanceStatus = factory.createInheritanceStatus();
        InheritanceStatus inheritanceStatus2 = forwardedAttribute.getStatus();
        inheritanceStatus.setAbstract(inheritanceStatus2.getAbstract());
        inheritanceStatus.setInherited(inheritanceStatus2.getInherited());
        inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
        inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
        forwardedAttribute2.setStatus(inheritanceStatus);
        return forwardedAttribute2;
    }

    public static Pipe clonePipe(Pipe pipe) {
        Pipe pipe2 = factory.createPipe();
        pipe2.setName(pipe.getName());
        pipe2.setLabel(pipe.getLabel());
        pipe2.setDescription(pipe.getDescription());
        pipe2.setDisplayLevel(pipe.getDisplayLevel());
        pipe2.setRwType(pipe.getRwType());
        EList<String> eList = pipe.getReadExcludedStates();
        EList<String> eList2 = pipe2.getReadExcludedStates();
        for (String string : eList) {
            eList2.add(string);
        }
        eList = pipe.getWriteExcludedStates();
        eList2 = pipe2.getWriteExcludedStates();
        for (String string : eList) {
            eList2.add(string);
        }
        return pipe2;
    }

    public static AdditionalFile cloneAdditionalFile(AdditionalFile additionalFile) {
        AdditionalFile additionalFile2 = factory.createAdditionalFile();
        additionalFile2.setName(additionalFile.getName());
        additionalFile2.setPath(additionalFile.getPath());
        return additionalFile2;
    }
}

