/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.packaging;

import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PackUtils {
    private static PackUtils instance = null;

    private PackUtils() {
    }

    public static PackUtils getInstance() {
        if (instance == null) {
            instance = new PackUtils();
        }
        return instance;
    }

    public boolean fileExistsInPackage(String fileName) {
        URL url = this.getClass().getResource("/packaging/" + fileName);
        return url != null;
    }

    public String readFileFromPackage(String fileName) throws PogoException {
        String str = "";
        try {
            URL url = this.getClass().getResource(fileName);
            if (url == null) {
                throw new PogoException("URL for packaging file (" + fileName + ") is null !");
            }
            InputStream is = url.openStream();
            int size = is.available();
            byte[] bytes = new byte[size];
            if ((size = is.read(bytes)) > 0) {
                str = ParserTool.takeOffWindowsChar(bytes);
            }
        }
        catch (PogoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PogoException(e.toString());
        }
        return str;
    }

    public static List<String> getFileList(String path, String extension) throws PogoException {
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            File inDir = new File(path);
            String[] fileNames = inDir.list();
            if (fileNames == null) {
                return fileList;
            }
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename;
                File f;
                String name = stringArray[n2];
                if (name.endsWith(extension) && (f = new File(filename = String.valueOf(path) + "/" + name)).isFile()) {
                    fileList.add(name);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new PogoException(e.toString());
        }
        return fileList;
    }

    public static String executeShellCommand(String command) throws PogoException {
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            Process process = Runtime.getRuntime().exec(command);
            InputStream inputStream = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((str = br.readLine()) != null) {
                sb.append(str).append("\n");
            }
            process.waitFor();
            int retVal = process.exitValue();
            if (retVal != 0) {
                InputStream errorStream = process.getErrorStream();
                br = new BufferedReader(new InputStreamReader(errorStream));
                while ((str = br.readLine()) != null) {
                    sb.append(str).append("\n");
                }
                throw new PogoException("The shell command\n" + command + "\nreturns : " + retVal + " !\n\n" + sb);
            }
        }
        catch (Exception e) {
            throw new PogoException("Failed to execute: " + command + "\n" + e);
        }
        return sb.toString();
    }

    public static boolean isAvailable() {
        return Utils.osIsUnix();
    }

    public static String buildNextLine(String str) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            indent.append(" ");
            ++i;
        }
        return " \\\\\n" + indent;
    }

    public static void buildDirectories(String[] directories, String path) throws PogoException {
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String directory = stringArray[n2];
            String dirName = String.valueOf(path) + "/" + directory;
            File dir = new File(dirName);
            if (!dir.exists()) {
                if (!dir.mkdir()) {
                    throw new PogoException("Directory '" + dirName + "' cannot be created");
                }
                PackUtils.println(String.valueOf(path) + " created.");
            }
            ++n2;
        }
    }

    public static String buildConfigureList(List<String> list) {
        String str = " ";
        for (String item : list) {
            str = String.valueOf(str) + item + " ";
        }
        return str;
    }

    private static String replace(String code, String src, String target) {
        int start;
        while ((start = code.indexOf(src)) > 0) {
            int end = start + src.length();
            code = String.valueOf(code.substring(0, start)) + target + code.substring(end);
        }
        return code;
    }

    public static String buildConfigureDefine(String s) {
        s = s.toUpperCase();
        s = PackUtils.replace(s, "/", "_");
        s = PackUtils.replace(s, ".", "_");
        return s;
    }

    public static String buildMailAddress(ClassDescription description) {
        return String.valueOf(description.getIdentification().getAuthor()) + "@" + description.getIdentification().getEmailDomain();
    }

    static boolean authorFileExists(String path) {
        return new File(String.valueOf(path) + "/packaging/" + "AUTHORS").exists();
    }

    public static void println(String str) {
        String env = System.getenv("DEBUG");
        if (env != null && env.equals("true")) {
            System.out.println(str);
        }
    }
}

