/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tango.pogo.pogo_gui.ClassDialog;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class TemplateChooser
extends JDialog {
    private JFrame parent;
    private DeviceClass deviceClass = null;
    private int returnValue = 0;
    private static final String extension = ".xmi";
    private JComboBox<TemplateClass> comboBox;
    private JLabel titleLabel;

    public TemplateChooser(JFrame jFrame) throws PogoException {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        List<TemplateClass> list = this.getTemplates();
        for (TemplateClass templateClass : list) {
            this.comboBox.addItem(templateClass);
        }
        this.titleLabel.setText("Select a TANGO class template");
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private static String getPath() {
        return System.getenv("TEMPLATES_PATH");
    }

    public static boolean templatesAvailable() {
        String string = TemplateChooser.getPath();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        String[] stringArray = file.list();
        return stringArray != null && stringArray.length > 0;
    }

    private List<TemplateClass> getTemplates() throws PogoException {
        ArrayList<TemplateClass> arrayList = new ArrayList<TemplateClass>();
        String string = TemplateChooser.getPath();
        if (string != null) {
            List<TemplateClass> list = this.getTemplateClasses(string);
            for (TemplateClass templateClass : list) {
                arrayList.add(templateClass);
            }
        }
        Collections.sort(arrayList, new TemplateCompare());
        return arrayList;
    }

    private List<TemplateClass> getTemplateClasses(String string) {
        ArrayList<TemplateClass> arrayList = new ArrayList<TemplateClass>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!new File(string + '/' + string2).isFile() || !string2.endsWith(extension)) continue;
                arrayList.add(new TemplateClass(string, string2));
            }
        }
        return arrayList;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.comboBox = new JComboBox();
        JButton jButton = new JButton();
        JPanel jPanel3 = new JPanel();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TemplateChooser.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel2.add(this.comboBox, gridBagConstraints);
        jButton.setText("?");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateChooser.this.helpBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        jButton2.setText("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateChooser.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton2);
        jButton3.setText("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateChooser.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton3);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        try {
            TemplateClass templateClass = (TemplateClass)this.comboBox.getSelectedItem();
            this.deviceClass = new DeviceClass(templateClass.fileName);
            ClassDescription classDescription = this.deviceClass.getPogoDeviceClass().getDescription();
            classDescription.setSourcePath("");
            classDescription.setCopyright("");
            classDescription.getIdentification().setAuthor("");
            classDescription.getIdentification().setBus("");
            classDescription.getIdentification().setContact("");
            classDescription.getIdentification().setEmailDomain("");
            ClassDialog classDialog = new ClassDialog(this.parent, null, this.deviceClass, false);
            if (classDialog.showDialog() == 0) {
                this.deviceClass = classDialog.getInputs();
                this.returnValue = 0;
            } else {
                this.returnValue = 2;
            }
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
        }
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void helpBtnActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "To add your own templates:\n  - Add xmi files in a specific directory\n  - Export TEMPLATES_PATH environment variable with path of this directory.\n  - Restart Pogo.\n\nYour templates could override the default ones");
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public DeviceClass getDeviceClass() throws PogoException {
        return this.deviceClass;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public static void main(String[] stringArray) {
        try {
            new TemplateChooser(null).setVisible(true);
        }
        catch (PogoException pogoException) {
            pogoException.popup(new JFrame());
            System.exit(0);
        }
    }

    class TemplateCompare
    implements Comparator<TemplateClass> {
        TemplateCompare() {
        }

        @Override
        public int compare(TemplateClass templateClass, TemplateClass templateClass2) {
            return templateClass.name.compareTo(templateClass2.name);
        }
    }

    private class TemplateClass {
        private String name;
        private String fileName;

        private TemplateClass(String string, String string2) {
            this.fileName = string + '/' + string2;
            this.name = string2.substring(0, string2.length() - TemplateChooser.extension.length());
        }

        public String toString() {
            return this.name;
        }
    }
}

