/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitorWithParameter;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Singleton
public class FeatureOverridesService {
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private TypeArgumentContextProvider contextProvider;

    @Inject
    protected FeatureOverridesService() {
    }

    public FeatureOverridesService(SuperTypeCollector superTypeCollector, TypeArgumentContextProvider contextProvider) {
        this.superTypeCollector = superTypeCollector;
        this.contextProvider = contextProvider;
    }

    public Iterable<JvmFeature> getAllJvmFeatures(JvmTypeReference type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ITypeArgumentContext context = this.contextProvider.getTypeArgumentContext(new TypeArgumentContextProvider.ReceiverRequest(type));
        JvmType rawType = type.getType();
        if (rawType == null || rawType.eIsProxy() || !(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        return this.getAllJvmFeatures((JvmDeclaredType)rawType, context);
    }

    public Iterable<JvmFeature> getAllJvmFeatures(JvmDeclaredType type, ITypeArgumentContext ctx) {
        LinkedHashMultimap<Triple<EClass, String, Integer>, JvmFeature> featureIndex = LinkedHashMultimap.create();
        this.indexFeatures(type, featureIndex);
        Set<JvmTypeReference> types = this.superTypeCollector.collectSuperTypes(type);
        for (JvmTypeReference jvmTypeReference : types) {
            JvmType jvmType = jvmTypeReference.getType();
            if (!(jvmType instanceof JvmDeclaredType)) continue;
            this.indexFeatures((JvmDeclaredType)jvmType, featureIndex);
        }
        return this.removeOverridden(featureIndex, ctx);
    }

    protected void indexFeatures(JvmDeclaredType type, Multimap<Triple<EClass, String, Integer>, JvmFeature> index) {
        for (JvmMember member : type.getMembers()) {
            Triple<EClass, String, Integer> key;
            if (member instanceof JvmExecutable) {
                key = Tuples.create(member.eClass(), member.getSimpleName(), ((JvmExecutable)member).getParameters().size());
                index.put(key, (JvmFeature)member);
                continue;
            }
            if (!(member instanceof JvmField)) continue;
            key = Tuples.create(member.eClass(), member.getSimpleName(), -1);
            index.put(key, (JvmFeature)member);
        }
    }

    protected Iterable<JvmFeature> removeOverridden(Multimap<Triple<EClass, String, Integer>, JvmFeature> featureIndex, ITypeArgumentContext ctx) {
        LinkedHashSet<JvmFeature> result = Sets.newLinkedHashSet(featureIndex.values());
        for (Collection<JvmFeature> featuresWithSameName : featureIndex.asMap().values()) {
            if (featuresWithSameName.size() <= 1) continue;
            for (JvmFeature op1 : featuresWithSameName) {
                for (JvmFeature op2 : featuresWithSameName) {
                    if (!result.contains(op1) || op1.getDeclaringType() == op2.getDeclaringType() || !this.internalIsOverridden(op1, op2, ctx, true)) continue;
                    result.remove(op2);
                }
            }
        }
        return result;
    }

    protected boolean internalIsOverridden(JvmFeature overriding, JvmFeature overridden, ITypeArgumentContext context, boolean isCheckInheritance) {
        if (overriding == overridden) {
            return false;
        }
        if (!this.isNameEqual(overriding, overridden)) {
            return false;
        }
        if (overriding instanceof JvmOperation && overridden instanceof JvmOperation) {
            JvmOperation overridingOp = (JvmOperation)overriding;
            JvmOperation overriddenOp = (JvmOperation)overridden;
            if (!this.hasSameTypeParameters(overridingOp, overriddenOp, context)) {
                return false;
            }
            if (!this.isSameNumberOfArguments(overridingOp, overriddenOp)) {
                return false;
            }
            if (!this.isSameArgumentTypes(overridingOp, overriddenOp, context)) {
                return false;
            }
        }
        if (overriding instanceof JvmField && overridden instanceof JvmField) {
            JvmField overridingField = (JvmField)overriding;
            JvmField overriddenField = (JvmField)overridden;
            if (overridingField.isStatic() != overriddenField.isStatic()) {
                return false;
            }
        }
        return true;
    }

    public boolean isOverridden(JvmFeature overriding, JvmFeature overridden, ITypeArgumentContext context, boolean isCheckInheritance) {
        if (overriding == overridden) {
            return false;
        }
        if (overridden.getClass() != overriding.getClass()) {
            return false;
        }
        if (!this.isNameEqual(overriding, overridden)) {
            return false;
        }
        if (isCheckInheritance && !this.isInheritanceRelation(overriding, overridden)) {
            return false;
        }
        return this.internalIsOverridden(overriding, overridden, context, isCheckInheritance);
    }

    protected boolean isNameEqual(JvmFeature overriding, JvmFeature overridden) {
        return Objects.equal(overriding.getSimpleName(), overridden.getSimpleName());
    }

    protected boolean hasSameTypeParameters(JvmOperation overriding, JvmOperation overridden, ITypeArgumentContext context) {
        if (overriding.getTypeParameters().size() != overridden.getTypeParameters().size()) {
            return false;
        }
        for (JvmTypeParameter overriddenTypParameter : overridden.getTypeParameters()) {
            boolean matches = false;
            Iterator<JvmTypeParameter> iter = Sets.newHashSet(overriding.getTypeParameters()).iterator();
            while (iter.hasNext() && !matches) {
                JvmTypeParameter overridingTypeParameter = iter.next();
                if (!this.isSameConstraints(overridingTypeParameter, overriddenTypParameter, context)) continue;
                matches = true;
                iter.remove();
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    protected boolean isSameNumberOfArguments(JvmOperation overriding, JvmOperation overridden) {
        return overriding.getParameters().size() == overridden.getParameters().size();
    }

    protected boolean isSameArgumentTypes(JvmOperation overriding, JvmOperation overridden, ITypeArgumentContext context) {
        int i = 0;
        while (i < overriding.getParameters().size()) {
            boolean result;
            JvmTypeReference overriddenType;
            JvmFormalParameter overridingParam = (JvmFormalParameter)overriding.getParameters().get(i);
            JvmFormalParameter overriddenParam = (JvmFormalParameter)overridden.getParameters().get(i);
            JvmTypeReference overridingType = context.getLowerBound(overridingParam.getParameterType());
            if (!EcoreUtil.equals(overridingType, overriddenType = context.getLowerBound(overriddenParam.getParameterType())) && !(result = ((Boolean)new DeepChecker(context).visit(overridingType, overriddenType)).booleanValue())) {
                return result;
            }
            ++i;
        }
        return true;
    }

    protected boolean isSameConstraints(JvmConstraintOwner overridingConstraintOwner, JvmConstraintOwner overriddenConstraintOwner, ITypeArgumentContext context) {
        return this.isSameConstraints(overridingConstraintOwner, overriddenConstraintOwner, context, new DeepChecker(context));
    }

    protected boolean isSameConstraints(JvmConstraintOwner overridingConstraintOwner, JvmConstraintOwner overriddenConstraintOwner, ITypeArgumentContext context, DeepChecker deepChecker) {
        EList<JvmTypeConstraint> overriddenConstraints = overriddenConstraintOwner.getConstraints();
        HashSet<JvmLowerBound> overriddenLowerBoundConstraints = Sets.newHashSet(Iterables.filter(overriddenConstraints, JvmLowerBound.class));
        HashSet<JvmUpperBound> overriddenUpperBoundConstraints = Sets.newHashSet(Iterables.filter(overriddenConstraints, JvmUpperBound.class));
        HashSet<JvmLowerBound> filteredOverriddenConstraints = Sets.newHashSet(overriddenLowerBoundConstraints.size() > 0 ? overriddenLowerBoundConstraints : overriddenUpperBoundConstraints);
        EList<JvmTypeConstraint> overridingConstraints = overridingConstraintOwner.getConstraints();
        for (JvmTypeConstraint overridingConstraint : overriddenLowerBoundConstraints.size() > 0 ? Iterables.filter(overridingConstraints, JvmLowerBound.class) : Iterables.filter(overridingConstraints, JvmUpperBound.class)) {
            boolean matches = false;
            Iterator iter = filteredOverriddenConstraints.iterator();
            while (iter.hasNext() && !matches) {
                JvmTypeReference overriddenType;
                JvmTypeConstraint overriddenConstraint = (JvmTypeConstraint)iter.next();
                JvmTypeReference overridingType = context.getLowerBound(overridingConstraint.getTypeReference());
                if (EcoreUtil.equals(overridingType, overriddenType = context.getLowerBound(overriddenConstraint.getTypeReference()))) {
                    matches = true;
                    iter.remove();
                    continue;
                }
                boolean result = (Boolean)deepChecker.visit(overridingType, overriddenType);
                if (!result) continue;
                matches = true;
                iter.remove();
            }
            if (matches) continue;
            return false;
        }
        return filteredOverriddenConstraints.isEmpty();
    }

    protected boolean isInheritanceRelation(JvmMember overriding, JvmMember overridden) {
        return this.superTypeCollector.isSuperType(overriding.getDeclaringType(), overridden.getDeclaringType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DeepChecker
    extends AbstractTypeReferenceVisitorWithParameter.InheritanceAware<JvmTypeReference, Boolean> {
        private final ITypeArgumentContext context;
        private Map<JvmTypeParameter, JvmTypeParameter> assumeEqual;

        private DeepChecker(ITypeArgumentContext context) {
            this.context = context;
            this.assumeEqual = Maps.newHashMap();
        }

        @Override
        protected Boolean handleNullReference(JvmTypeReference parameter) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, JvmTypeReference param) {
            if (!(param instanceof JvmGenericArrayTypeReference)) {
                return Boolean.FALSE;
            }
            JvmTypeReference myComponentType = reference.getComponentType();
            JvmTypeReference otherComponentType = ((JvmGenericArrayTypeReference)param).getComponentType();
            return (Boolean)this.visit(myComponentType, otherComponentType);
        }

        @Override
        public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, JvmTypeReference param) {
            if (!(param instanceof JvmParameterizedTypeReference)) {
                return Boolean.FALSE;
            }
            JvmParameterizedTypeReference other = (JvmParameterizedTypeReference)param;
            if (reference.getArguments().size() != other.getArguments().size()) {
                return Boolean.FALSE;
            }
            if (reference.getType() != other.getType()) {
                JvmType plainOverridingType = reference.getType();
                JvmType plainOverriddenType = param.getType();
                if (plainOverridingType instanceof JvmTypeParameter && plainOverriddenType instanceof JvmTypeParameter) {
                    JvmTypeParameter overridingTypeParameter = (JvmTypeParameter)plainOverridingType;
                    JvmTypeParameter overriddenTypeParameter = (JvmTypeParameter)plainOverriddenType;
                    if (this.assumeEqual.containsKey(overridingTypeParameter)) {
                        if (this.assumeEqual.get(overridingTypeParameter) == overriddenTypeParameter) {
                            return true;
                        }
                        return false;
                    }
                    try {
                        this.assumeEqual.put(overridingTypeParameter, overriddenTypeParameter);
                        Boolean bl = FeatureOverridesService.this.isSameConstraints(overridingTypeParameter, overriddenTypeParameter, this.context, this);
                        return bl;
                    }
                    finally {
                        this.assumeEqual.remove(overridingTypeParameter);
                    }
                }
                return Boolean.FALSE;
            }
            int typeParamCount = reference.getArguments().size();
            int i = 0;
            while (i < typeParamCount) {
                JvmTypeReference otherTypeArgument;
                JvmTypeReference myTypeArgument = (JvmTypeReference)reference.getArguments().get(i);
                if (!((Boolean)this.visit(myTypeArgument, otherTypeArgument = (JvmTypeReference)other.getArguments().get(i))).booleanValue()) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean doVisitTypeReference(JvmTypeReference reference, JvmTypeReference param) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean doVisitWildcardTypeReference(JvmWildcardTypeReference reference, JvmTypeReference param) {
            if (!(param instanceof JvmWildcardTypeReference)) {
                return Boolean.FALSE;
            }
            JvmWildcardTypeReference other = (JvmWildcardTypeReference)param;
            return FeatureOverridesService.this.isSameConstraints(reference, other, this.context);
        }
    }
}

