/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.Strings;

public class EObjectDescriptionBasedStubGenerator
implements IStubGenerator {
    public String getJavaStubSource(IEObjectDescription description) {
        if (!this.isJvmDeclaredType(description)) {
            return null;
        }
        QualifiedName qualifiedName = description.getQualifiedName();
        StringBuilder classSignatureBuilder = new StringBuilder();
        if (qualifiedName.getSegments().size() > 1) {
            String string = qualifiedName.toString();
            classSignatureBuilder.append("package " + string.substring(0, string.lastIndexOf(46)) + ";");
            classSignatureBuilder.append("\n");
        }
        classSignatureBuilder.append("public ");
        if (description.getEClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            if (description.getUserData("interface") != null) {
                classSignatureBuilder.append("interface ");
            } else {
                classSignatureBuilder.append("class ");
            }
        } else if (description.getEClass() == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            classSignatureBuilder.append("enum ");
        } else if (description.getEClass() == TypesPackage.Literals.JVM_ANNOTATION_TYPE) {
            classSignatureBuilder.append("@interface ");
        }
        classSignatureBuilder.append(qualifiedName.getLastSegment());
        String typeParameters = description.getUserData("typeParameters");
        if (typeParameters != null) {
            classSignatureBuilder.append(typeParameters);
        }
        classSignatureBuilder.append("{}");
        return classSignatureBuilder.toString();
    }

    public String getJavaFileName(IEObjectDescription description) {
        if (!this.isJvmDeclaredType(description)) {
            return null;
        }
        QualifiedName typeName = description.getName();
        return String.valueOf(Strings.concat("/", typeName.getSegments())) + ".java";
    }

    protected boolean isJvmDeclaredType(IEObjectDescription description) {
        EClass eClass = description.getEClass();
        return (eClass == TypesPackage.Literals.JVM_GENERIC_TYPE || eClass == TypesPackage.Literals.JVM_ENUMERATION_TYPE || eClass == TypesPackage.Literals.JVM_ANNOTATION_TYPE) && description.getUserData("nestedType") == null;
    }

    public void doGenerateStubs(IFileSystemAccess access, IResourceDescription description) {
        for (IEObjectDescription objectDesc : description.getExportedObjects()) {
            String javaFileName = this.getJavaFileName(objectDesc);
            if (javaFileName == null) continue;
            String javaStubSource = this.getJavaStubSource(objectDesc);
            access.generateFile(javaFileName, javaStubSource);
        }
    }
}

