/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.trace.StorageAwareTrace;
import org.eclipse.xtext.builder.trace.TraceMarkers;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public class TraceForStorageProvider
implements ITraceForStorageProvider {
    @Deprecated
    public static final String TRACE_FILE_EXTENSION = "._trace";
    private static final Logger log = Logger.getLogger(TraceForStorageProvider.class);
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject
    private Provider<StorageAwareTrace> traceToSourceProvider;
    @Inject
    private TraceMarkers traceMarkers;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private ITraceURIConverter traceURIConverter;

    public ITrace getTraceToSource(final IStorage derivedResource) {
        StorageAwareTrace result = this.traceToSourceProvider.get();
        result.setLocalStorage(derivedResource);
        result.setTraceRegionProvider(new ITraceRegionProvider(){

            public AbstractTraceRegion getTraceRegion() {
                IStorage traceFile;
                IStorage resource = derivedResource;
                if (resource instanceof IFile && (traceFile = TraceForStorageProvider.this.getTraceFile(resource)) instanceof IFile && ((IFile)traceFile).exists()) {
                    InputStream contents = null;
                    try {
                        contents = traceFile.getContents();
                        AbstractTraceRegion abstractTraceRegion = TraceForStorageProvider.this.traceRegionSerializer.readTraceRegionFrom(contents);
                        return abstractTraceRegion;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                    finally {
                        try {
                            Closeables.close(contents, true);
                        }
                        catch (IOException iOException) {}
                    }
                }
                throw new TraceNotFoundException();
            }
        });
        return result;
    }

    public ITrace getTraceToTarget(IStorage sourceResource) {
        if (sourceResource instanceof IFile) {
            try {
                IFile sourceFile = (IFile)sourceResource;
                final List<IPath> traceFiles = this.traceMarkers.findTraceFiles(sourceFile);
                if (!traceFiles.isEmpty()) {
                    StorageAwareTrace result = this.traceToSourceProvider.get();
                    result.setLocalStorage(sourceResource);
                    final URI sourceFileURI = this.storage2UriMapper.getUri(sourceResource);
                    result.setTraceRegionProvider(new ITraceRegionProvider(){

                        public AbstractTraceRegion getTraceRegion() {
                            ArrayList<AbstractTraceRegion> result = Lists.newArrayList();
                            for (IPath tracePath : traceFiles) {
                                IFile traceFile = TraceForStorageProvider.this.workspace.getRoot().getFile(tracePath);
                                if (!traceFile.exists()) continue;
                                Object contents = null;
                                try {
                                    try {
                                        contents = traceFile.getContents();
                                        AbstractTraceRegion traceRegion = TraceForStorageProvider.this.traceRegionSerializer.readTraceRegionFrom((InputStream)contents);
                                        IStorage generatedFileForTraceFile = TraceForStorageProvider.this.getGeneratedFileForTraceFile(traceFile);
                                        if (generatedFileForTraceFile == null) {
                                            throw new TraceNotFoundException();
                                        }
                                        IPath generatedFilePath = generatedFileForTraceFile.getFullPath();
                                        URI generatedFileURI = URI.createPlatformResourceURI(generatedFilePath.toString(), true);
                                        URI sourceUriForTrace = TraceForStorageProvider.this.traceURIConverter.getURIForTrace(sourceFileURI);
                                        URI generatedUriForTrace = TraceForStorageProvider.this.traceURIConverter.getURIForTrace(generatedFileURI);
                                        if (sourceUriForTrace != null && generatedUriForTrace != null) {
                                            result.addAll(traceRegion.invertFor(sourceUriForTrace, generatedUriForTrace));
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error(e.getMessage(), e);
                                        try {
                                            Closeables.close((Closeable)contents, true);
                                        }
                                        catch (IOException iOException) {}
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        Closeables.close((Closeable)contents, true);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {
                                    Closeables.close((Closeable)contents, true);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (!result.isEmpty()) {
                                if (result.size() > 1) {
                                    ITextRegionWithLineInformation rootLocation = ITextRegionWithLineInformation.EMPTY_REGION;
                                    ITextRegionWithLineInformation associated = ITextRegionWithLineInformation.EMPTY_REGION;
                                    for (AbstractTraceRegion child : result) {
                                        rootLocation = rootLocation.merge(new TextRegionWithLineInformation(child.getMyOffset(), child.getMyLength(), child.getMyLineNumber(), child.getMyEndLineNumber()));
                                        ILocationData childAssociation = child.getMergedAssociatedLocation();
                                        if (childAssociation == null) continue;
                                        associated = associated.merge(childAssociation);
                                    }
                                    AbstractStatefulTraceRegion root = new AbstractStatefulTraceRegion(rootLocation, new ArrayList(), null){};
                                    Collections.sort(result, new Comparator<AbstractTraceRegion>(){

                                        @Override
                                        public int compare(AbstractTraceRegion o1, AbstractTraceRegion o2) {
                                            if (o1 == null || o2 == null) {
                                                throw new NullPointerException();
                                            }
                                            return o1.getMyOffset() - o2.getMyOffset();
                                        }
                                    });
                                    for (AbstractTraceRegion child : result) {
                                        child.setParent(root);
                                    }
                                    return root;
                                }
                                return (AbstractTraceRegion)result.get(0);
                            }
                            throw new TraceNotFoundException();
                        }
                    });
                    return result;
                }
            }
            catch (CoreException coreException) {
                log.info(coreException.getMessage(), coreException);
            }
        }
        return null;
    }

    public IStorage getTraceFile(IStorage storage) {
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            String originLastSegment = file.getFullPath().lastSegment();
            IFile traceFile = file.getParent().getFile(new Path(this.traceFileNameProvider.getTraceFromJava(originLastSegment)));
            return traceFile;
        }
        return null;
    }

    public boolean isTraceFile(IStorage storage) {
        if (!(storage instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)storage;
        String originLastSegment = file.getFullPath().lastSegment();
        return this.traceFileNameProvider.isTraceFileName(originLastSegment);
    }

    protected IStorage getGeneratedFileForTraceFile(IStorage traceFile) {
        if (traceFile instanceof IFile) {
            IFile file = (IFile)traceFile;
            String lastSegment = traceFile.getFullPath().lastSegment();
            lastSegment = this.traceFileNameProvider.getJavaFromTrace(lastSegment);
            return file.getParent().getFile(new Path(lastSegment));
        }
        return null;
    }
}

