/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.VetoStrategy;

public class NoChangesVetoStrategy
implements VetoStrategy {
    private final Log log = LogFactory.getLog(this.getClass());

    public boolean hasVeto(FileHandle handle) {
        return !this.hasChanges(handle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChanges(FileHandle h) {
        File f = new File(h.getAbsolutePath());
        if (!f.exists()) return true;
        try {
            FileInputStream oldIs = new FileInputStream(f);
            byte[] bytes = this.getBytes(h);
            try {
                byte[] lbuffer = new byte[bytes.length];
                ((InputStream)oldIs).read(lbuffer);
                if (((InputStream)oldIs).read() != -1) return true;
                int i = 0;
                while (true) {
                    if (i >= lbuffer.length) {
                        return false;
                    }
                    if (lbuffer[i] != bytes[i]) {
                        return true;
                    }
                    ++i;
                }
            }
            finally {
                ((InputStream)oldIs).close();
            }
        }
        catch (Exception e) {
            this.log.error("Couldn't compare content of file " + h.getAbsolutePath(), e);
            this.log.error("File " + h.getAbsolutePath() + " will not be overwritten");
            return false;
        }
    }

    public byte[] getBytes(FileHandle h) {
        if (h.getFileEncoding() != null) {
            try {
                return h.getBuffer().toString().getBytes(h.getFileEncoding());
            }
            catch (UnsupportedEncodingException e) {
                this.log.error(e.getMessage(), e);
            }
        }
        return h.getBuffer().toString().getBytes();
    }
}

