/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xpand2.codeassist.FastAnalyzer;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.codeassist.ProposalComputer;
import org.eclipse.internal.xtend.expression.codeassist.ProposalFactory;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandProposalComputer
implements ProposalComputer {
    private static final Pattern p = FastAnalyzer.EXPAND_PATTERN;

    @Override
    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        ArrayList<Object> result = new ArrayList<Object>();
        Matcher m = p.matcher(txt);
        if (m.find()) {
            XpandExecutionContext xpandCtx;
            List<XpandDefinition> allDefinitions;
            String prefix = m.group(1);
            if (ctx instanceof XpandExecutionContext && (allDefinitions = (xpandCtx = (XpandExecutionContext)ctx).getAllDefinitions()) != null) {
                for (XpandDefinition xpandDefinition : allDefinitions) {
                    String defineName = xpandDefinition.getName();
                    StringBuilder displayString = new StringBuilder(defineName);
                    DeclaredParameter[] params = xpandDefinition.getParams();
                    if (params.length > 0) {
                        displayString.append("(");
                        int i = 0;
                        while (i < params.length) {
                            if (i > 0) {
                                displayString.append(",");
                            }
                            displayString.append(params[i].getType());
                            ++i;
                        }
                        displayString.append(")");
                    }
                    displayString.append(" - ").append(xpandDefinition.getTargetType());
                    result.add(factory.createDefinitionProposal(defineName, displayString.toString(), prefix));
                }
            }
        }
        return result;
    }
}

