/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.launch.shortcut;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Launcher;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class Mwe2LaunchShortcut
implements ILaunchShortcut {
    public static final String BUNDLE_ID = "org.eclipse.emf.mwe2.launch";
    private IFile currFile;
    private final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            this.currFile = (IFile)((IAdaptable)object).getAdapter(IResource.class);
            this.launch(mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        this.currFile = (IFile)input.getAdapter(IFile.class);
        this.launch(mode);
    }

    private void launch(String mode) {
        try {
            this.locateWfRunner(this.currFile, mode);
        }
        catch (CoreException e) {
            MessageDialog.openError(null, "Problem running workflow.", e.getMessage());
            return;
        }
        LaunchConfigurationInfo info = new LaunchConfigurationInfo(this.currFile);
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = this.launchManager.getLaunchConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (info.configEquals(configuration)) {
                    config = configuration;
                    break;
                }
                ++n2;
            }
            if (config == null) {
                config = this.createConfiguration(info);
            }
            DebugUITools.launch(config, (String)mode);
            this.currFile.getProject().refreshLocal(2, new NullProgressMonitor());
        }
        catch (CoreException e) {
            MessageDialog.openError(null, "Problem running workflow.", e.getMessage());
            return;
        }
    }

    private void locateWfRunner(IResource resource, String mode) throws CoreException {
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (!this.isOnClasspath(Mwe2Launcher.class.getName(), project)) {
            throw new DebugException((IStatus)new Status(4, BUNDLE_ID, "Please put bundle 'org.eclipse.emf.mwe2.launch' on your project's classpath."));
        }
    }

    public boolean isOnClasspath(String fullyQualifiedName, IJavaProject project) {
        if (fullyQualifiedName.indexOf(36) != -1) {
            fullyQualifiedName = fullyQualifiedName.replace('$', '.');
        }
        try {
            IType type = project.findType(fullyQualifiedName);
            return type != null && type.exists();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected ILaunchConfiguration createConfiguration(LaunchConfigurationInfo info) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = this.launchManager.getLaunchConfigurationType("org.eclipse.emf.mwe2.launch.Mwe2LaunchConfigurationType");
        wc = configType.newInstance(null, this.launchManager.generateUniqueLaunchConfigurationNameFrom(info.name));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, info.project);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, Mwe2Launcher.class.getName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, info.wfFile);
        wc.setAttribute(RefreshTab.ATTR_REFRESH_SCOPE, "${workspace}");
        wc.setAttribute(RefreshTab.ATTR_REFRESH_RECURSIVE, true);
        config = wc.doSave();
        return config;
    }

    private class LaunchConfigurationInfo {
        private final String name;
        private final String project;
        private final String wfFile;

        private LaunchConfigurationInfo(IFile file) {
            this.name = file.getName();
            this.project = file.getProject().getName();
            this.wfFile = file.getProjectRelativePath().toString();
        }

        private boolean configEquals(ILaunchConfiguration a) throws CoreException {
            return this.wfFile.equals(a.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "X")) && Mwe2Launcher.class.getName().equals(a.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "X")) && this.project.equals(a.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "X")) && a.getType().getIdentifier().equals("org.eclipse.emf.mwe2.launch.Mwe2LaunchConfigurationType");
        }
    }

    public class TypeDeclarationSearchRequestor
    extends SearchRequestor {
        private IType match = null;

        public void acceptSearchMatch(SearchMatch match) {
            this.match = (IType)match.getElement();
        }

        public boolean match() {
            return this.match != null;
        }
    }
}

