/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.TangoConst;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Attrib
implements PogoDefs,
TangoConst {
    public String name;
    public int attrType;
    public TangoTypes dataType;
    public int rwType;
    public String assAttr;
    public int xSize;
    public int ySize;
    public DevStateTable notAllowedFor;
    public DispLevel disp_level = DispLevel.OPERATOR;
    public int polled_period = 0;
    public boolean memorized = false;
    public boolean memorized_init = true;
    public Property[] properties;
    private FireEvent change_evt;
    private FireEvent archive_evt;
    public static final int CHANGE = 0;
    public static final int ARCHIVE = 1;

    public Attrib(String name, String readcode) throws PogoException {
        this.name = name;
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
        PogoString code = new PogoString(readcode);
        this.buildPropertiesArray();
        int start = code.indexOf("class " + name + "Attr:");
        if (start < 0 && (start = code.indexOf("class " + name + "Attrib:")) < 0) {
            throw new PogoException("Attribute (" + name + ") class not defined in header file !");
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString class_def = new PogoString(code.substring(start, end));
        end = class_def.indexOf(") {}");
        start = class_def.lastIndexOf("(", end) + 1;
        PogoString constructor = new PogoString(class_def.substring(start, end));
        String[] params = constructor.getFields();
        end = start;
        String constr_signature = class_def.substring(start = class_def.lastIndexOf("public:", end) + "public:".length(), end).trim();
        this.attrType = constr_signature.indexOf(":ImageAttr") > 0 ? 2 : (constr_signature.indexOf(":SpectrumAttr") > 0 ? 1 : 0);
        int idx = 1;
        this.dataType = new TangoTypes(params[idx++]);
        this.rwType = 0;
        for (int i = 0; i < AttrRWtypeArray.length; ++i) {
            String target = "Tango::" + AttrRWtypeArray[i];
            if (!params[idx].equals(target)) continue;
            this.rwType = i;
        }
        ++idx;
        switch (this.attrType) {
            case 0: {
                if (this.rwType != 3) break;
                this.assAttr = params[idx];
                break;
            }
            case 1: {
                this.xSize = new Integer(params[idx]);
                break;
            }
            case 2: {
                this.xSize = new Integer(params[idx]);
                this.ySize = new Integer(params[++idx]);
            }
        }
        this.notAllowedFor = new DevStateTable();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, String assAttr) {
        this(name, attrType, dataType, 1, 1);
        this.rwType = rwType;
        this.assAttr = assAttr;
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, int xSize) {
        this(name, attrType, dataType, rwType, xSize, 1);
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, int xSize, int ySize) {
        this.name = name;
        this.attrType = attrType;
        this.dataType = new TangoTypes(dataType, "");
        this.rwType = rwType;
        this.xSize = xSize;
        this.ySize = ySize;
        this.assAttr = "";
        this.buildPropertiesArray();
        this.notAllowedFor = new DevStateTable();
        this.change_evt = new FireEvent();
        this.archive_evt = new FireEvent();
    }

    public void setDataType(String dataType) {
        this.dataType = new TangoTypes(dataType, "");
    }

    public void setDataType(String dataType, int lang) {
        this.dataType = new TangoTypes(dataType);
    }

    public boolean getWritable() {
        return this.rwType != 0 && this.rwType != 3;
    }

    public String cppMemberData() {
        String str = "";
        if (this.rwType != 1) {
            str = str + "\t\t" + this.dataType.cpp + "\t*attr_" + this.name + "_read;\n";
        }
        if (this.getWritable()) {
            str = str + "\t\t" + this.dataType.cpp + "\tattr_" + this.name + "_write;\n";
        }
        return str;
    }

    public String javaMemberData() {
        String str = "";
        if (this.rwType != 1) {
            str = str + "\tprotected " + this.dataType.java + "[]\tattr_" + this.name + "_read " + "= new " + this.dataType.java;
            switch (this.attrType) {
                case 0: {
                    str = str + "[1];\n";
                    break;
                }
                case 1: {
                    str = str + "[" + this.xSize + "];\n";
                    break;
                }
                case 2: {
                    str = str + "[" + this.xSize * this.ySize + "];\n";
                }
            }
        }
        if (this.attrType == 0 && this.rwType != 0 && this.rwType != 3) {
            str = str + "\tprotected " + this.dataType.java + "\tattr_" + this.name + "_write;\n";
        }
        return str;
    }

    public boolean propertiesAreSet() {
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i].value == null || this.properties[i].value.length() <= 0) continue;
            return true;
        }
        return this.memorized || this.polled_period > 0;
    }

    public String buildCodeForAttributeConstructor(int lang) {
        if (lang == 2) {
            String tab = "\t\t\t";
            String str = "\t\t'" + this.name + "':\n" + tab + "[[" + this.dataType.pyType() + ",\n" + tab + "PyTango." + AttrTypeArray[this.attrType] + ",\n" + tab + "PyTango." + AttrRWtypeArray[this.rwType];
            if (this.attrType == 1) {
                str = str + ", " + this.xSize;
            } else if (this.attrType == 2) {
                str = str + ", " + this.xSize + ", " + this.ySize;
            }
            str = str + "]";
            if (this.propertiesAreSet()) {
                str = str + ",\n" + tab + "{";
                for (int i = 0; i < this.properties.length; ++i) {
                    if (this.properties[i].value == null || this.properties[i].value.length() <= 0) continue;
                    str = str + "\n" + tab + "\t" + "'" + this.properties[i].name + "'" + ":" + this.properties[i].str_value() + ",";
                }
                if (this.memorized) {
                    str = this.memorized_init ? str + "\n" + tab + "\t" + "'Memorized':\"true\"," : str + "\n" + tab + "\t" + "'Memorized':\"" + "true_without_hard_applied" + "\",";
                }
                if (this.polled_period > 0) {
                    str = str + "\n" + tab + "\t" + "'Polling period':" + this.polled_period + ",";
                }
                if (this.disp_level == DispLevel.EXPERT) {
                    str = str + "\n" + tab + "\t" + "'Display level':PyTango.DispLevel.EXPERT,";
                }
                str = str + "\n" + tab + "} ";
            }
            str = str + "],\n";
            return str;
        }
        if (lang == 1) {
            return "\t" + this.name + "Attrib\t*" + this.getLowerName() + " = new " + this.name + "Attrib();\n";
        }
        String[] att_type = new String[]{"Attr", "SpectrumAttr", "ImageAttr"};
        String namespace = lang == 0 ? "" : "Tango::";
        String tab = lang == 0 ? "\t" : "";
        String pointer = lang == 0 ? "" : "*";
        String argtype = lang == 0 ? this.dataType.java_code_str : this.dataType.cpp_code_str;
        String str = "\t" + tab + namespace + att_type[this.attrType] + "\t" + pointer + this.getLowerName() + " = \n" + tab + "\t\t" + "new " + namespace + att_type[this.attrType] + "(" + "\"" + this.name + "\", " + argtype + ", ";
        switch (this.attrType) {
            case 0: {
                if (lang == 0) {
                    namespace = "AttrWriteType.";
                }
                str = str + namespace + AttrRWtypeArray[this.rwType];
                if (this.rwType != 3) break;
                str = str + ", \"" + this.assAttr + "\"";
                break;
            }
            case 1: {
                str = str + this.xSize;
                break;
            }
            case 2: {
                str = str + this.xSize + ", " + this.ySize;
            }
        }
        str = str + ");\n";
        return str;
    }

    public String buildCodeForDefaultProperties(int lang) {
        String namespace;
        String pointer;
        String tab = lang == 0 ? "\t" : "";
        boolean has_been_set = false;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i].value == null || this.properties[i].value.length() <= 0) continue;
            has_been_set = true;
        }
        String str = "";
        String string = pointer = lang == 0 ? "." : "->";
        if (has_been_set) {
            namespace = lang == 0 ? "" : "Tango::";
            str = str + tab + "\t" + namespace + "UserDefaultAttrProp\t" + this.getLowerName() + "_prop";
            if (lang == 0) {
                str = str + " = new UserDefaultAttrProp()";
            }
            str = str + ";\n";
            for (int i = 0; i < this.properties.length; ++i) {
                if (this.properties[i].value == null || this.properties[i].value.length() <= 0) continue;
                str = str + tab + "\t" + this.getLowerName() + "_prop." + this.properties[i].method + "(\"" + this.properties[i].value + "\");\n";
            }
            str = str + tab + "\t" + this.getLowerName() + pointer + "set_default_properties" + "(" + this.getLowerName() + "_prop);\n";
        }
        if (this.polled_period > 0) {
            str = str + tab + "\t" + this.getLowerName() + pointer + "set_polling_period(" + this.polled_period + ");\n";
        }
        if (this.disp_level == DispLevel.EXPERT) {
            namespace = lang == 0 ? "DispLevel." : "Tango::";
            str = str + tab + "\t" + this.getLowerName() + pointer + "set_disp_level(" + namespace + "EXPERT);\n";
        }
        if (lang == 1) {
            if (this.memorized) {
                str = str + tab + "\t" + this.getLowerName() + pointer + "set_memorized();\n" + tab + "\t" + this.getLowerName() + pointer + "set_memorized_init(" + this.memorized_init + ");\n";
            }
            if (this.change_evt.by_code) {
                str = str + tab + "\t" + this.getLowerName() + pointer + "set_change_event(" + this.change_evt.by_code + ", " + this.change_evt.whith_check + ");\n";
            }
            if (this.archive_evt.by_code) {
                str = str + tab + "\t" + this.getLowerName() + pointer + "set_archive_event(" + this.archive_evt.by_code + ", " + this.archive_evt.whith_check + ");\n";
            }
        }
        return str;
    }

    public void getDefaultProperties(PogoString pgs, int lang) {
        String[] params;
        String method;
        String prop_def = this.getLowerName() + "_prop.";
        String pattern = "//\tAttribute : ";
        int start = pgs.str.indexOf(pattern + this.name + "\n");
        if (start < 0) {
            return;
        }
        int end = pgs.str.indexOf(pattern, start + 1);
        PogoString block = end > 0 ? new PogoString(pgs.str.substring(start, end)) : new PogoString(pgs.str.substring(start));
        end = 0;
        while ((start = block.str.indexOf(prop_def, end)) > 0) {
            end = block.nextCr(start);
            int start1 = start + prop_def.length();
            int end1 = block.str.indexOf("(", start1);
            method = block.str.substring(start1, end1);
            start1 = block.str.indexOf("\"", end1) + 1;
            end1 = block.str.indexOf("\"", start1);
            String value = block.str.substring(start1, end1);
            for (int i = 0; i < this.properties.length; ++i) {
                if (!method.equals(this.properties[i].method)) continue;
                this.properties[i].value = value;
            }
        }
        String code = block.str;
        String pointer = lang == 0 ? "." : "->";
        method = this.getLowerName() + pointer + "set_polling_period(";
        start = code.indexOf(method);
        if (start > 0) {
            this.polled_period = Integer.parseInt(code.substring(start += method.length(), code.indexOf(")", start)));
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_disp_level(")) > 0) {
            String strlevel;
            this.disp_level = (strlevel = code.substring(start += method.length(), code.indexOf(")", start))).indexOf("EXPERT") > 0 ? DispLevel.EXPERT : DispLevel.OPERATOR;
        }
        if (code.indexOf(method = this.getLowerName() + pointer + "set_memorized();") > 0) {
            this.memorized = true;
            method = this.getLowerName() + pointer + "set_memorized_init(";
            start = code.indexOf(method);
            if (start > 0) {
                String param = code.substring(start + method.length());
                this.memorized_init = param.startsWith("true");
            } else {
                this.memorized_init = true;
            }
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_change_event(")) > 0) {
            params = new String[2];
            end = code.indexOf(",", start += method.length());
            params[0] = code.substring(start, end).trim().toLowerCase();
            start = end + 1;
            end = code.indexOf(");", start);
            params[1] = code.substring(start, end).trim().toLowerCase();
            this.setFireEvent(0, params[0].equals("true"), params[1].equals("true"));
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_archive_event(")) > 0) {
            params = new String[2];
            end = code.indexOf(",", start += method.length());
            params[0] = code.substring(start, end).trim().toLowerCase();
            start = end + 1;
            end = code.indexOf(");", start);
            params[1] = code.substring(start, end).trim().toLowerCase();
            this.setFireEvent(1, params[0].equals("true"), params[1].equals("true"));
        }
    }

    public String getPropValue(int i) {
        return this.properties[i].value;
    }

    public void setPropValue(int i, String val) {
        this.properties[i].value = val;
    }

    public String getDescription() {
        return this.properties[this.properties.length - 1].value;
    }

    public void setDescription(String desc) {
        this.properties[this.properties.length - 1].value = desc;
    }

    public String getDescriptionLine() {
        String desc = this.getDescription();
        if (desc == null) {
            return desc;
        }
        if (desc.length() == 0) {
            return desc;
        }
        PogoString line = new PogoString(desc);
        while (line.str.indexOf("\\n") >= 0) {
            line.replace("\\n", " ");
        }
        return line.str;
    }

    String buildCppClassesDefs(String template, String class_name) {
        String add_param;
        int start;
        String src;
        PogoString pgs = new PogoString(template);
        while (pgs.indexOf("ATTRIBUTE") > 0) {
            pgs.replace("ATTRIBUTE", this.name);
        }
        while (pgs.indexOf("CLASS") > 0) {
            pgs.replace("CLASS", class_name);
        }
        String inherite_class = src = ":Attr";
        if (this.attrType == 1) {
            inherite_class = ":SpectrumAttr";
        } else if (this.attrType == 2) {
            inherite_class = ":ImageAttr";
        }
        pgs.replace(src, inherite_class);
        pgs.replace(src, inherite_class);
        pgs.replace("DATA_TYPE", this.dataType.cpp_code_str);
        pgs.replace("RW_TYPE", "Tango::" + AttrRWtypeArray[this.rwType]);
        if (this.attrType == 0 && this.rwType == 3) {
            start = pgs.indexOf(") {}");
            add_param = ", \"" + this.assAttr + "\"";
            pgs.insert(start, add_param);
        }
        if (this.attrType == 1 || this.attrType == 2) {
            start = pgs.indexOf(") {}");
            add_param = ", " + this.xSize;
            pgs.insert(start, add_param);
        }
        if (this.attrType == 2) {
            start = pgs.indexOf(") {}");
            add_param = ", " + this.ySize;
            pgs.insert(start, add_param);
        }
        if (!this.getWritable()) {
            start = pgs.indexOf("\tvirtual void write");
            int end = pgs.indexOf("\tvirtual bool is_allowed");
            pgs.remove(pgs.substring(start, end));
        }
        return pgs.str;
    }

    String readSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExtract real attribute values for ATTRIBUTE acquisition result.\n */\n\tvirtual void CLASS::METHOD(Tango::Attribute &attr)", class_name, "read_" + this.name, false);
    }

    String writeSignatureMethod(String class_name) {
        return this.signature("/**\n *\tWrite ATTRIBUTE attribute values to hardware.\n */\n\tvirtual void CLASS::METHOD(Tango::WAttribute &attr)", class_name, "write_" + this.name, false);
    }

    String allowedSignatureMethod(String class_name) {
        return this.signature("/**\n *\tRead/Write allowed for ATTRIBUTE attribute.\n */\n\tvirtual bool CLASS::METHOD(Tango::AttReqType type)", class_name, "is_" + this.name + "_allowed", false);
    }

    String readFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExtract real attribute values for ATTRIBUTE acquisition result.\n */\n\tvirtual void CLASS::METHOD(Tango::Attribute &attr)", class_name, "read_" + this.name, true);
    }

    String writeFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tWrite ATTRIBUTE attribute values to hardware.\n */\n\tvirtual void CLASS::METHOD(Tango::WAttribute &attr)", class_name, "write_" + this.name, true);
    }

    String allowedFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tRead/Write allowed for ATTRIBUTE attribute.\n */\n\tvirtual bool CLASS::METHOD(Tango::AttReqType type)", class_name, "is_" + this.name + "_allowed", true);
    }

    private String signature(String template, String cl_name, String method, boolean full) {
        int start;
        String target;
        PogoString pgs = new PogoString(template);
        pgs.replace("ATTRIBUTE", this.name);
        pgs.replace("METHOD", method);
        if (cl_name == null) {
            pgs.replace("CLASS::", "");
        } else {
            pgs.replace("CLASS", cl_name);
            if (full) {
                target = " *\t";
                start = pgs.indexOf(target, "/**".length());
                int end = pgs.nextCr(start += target.length());
                String desc = pgs.substring(start, end);
                PogoString separator = new PogoString("//+----------------------------------------------------------------------------\n//\n// method : \t\tCLASS::METHOD\n// \n// description : \tDESCRIPTION\n//\n//-----------------------------------------------------------------------------\n");
                separator.replace("CLASS", cl_name);
                separator.replace("METHOD", method);
                separator.replace("DESCRIPTION", desc);
                target = " */\n\tvirtual ";
                end = pgs.indexOf(target);
                String comments = pgs.substring(0, end + target.length());
                pgs.replace(comments, separator.str);
            }
        }
        if (!full) {
            target = " */\n\tvirtual ";
            start = pgs.indexOf(target);
            return pgs.substring(start += target.length());
        }
        return pgs.str;
    }

    String getDevImpl2ReadAttr(PogoString code, String classname) {
        String pattern = "void " + classname + "::read_attr(Tango::Attribute &attr)";
        int start = code.str.indexOf(pattern);
        if (start < 0) {
            return "";
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        pattern = "if (attr_name == \"" + this.name + "\")";
        start = method.str.indexOf(pattern);
        if (start < 0) {
            return "";
        }
        start = method.inMethod(start);
        end = method.outMethod(start);
        start = method.nextCr(start);
        end = method.previousCr(end - 2);
        PogoString block = new PogoString(method.str.substring(start, end));
        block.indent(-1);
        return block.str;
    }

    String getDevImpl2WriteAttr(PogoString code, String classname) {
        String pattern = "void " + classname + "::write_attr_hardware(vector<long> &attr_list)";
        int start = code.str.indexOf(pattern);
        if (start < 0) {
            System.out.println(pattern + " Not found !");
            return "";
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        pattern = "if (attr_name == \"" + this.name + "\")";
        start = method.str.indexOf(pattern);
        if (start < 0) {
            System.out.println(pattern + " Not found !");
            return "";
        }
        start = method.inMethod(start);
        end = method.outMethod(start);
        start = method.nextCr(start);
        end = method.previousCr(end - 2);
        PogoString block = new PogoString(method.str.substring(start, end));
        block.indent(-2);
        while (block.str.indexOf("att.") > 0) {
            block.replace("att.", "attr.");
        }
        return block.str;
    }

    void setPyProperties(String code) throws PogoException {
        int end;
        for (int i = 0; i < this.properties.length; ++i) {
            String prop_name = "'" + this.properties[i].name + "'";
            int idx = code.indexOf(prop_name);
            if (idx <= 0) continue;
            int end2 = idx = code.indexOf(":", idx) + 1;
            if (code.substring(idx).startsWith("\"")) {
                end2 = code.indexOf("\"", idx + 1);
            }
            if ((end2 = code.indexOf(",", end2)) < 0) {
                end2 = code.indexOf("}", idx);
            }
            if (end2 < 0) {
                throw new PogoException("Syntax Error in attr_list (property " + prop_name + ")");
            }
            String strval = code.substring(idx, end2).trim();
            while ((idx = strval.indexOf("\"")) >= 0) {
                String first = strval.substring(0, idx);
                String second = "";
                if (idx < strval.length() - 2) {
                    second = strval.substring(idx + 1);
                }
                strval = first + second;
            }
            this.properties[i].value = strval;
        }
        String target = "polling period";
        int idx = code.toLowerCase().indexOf(target);
        if (idx > 0) {
            end = code.indexOf(",", idx = code.indexOf(":", idx) + 1);
            if (end < 0) {
                end = code.indexOf("}", idx);
            }
            if (end < 0) {
                throw new PogoException("Syntax Error in attr_list (" + target + ")");
            }
            String strval = code.substring(idx, end).trim();
            try {
                this.polled_period = Integer.parseInt(strval);
            }
            catch (NumberFormatException e) {
                throw new PogoException("Syntax Error in attr_list (" + target + " = " + strval + ")");
            }
        }
        target = "memorized";
        idx = code.toLowerCase().indexOf(target);
        if (idx > 0) {
            end = code.indexOf(",", idx = code.indexOf(":", idx) + 1);
            if (end < 0) {
                end = code.indexOf("}", idx);
            }
            if (end < 0) {
                throw new PogoException("Syntax Error in attr_list (" + target + ")");
            }
            String strval = code.substring(idx, end).toLowerCase().trim();
            this.memorized = (strval = strval.substring(1, strval.length() - 1)).startsWith("true");
            if (this.memorized) {
                this.memorized_init = !strval.equals("true_without_hard_applied");
            }
        }
        target = "display level";
        idx = code.toLowerCase().indexOf(target);
        if (idx > 0) {
            end = code.indexOf(",", idx = code.indexOf(":", idx) + 1);
            if (end < 0) {
                end = code.indexOf("}", idx);
            }
            if (end < 0) {
                throw new PogoException("Syntax Error in attr_list (" + target + ")");
            }
            String strval = code.substring(idx, end).trim();
            this.disp_level = strval.equals("PyTango.DispLevel.EXPERT") ? DispLevel.EXPERT : DispLevel.OPERATOR;
        }
    }

    public boolean[] getFireEvent(int type) {
        FireEvent evt = type == 0 ? this.change_evt : this.archive_evt;
        return new boolean[]{evt.by_code, evt.whith_check};
    }

    public void setFireEvent(int type, boolean code, boolean checked) {
        FireEvent evt;
        FireEvent fireEvent = evt = type == 0 ? this.change_evt : this.archive_evt;
        if (evt == null) {
            evt = new FireEvent();
        }
        evt.by_code = code;
        evt.whith_check = code ? checked : false;
    }

    private void buildPropertiesArray() {
        int i = 0;
        this.properties = new Property[14];
        this.properties[i++] = new Property("label", true);
        this.properties[i++] = new Property("unit", true);
        this.properties[i++] = new Property("standard unit", false);
        this.properties[i++] = new Property("display unit", true);
        this.properties[i++] = new Property("format", true);
        this.properties[i++] = new Property("max value", false);
        this.properties[i++] = new Property("min value", false);
        this.properties[i++] = new Property("max alarm", false);
        this.properties[i++] = new Property("min alarm", false);
        this.properties[i++] = new Property("max warning", false);
        this.properties[i++] = new Property("min warning", false);
        this.properties[i++] = new Property("delta time", false);
        this.properties[i++] = new Property("delta val", false);
        this.properties[i] = new Property("description", true);
    }

    String pyUpdateAllowedStates(String method, String signature) {
        return this.notAllowedFor.pyUpdateAllowedStateMethod(method, signature);
    }

    String buildPyStateMachineMethod(String template) {
        PogoString code = new PogoString(template);
        String target = "TemplAttr";
        while (code.indexOf(target) > 0) {
            code.replace(target, this.name);
        }
        return code.str;
    }

    String buildPyWriteMethod(String template) {
        PogoString code = new PogoString(template);
        String target = "TemplAttr";
        while (code.indexOf(target) > 0) {
            code.replace(target, this.name);
        }
        return code.str;
    }

    String buildPyReadMethod(String template) {
        PogoString code = new PogoString(template);
        String target = "TemplAttr";
        while (code.indexOf(target) > 0) {
            code.replace(target, this.name);
        }
        target = "attr.set_value(";
        int ins_init = code.indexOf(target);
        int ins_size = ins_init + target.length();
        String strval = code.substring(ins_size, code.indexOf(")", ins_size));
        ins_size += strval.length();
        ins_init = code.lastIndexOf("\n", ins_init) + 1;
        String str_init = "\t\t" + strval + " = ";
        String str_size = "";
        block0 : switch (this.attrType) {
            case 0: {
                switch (this.dataType.code) {
                    case 4: 
                    case 5: {
                        str_init = str_init + "1.0";
                        break block0;
                    }
                    case 8: {
                        str_init = str_init + "\"Hello Tango world\"";
                        break block0;
                    }
                }
                str_init = str_init + "1";
                break;
            }
            case 1: {
                str_size = ", 1";
                switch (this.dataType.code) {
                    case 4: 
                    case 5: {
                        str_init = str_init + "[1.0]";
                        break block0;
                    }
                    case 8: {
                        str_init = str_init + "[\"Hello Tango world\"]";
                        break block0;
                    }
                }
                str_init = str_init + "[1]";
                break;
            }
            case 2: {
                str_size = ", 1, 1";
                switch (this.dataType.code) {
                    case 4: 
                    case 5: {
                        str_init = str_init + "[1.1][2.2]";
                        break block0;
                    }
                    case 8: {
                        str_init = str_init + "[\"Hello\"] [\"Tango world\"]";
                        break block0;
                    }
                }
                str_init = str_init + "[1][2]";
            }
        }
        str_init = str_init + "\n";
        code.insert(ins_size, str_size);
        code.insert(ins_init, str_init);
        return code.str;
    }

    String allowedCore() {
        return this.notAllowedFor.allowedCore();
    }

    public void setMemorized(boolean val) {
        this.memorized = val;
    }

    public boolean getMemorized() {
        return this.memorized;
    }

    public void setMemorizedInit(boolean val) {
        this.memorized_init = val;
    }

    public boolean getMemorizedInit() {
        return this.memorized_init;
    }

    public String getLowerName() {
        PogoString pgs = new PogoString(this.name);
        return pgs.toLowerString();
    }

    public String toString() {
        return this.name;
    }

    class FireEvent {
        boolean by_code = false;
        boolean whith_check = false;

        FireEvent() {
        }
    }

    class Property {
        String name;
        String method;
        boolean is_str;
        String value;
        static final String set_def_prop_method = "set_default_properties";

        public Property(String name, boolean is_str) {
            this.name = name;
            this.is_str = is_str;
            this.value = "";
            this.method = "set_" + name;
            int idx = this.method.indexOf(32);
            if (idx > 0) {
                this.method = this.method.substring(0, idx) + "_" + this.method.substring(idx + 1);
            }
            if (this.method.equals("set_delta_time")) {
                this.method = "set_delta_t";
            }
        }

        public String toString() {
            return this.name;
        }

        public String str_value() {
            if (this.is_str) {
                return "\"" + this.value + "\"";
            }
            return this.value;
        }
    }
}

