/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.OverlodedPollPeriodObject;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.tango.pogo.pogo_gui.AttributeDialog;
import org.tango.pogo.pogo_gui.ClassDialog;
import org.tango.pogo.pogo_gui.CommandDialog;
import org.tango.pogo.pogo_gui.DeletedObjects;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.ForwardedAttributeDialog;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.PipeDialog;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.RenamedObjects;
import org.tango.pogo.pogo_gui.StateDialog;
import org.tango.pogo.pogo_gui.StateMachineDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoEditor;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ClassTree
extends JTree
implements TangoConst,
PogoConst {
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private ClassTreePopupMenu menu;
    private PogoGUI parent;
    private static final Color background = Color.white;
    private static final Color dynamicBG = new Color(0xDDFFFF);
    private PogoDeviceClass pogo_class;
    private DeviceClass deviceClass;
    private DeletedObjects deleted_objects = new DeletedObjects();
    private RenamedObjects renamed_objects = new RenamedObjects();
    private InheritanceUtils inherit_utils;
    private boolean modified = false;
    private boolean isInheritedClass;
    private static Object copiedItem = null;
    private static final int EDIT_CLASS = 0;
    private static final int ADD_ITEM = 1;
    private static final int ADD_DYN_ITEM = 2;
    private static final int ADD_FW_ATTR = 3;
    private static final int PASTE_ITEM = 4;
    private static final int SORT_ITEM = 5;
    private static final int SUMMARIZE = 6;
    private static final int EDIT_ITEM = 7;
    private static final int COPY_ITEM = 8;
    private static final int CLONE_ITEM = 9;
    private static final int REMOVE_ITEM = 10;
    private static final int EDIT_SRC_CODE = 11;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Edit Class", "Add Item", "Add Dynamic Item", "Add Forwarded Attribute", "Paste", "Sort Item", "Summarize", "Edit Item", "Copy", "Clone  Item", "Remove Item", "Edit Source Code"};

    public ClassTree(PogoGUI pogoGUI, DeviceClass deviceClass, boolean bl) {
        this.parent = pogoGUI;
        this.deviceClass = deviceClass;
        this.isInheritedClass = bl;
        this.pogo_class = deviceClass.getPogoDeviceClass();
        this.inherit_utils = InheritanceUtils.getInstance();
        this.buildTree();
        this.setBackground(background);
        this.menu = new ClassTreePopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
        ClassIdentification classIdentification = deviceClass.getPogoDeviceClass().getDescription().getIdentification();
        if (!(classIdentification != null && Utils.isSet(classIdentification.getAuthor()) && Utils.isSet(classIdentification.getContact()) && Utils.isSet(classIdentification.getPlatform()))) {
            Utils.getInstance().stopSplashRefresher();
            this.editClass();
        }
        pogoGUI.setLanguageLogo(this.pogo_class.getDescription().getLanguage());
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(new PogoRoot(this.pogo_class));
        this.createCollectionClassNodes(this.pogo_class);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer tangoRenderer = new TangoRenderer();
        this.setCellRenderer(tangoRenderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ClassTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                ClassTree.this.collapsedPerformed(treeExpansionEvent);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
    }

    public void collapsedPerformed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        int n = treePath.getPathCount() - 1;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSelectedNode();
        if (defaultMutableTreeNode2 == null || defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode != defaultMutableTreeNode2) {
            return;
        }
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
            Object[] objectArray = defaultMutableTreeNode3.getPath();
            this.setExpandedState(new TreePath(objectArray), true);
        }
    }

    public void expandedPerfomed(TreeExpansionEvent treeExpansionEvent) {
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            this.setSelectionPath(null);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2 && (n & 0x10) != 0) {
            if (!(object instanceof PogoCollection)) {
                this.editItem();
            } else if (defaultMutableTreeNode != this.root) {
                this.addItem(defaultMutableTreeNode, false);
            }
        } else if ((n & 4) != 0) {
            if (defaultMutableTreeNode == this.root) {
                this.menu.showMenu(mouseEvent, (PogoRoot)defaultMutableTreeNode.getUserObject());
            } else if (object instanceof PogoCollection) {
                this.menu.showMenu(mouseEvent, (PogoCollection)object);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                this.menu.showMenu(mouseEvent, object, defaultMutableTreeNode2.toString());
            }
        }
    }

    private void createCollectionClassNodes(PogoDeviceClass pogoDeviceClass) {
        Object object;
        EList<Property> eList = pogoDeviceClass.getClassProperties();
        this.root.add(this.createPropertyBranch(eList, "Class"));
        EList<Property> eList2 = pogoDeviceClass.getDeviceProperties();
        this.root.add(this.createPropertyBranch(eList2, "Device"));
        EList<Command> eList3 = pogoDeviceClass.getCommands();
        EList<Command> eList4 = pogoDeviceClass.getDynamicCommands();
        if (eList3.size() == 0) {
            object = OAWutils.createStateStatusCommand();
            eList3.add(object[0]);
            eList3.add(object[1]);
        }
        this.root.add(this.createCommandBranch(eList3, eList4));
        object = pogoDeviceClass.getAttributes();
        EList<Attribute> eList5 = pogoDeviceClass.getDynamicAttributes();
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = this.createAttributeBranch((EList<Attribute>)object, eList5);
        this.root.add(defaultMutableTreeNodeArray[0]);
        this.root.add(defaultMutableTreeNodeArray[1]);
        this.root.add(defaultMutableTreeNodeArray[2]);
        EList<ForwardedAttribute> eList6 = pogoDeviceClass.getForwardedAttributes();
        this.root.add(this.createForwardedBranch(eList6));
        EList<Pipe> eList7 = pogoDeviceClass.getPipes();
        this.root.add(this.createPipeBranch(eList7));
        EList<State> eList8 = pogoDeviceClass.getStates();
        this.root.add(this.createStateBranch(eList8));
    }

    private DefaultMutableTreeNode createPropertyBranch(EList<Property> eList, String string) {
        Utils utils = Utils.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCollection(string + " Properties", utils.classPropertyIcon));
        for (Property property : eList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoProperty(property, string.equals("Device")));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createCommandBranch(EList<Command> eList, EList<Command> eList2) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Utils utils = Utils.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoCollection("Commands", utils.cmdIcon));
        for (Command command : eList) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCommand(command));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        for (Command command : eList2) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCommand(command));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode[] createAttributeBranch(EList<Attribute> eList, EList<Attribute> eList2) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        PogoAttribute pogoAttribute;
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[3];
        Utils utils = Utils.getInstance();
        defaultMutableTreeNodeArray[0] = new DefaultMutableTreeNode(new PogoCollection("Scalar Attributes", utils.scalarIcon));
        defaultMutableTreeNodeArray[1] = new DefaultMutableTreeNode(new PogoCollection("Spectrum Attributes", utils.spectrumIcon));
        defaultMutableTreeNodeArray[2] = new DefaultMutableTreeNode(new PogoCollection("Image Attributes", utils.imageIcon));
        for (Attribute attribute : eList) {
            pogoAttribute = new PogoAttribute(attribute);
            defaultMutableTreeNode = new DefaultMutableTreeNode(pogoAttribute);
            switch (pogoAttribute.attType) {
                case 3: {
                    defaultMutableTreeNodeArray[0].add(defaultMutableTreeNode);
                    break;
                }
                case 4: {
                    defaultMutableTreeNodeArray[1].add(defaultMutableTreeNode);
                    break;
                }
                case 5: {
                    defaultMutableTreeNodeArray[2].add(defaultMutableTreeNode);
                }
            }
        }
        for (Attribute attribute : eList2) {
            pogoAttribute = new PogoAttribute(attribute);
            defaultMutableTreeNode = new DefaultMutableTreeNode(pogoAttribute);
            switch (pogoAttribute.attType) {
                case 3: {
                    defaultMutableTreeNodeArray[0].add(defaultMutableTreeNode);
                    break;
                }
                case 4: {
                    defaultMutableTreeNodeArray[1].add(defaultMutableTreeNode);
                    break;
                }
                case 5: {
                    defaultMutableTreeNodeArray[2].add(defaultMutableTreeNode);
                }
            }
        }
        return defaultMutableTreeNodeArray;
    }

    private DefaultMutableTreeNode createStateBranch(EList<State> eList) {
        Utils utils = Utils.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCollection("States", utils.stateIcon));
        for (State state : eList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoState(state));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createForwardedBranch(EList<ForwardedAttribute> eList) {
        Utils utils = Utils.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCollection("Forwarded Attributes", utils.forwardedIcon));
        for (ForwardedAttribute forwardedAttribute : eList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoForwarded(forwardedAttribute));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createPipeBranch(EList<Pipe> eList) {
        Utils utils = Utils.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCollection("Pipes", utils.pipeIcon));
        for (Pipe pipe : eList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoPipe(pipe));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    Object getSelectedEditableObject() {
        Object object = this.getSelectedObject();
        if (object instanceof PogoProperty) {
            return ((PogoProperty)object).value;
        }
        if (object instanceof PogoCommand) {
            Command command = ((PogoCommand)object).value;
            if (command.getName().equals("State") || command.getName().equals("Status")) {
                return null;
            }
            return command;
        }
        if (object instanceof PogoAttribute) {
            return ((PogoAttribute)object).value;
        }
        if (object instanceof PogoForwarded) {
            return ((PogoForwarded)object).value;
        }
        if (object instanceof PogoPipe) {
            return ((PogoPipe)object).value;
        }
        if (object instanceof PogoState) {
            return ((PogoState)object).value;
        }
        return null;
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            arrayList.add(0, defaultMutableTreeNode);
        }
        Object[] objectArray = new DefaultMutableTreeNode[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = (TreeNode)arrayList.get(i);
        }
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private boolean getRemoveConfirmation(Object object) {
        String string = "\"---\"  --";
        if (object instanceof PogoProperty) {
            string = "\"Property\"  " + ((PogoProperty)object).value.getName();
        } else if (object instanceof PogoCommand) {
            string = "\"Command\"  " + ((PogoCommand)object).value.getName();
        } else if (object instanceof PogoAttribute) {
            string = "\"Attribute\"  " + ((PogoAttribute)object).value.getName();
        } else if (object instanceof PogoForwarded) {
            string = "\"Forwarded Attribute\"  " + ((PogoForwarded)object).value.getName();
        } else if (object instanceof PogoPipe) {
            string = "\"Pipe\"  " + ((PogoPipe)object).value.getName();
        } else if (object instanceof PogoState) {
            string = "\"State\"  " + ((PogoState)object).value.getName();
        }
        return JOptionPane.showConfirmDialog(this, "Remove  " + string + " ?", "Confirmation Window", 0) == 0;
    }

    public void setSrcPath(String string) {
        PogoRoot pogoRoot = (PogoRoot)this.root.getUserObject();
        pogoRoot.path = string;
    }

    private void editSourceCode() {
        Object object = this.getSelectedObject();
        if (object == null) {
            return;
        }
        try {
            PogoRoot pogoRoot = (PogoRoot)this.root.getUserObject();
            String[] stringArray = new String[]{pogoRoot.name, pogoRoot.path, pogoRoot.language};
            if (pogoRoot.path == null) {
                throw new PogoException("Source files not generated !");
            }
            if (object instanceof PogoProperty) {
                Property property = ((PogoProperty)object).value;
                boolean bl = ((PogoProperty)object).is_dev;
                PogoEditor.getInstance().editFile(stringArray, property, bl);
            } else if (object instanceof PogoCommand) {
                Command command = ((PogoCommand)object).value;
                PogoEditor.getInstance().editFile(stringArray, command);
            } else if (object instanceof PogoAttribute) {
                Attribute attribute = ((PogoAttribute)object).value;
                PogoEditor.getInstance().editFile(stringArray, attribute);
            } else if (object instanceof PogoPipe) {
                Pipe pipe = ((PogoPipe)object).value;
                PogoEditor.getInstance().editFile(stringArray, pipe);
            } else if (object instanceof PogoState) {
                State state = ((PogoState)object).value;
                PogoEditor.getInstance().editFile(stringArray, state);
            }
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
        }
    }

    void removeSelectedItem() {
        this.removeSelectedItem(true, true);
    }

    void removeSelectedItem(boolean bl, boolean bl2) {
        Object object = this.getSelectedObject();
        if (object == null) {
            return;
        }
        if (!bl || this.getRemoveConfirmation(object)) {
            Object object2;
            if (object instanceof PogoProperty) {
                object2 = ((PogoProperty)object).value;
                if (!InheritanceUtils.isRemovable((JFrame)this.parent, (Property)object2)) {
                    return;
                }
                EList<Property> eList = ((PogoProperty)object).is_dev ? this.pogo_class.getDeviceProperties() : this.pogo_class.getClassProperties();
                int n = Utils.getPropertyIndex(eList, (Property)object2);
                if (n >= 0) {
                    eList.remove(n);
                }
            } else if (object instanceof PogoCommand) {
                object2 = ((PogoCommand)object).value;
                if (!InheritanceUtils.isRemovable((JFrame)this.parent, (Command)object2)) {
                    return;
                }
                EList<Command> eList = this.pogo_class.getCommands();
                int n = Utils.getCommandIndex(eList, (Command)object2);
                if (n >= 0) {
                    eList.remove(n);
                }
                this.deleted_objects.add(object2);
            } else if (object instanceof PogoAttribute) {
                object2 = ((PogoAttribute)object).value;
                if (!InheritanceUtils.isRemovable((JFrame)this.parent, (Attribute)object2)) {
                    return;
                }
                EList<Attribute> eList = this.pogo_class.getAttributes();
                int n = Utils.getAttributeIndex(eList, (Attribute)object2);
                if (n >= 0) {
                    eList.remove(n);
                }
                this.deleted_objects.add(object2);
            } else if (object instanceof PogoForwarded) {
                object2 = ((PogoForwarded)object).value;
                EList<ForwardedAttribute> eList = this.pogo_class.getForwardedAttributes();
                int n = Utils.getForwardedAttributeIndex(eList, (ForwardedAttribute)object2);
                if (n >= 0) {
                    eList.remove(n);
                }
            } else if (object instanceof PogoPipe) {
                object2 = ((PogoPipe)object).value;
                EList<Pipe> eList = this.pogo_class.getPipes();
                int n = Utils.getPipeIndex(eList, (Pipe)object2);
                if (n >= 0) {
                    eList.remove(n);
                }
                this.deleted_objects.add(object2);
            } else if (object instanceof PogoState) {
                object2 = ((PogoState)object).value;
                EList<State> eList = this.pogo_class.getStates();
                int n = Utils.getStateIndex(eList, (State)object2);
                if (n >= 0) {
                    eList.remove(n);
                }
            }
            object2 = this.getSelectedNode();
            this.treeModel.removeNodeFromParent((MutableTreeNode)object2);
            if (bl2) {
                this.setModified(true);
            }
        }
        ((PogoRoot)this.root.getUserObject()).isAbstract = this.checkIfAbstractClass();
        this.repaint();
    }

    void moveSelectedItem(boolean bl) {
        int n;
        Object object = this.getSelectedObject();
        if (object == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n2 = 0;
        for (n = 0; n < defaultMutableTreeNode2.getChildCount(); ++n) {
            if (!defaultMutableTreeNode2.getChildAt(n).equals(defaultMutableTreeNode)) continue;
            n2 = n;
        }
        n = 0;
        int n3 = defaultMutableTreeNode2.getChildCount() - 1;
        if (object instanceof PogoCommand) {
            n = 2;
        }
        if (bl) {
            if (n2 > n) {
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2 - 1);
            }
        } else if (n2 < n3) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2 + 1);
        }
        this.setSelectionNode(defaultMutableTreeNode);
        this.modified = true;
    }

    private void sortItems() {
        int n;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
            arrayList.add((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n));
        }
        Collections.sort(arrayList, new NodeComparator());
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.treeModel.insertNodeInto((MutableTreeNode)arrayList.get(n), defaultMutableTreeNode, n);
        }
        this.expandChildren(defaultMutableTreeNode);
    }

    private void setSelectionNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object[] objectArray = defaultMutableTreeNode.getPath();
        this.setSelectionPath(new TreePath(objectArray));
    }

    private void editClass() {
        ClassDialog classDialog = new ClassDialog(this.parent, this, this.deviceClass, this.isInheritedClass);
        if (classDialog.showDialog() == 0) {
            this.deviceClass = classDialog.getInputs();
            this.root.setUserObject(new PogoRoot(this.deviceClass.getPogoDeviceClass()));
            if (!classDialog.hasForcedToGenerate()) {
                this.parent.setLanguageLogo(this.deviceClass.getPogoDeviceClass().getDescription().getLanguage());
                this.setModified(true);
            }
            this.repaint();
        }
    }

    public void setClassLanguage(int n) {
        ((PogoRoot)this.root.getUserObject()).language = PogoConst.strLang[n];
        this.deviceClass.getPogoDeviceClass().getDescription().setLanguage(PogoConst.strLang[n]);
    }

    private void copyItem() {
        copiedItem = this.getSelectedObject();
    }

    private void pasteItem() {
        if (copiedItem == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSelectedNode();
        try {
            if (copiedItem instanceof PogoProperty) {
                String string;
                boolean bl = defaultMutableTreeNode2 == this.root.getChildAt(1);
                String string2 = string = bl ? "Device " : "Class ";
                if (this.propertyAlreadyExists(copiedItem.toString(), bl)) {
                    throw new PogoException(string + "Property " + copiedItem + " already exists");
                }
                PogoProperty pogoProperty = (PogoProperty)copiedItem;
                Property property = PropertyDialog.cloneProperty(pogoProperty.value);
                defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoProperty(property, bl));
            } else if (copiedItem instanceof PogoCommand) {
                if (this.itemAlreadyExists(copiedItem.toString(), 2)) {
                    throw new PogoException("Command " + copiedItem + " already exists");
                }
                PogoCommand pogoCommand = (PogoCommand)copiedItem;
                Command command = CommandDialog.cloneCommand(pogoCommand.value);
                defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCommand(command));
            } else if (copiedItem instanceof PogoAttribute) {
                if (this.itemAlreadyExists(copiedItem.toString(), 3)) {
                    throw new PogoException("Attribute " + copiedItem + " already exists");
                }
                PogoAttribute pogoAttribute = (PogoAttribute)copiedItem;
                Attribute attribute = AttributeDialog.cloneAttribute(pogoAttribute.value);
                defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoAttribute(attribute));
                defaultMutableTreeNode2 = pogoAttribute.attType == 3 ? (DefaultMutableTreeNode)this.root.getChildAt(3) : (pogoAttribute.attType == 4 ? (DefaultMutableTreeNode)this.root.getChildAt(4) : (DefaultMutableTreeNode)this.root.getChildAt(5));
            } else if (copiedItem instanceof PogoPipe) {
                if (this.itemAlreadyExists(copiedItem.toString(), 7)) {
                    throw new PogoException("Pipe " + copiedItem + " already exists");
                }
                PogoPipe pogoPipe = (PogoPipe)copiedItem;
                Pipe pipe = OAWutils.clonePipe(pogoPipe.value);
                defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoPipe(pipe));
            } else if (copiedItem instanceof PogoState) {
                if (this.itemAlreadyExists(copiedItem.toString(), 8)) {
                    throw new PogoException("State " + copiedItem + " already exists");
                }
                PogoState pogoState = (PogoState)copiedItem;
                State state = StateDialog.cloneState(pogoState.value);
                defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoState(state));
            }
            if (defaultMutableTreeNode != null) {
                this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                this.setSelectionNode(defaultMutableTreeNode);
                this.setModified(true);
                this.editItem();
            }
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
        }
    }

    private boolean canPaste() {
        if (copiedItem == null) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (copiedItem instanceof PogoProperty) {
            if (defaultMutableTreeNode == this.root.getChildAt(1)) {
                return true;
            }
            if (defaultMutableTreeNode == this.root.getChildAt(0)) {
                return true;
            }
        } else if (copiedItem instanceof PogoCommand) {
            if (defaultMutableTreeNode == this.root.getChildAt(2)) {
                return true;
            }
        } else if (copiedItem instanceof PogoAttribute) {
            if (defaultMutableTreeNode == this.root.getChildAt(3)) {
                return true;
            }
            if (defaultMutableTreeNode == this.root.getChildAt(4)) {
                return true;
            }
            if (defaultMutableTreeNode == this.root.getChildAt(5)) {
                return true;
            }
        } else if (copiedItem instanceof PogoPipe ? defaultMutableTreeNode == this.root.getChildAt(7) : copiedItem instanceof PogoState && defaultMutableTreeNode == this.root.getChildAt(8)) {
            return true;
        }
        return false;
    }

    private void cloneItem() {
        EObject eObject;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getSelectedNode().getParent();
        Object object = this.getSelectedObject();
        if (object instanceof PogoProperty) {
            eObject = ((PogoProperty)object).value;
            Property property = PropertyDialog.cloneProperty(eObject);
            boolean bl = ((PogoProperty)object).is_dev;
            if (bl) {
                this.pogo_class.getDeviceProperties().add(property);
            } else {
                this.pogo_class.getClassProperties().add(property);
            }
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoProperty(property, bl));
        } else if (object instanceof PogoCommand) {
            eObject = ((PogoCommand)object).value;
            Command command = CommandDialog.cloneCommand((Command)eObject);
            this.pogo_class.getCommands().add(command);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoCommand(command));
        } else if (object instanceof PogoAttribute) {
            eObject = ((PogoAttribute)object).value;
            Attribute attribute = AttributeDialog.cloneAttribute((Attribute)eObject);
            this.pogo_class.getAttributes().add(attribute);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoAttribute(attribute));
        } else if (object instanceof PogoPipe) {
            eObject = ((PogoPipe)object).value;
            Pipe pipe = OAWutils.clonePipe((Pipe)eObject);
            this.pogo_class.getPipes().add(pipe);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoPipe(pipe));
        } else if (object instanceof PogoState) {
            eObject = ((PogoState)object).value;
            State state = StateDialog.cloneState((State)eObject);
            this.pogo_class.getStates().add(state);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new PogoState(state));
        }
        if (defaultMutableTreeNode != null) {
            boolean bl;
            this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            this.setSelectionNode(defaultMutableTreeNode);
            boolean bl2 = bl = this.editItem() == 0;
            if (bl) {
                this.setModified(true);
            } else {
                this.removeSelectedItem(false, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int editItem() {
        Object object = this.getSelectedObject();
        if (object instanceof PogoRoot) {
            this.editClass();
        } else if (object instanceof PogoState) {
            State state = ((PogoState)object).value;
            StateDialog stateDialog = new StateDialog(this.parent, state);
            if (stateDialog.showDialog() != 0) return 2;
            EList<State> eList = this.pogo_class.getStates();
            int n = Utils.getStateIndex(eList, state);
            state = stateDialog.getState();
            if (n >= 0) {
                eList.remove(n);
                eList.add(n, state);
            } else {
                eList.add(state);
            }
            this.getSelectedNode().setUserObject(new PogoState(state));
            this.setModified(true);
            this.setSelectionPath(null);
        } else if (object instanceof PogoForwarded) {
            ForwardedAttribute forwardedAttribute = ((PogoForwarded)object).value;
            ForwardedAttributeDialog forwardedAttributeDialog = new ForwardedAttributeDialog(this.parent, forwardedAttribute);
            if (forwardedAttributeDialog.showDialog() != 0) return 2;
            EList<ForwardedAttribute> eList = this.pogo_class.getForwardedAttributes();
            int n = Utils.getForwardedAttributeIndex(eList, forwardedAttribute);
            forwardedAttribute = forwardedAttributeDialog.getForwardedAttribute();
            if (n >= 0) {
                eList.remove(n);
                eList.add(n, forwardedAttribute);
            } else {
                eList.add(forwardedAttribute);
            }
            this.getSelectedNode().setUserObject(new PogoForwarded(forwardedAttribute));
            this.setModified(true);
        } else if (object instanceof PogoProperty) {
            Property property = ((PogoProperty)object).value;
            boolean bl = ((PogoProperty)object).is_dev;
            PropertyDialog propertyDialog = new PropertyDialog(this.parent, property, bl);
            if (propertyDialog.showDialog() != 0) return 2;
            EList<Property> eList = ((PogoProperty)object).is_dev ? this.pogo_class.getDeviceProperties() : this.pogo_class.getClassProperties();
            int n = Utils.getPropertyIndex(eList, property);
            property = propertyDialog.getProperty();
            if (n >= 0) {
                eList.remove(n);
                eList.add(n, property);
            } else {
                eList.add(property);
            }
            this.getSelectedNode().setUserObject(new PogoProperty(property, bl));
            this.setModified(true);
        } else if (object instanceof PogoCommand) {
            Command command = ((PogoCommand)object).value;
            String string = command.getName();
            CommandDialog commandDialog = new CommandDialog(this.parent, command);
            if (commandDialog.showDialog() != 0) return 2;
            EList<Command> eList = this.pogo_class.getCommands();
            int n = Utils.getCommandIndex(eList, command);
            Command command2 = commandDialog.getCommand();
            if (n >= 0) {
                eList.remove(n);
                eList.add(n, command2);
            } else {
                eList.add(command2);
            }
            this.getSelectedNode().setUserObject(new PogoCommand(command2));
            this.setModified(true);
            command2.getStatus().setHasChanged("false");
            String string2 = command2.getName();
            if (!string.equals(string2)) {
                this.renamed_objects.add(command, command2);
            }
        } else if (object instanceof PogoAttribute) {
            Object object2;
            Attribute attribute = ((PogoAttribute)object).value;
            String string = attribute.getName();
            AttributeDialog attributeDialog = new AttributeDialog(this.parent, attribute);
            String string3 = attribute.getAttType();
            if (attributeDialog.showDialog() != 0) return 2;
            Attribute attribute2 = attributeDialog.getAttribute();
            String string4 = attribute2.getAttType();
            if (string4.equals(string3)) {
                ((PogoAttribute)object).value = attribute2;
            } else {
                object2 = this.getSelectedNode();
                this.treeModel.removeNodeFromParent((MutableTreeNode)object2);
                PogoAttribute pogoAttribute = new PogoAttribute(attribute2);
                object2 = new DefaultMutableTreeNode(pogoAttribute);
                DefaultMutableTreeNode defaultMutableTreeNode = string4.equals("Scalar") ? (DefaultMutableTreeNode)this.root.getChildAt(3) : (string4.equals("Spectrum") ? (DefaultMutableTreeNode)this.root.getChildAt(4) : (DefaultMutableTreeNode)this.root.getChildAt(5));
                this.treeModel.insertNodeInto((MutableTreeNode)object2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            this.setModified(true);
            attribute2.getStatus().setHasChanged("false");
            object2 = attribute2.getName();
            if (!string.equals(object2)) {
                this.renamed_objects.add(attribute, attribute2);
            }
        } else if (object instanceof PogoPipe) {
            Pipe pipe = ((PogoPipe)object).value;
            PipeDialog pipeDialog = new PipeDialog(this.parent, pipe);
            String string = pipe.getName();
            if (pipeDialog.showDialog() != 0) return 2;
            EList<Pipe> eList = this.pogo_class.getPipes();
            int n = Utils.getPipeIndex(eList, pipe);
            Pipe pipe2 = pipeDialog.getPipe();
            if (n >= 0) {
                eList.remove(n);
                eList.add(n, pipe2);
            } else {
                eList.add(pipe2);
            }
            this.getSelectedNode().setUserObject(new PogoPipe(pipe2));
            this.setModified(true);
            String string5 = pipe2.getName();
            if (!string.equals(string5)) {
                this.renamed_objects.add(pipe, pipe2);
            }
        }
        ((PogoRoot)this.root.getUserObject()).isAbstract = this.checkIfAbstractClass();
        this.repaint();
        return 0;
    }

    private boolean checkIfAbstractClass() {
        block4: for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            switch (i) {
                case 2: {
                    EObject eObject;
                    DefaultMutableTreeNode defaultMutableTreeNode2;
                    int n;
                    for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                        eObject = ((PogoCommand)defaultMutableTreeNode2.getUserObject()).value;
                        if (Utils.isTrue(eObject.getStatus().getConcrete()) || Utils.isTrue(eObject.getStatus().getConcreteHere())) continue;
                        return true;
                    }
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    EObject eObject;
                    DefaultMutableTreeNode defaultMutableTreeNode2;
                    int n;
                    for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                        eObject = ((PogoAttribute)defaultMutableTreeNode2.getUserObject()).value;
                        if (Utils.isTrue(eObject.getStatus().getConcrete()) || Utils.isTrue(eObject.getStatus().getConcreteHere())) continue;
                        return true;
                    }
                    continue block4;
                }
            }
        }
        return false;
    }

    void addItem(String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            String string3 = defaultMutableTreeNode.toString().toLowerCase();
            if (string2.contains("class prop") && string3.contains("class prop")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("device prop") && string3.contains("device prop")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("command") && string3.contains("command")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("scalar") && string3.contains("scalar")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("spectrum") && string3.contains("spectrum")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("image") && string3.contains("image")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("forwarded") && string3.contains("forwarded")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (string2.contains("pipe") && string3.contains("pipe")) {
                this.addItem(defaultMutableTreeNode, false);
                continue;
            }
            if (!string2.contains("state") || !string3.contains("state")) continue;
            this.addItem(defaultMutableTreeNode, false);
        }
    }

    private void addItem(boolean bl) {
        this.addItem(this.getSelectedNode(), bl);
    }

    private void addItem(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        int n;
        AttributeDialog attributeDialog;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (defaultMutableTreeNode.toString().equals("Commands")) {
            CommandDialog commandDialog = new CommandDialog(this.parent, bl);
            if (commandDialog.showDialog() == 0) {
                Command command = commandDialog.getCommand();
                this.pogo_class.getCommands().add(command);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoCommand(command));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.setModified(true);
            }
        } else if (defaultMutableTreeNode.toString().contains("Properties")) {
            boolean bl2 = defaultMutableTreeNode.toString().indexOf("Device") == 0;
            PropertyDialog propertyDialog = new PropertyDialog(this.parent, null, bl2);
            if (propertyDialog.showDialog() == 0) {
                Property property = propertyDialog.getProperty();
                if (bl2) {
                    this.pogo_class.getDeviceProperties().add(property);
                } else {
                    this.pogo_class.getClassProperties().add(property);
                }
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoProperty(property, bl2));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.setModified(true);
            }
        } else if (defaultMutableTreeNode.toString().equals("States")) {
            StateDialog stateDialog = new StateDialog(this.parent, null);
            if (stateDialog.showDialog() == 0) {
                State state = stateDialog.getState();
                this.pogo_class.getStates().add(state);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoState(state));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.setModified(true);
                this.setSelectionPath(null);
            }
        } else if (defaultMutableTreeNode.toString().contains("Forwarded")) {
            ForwardedAttributeDialog forwardedAttributeDialog = new ForwardedAttributeDialog(this.parent, null);
            if (forwardedAttributeDialog.showDialog() == 0) {
                ForwardedAttribute forwardedAttribute = forwardedAttributeDialog.getForwardedAttribute();
                this.pogo_class.getForwardedAttributes().add(forwardedAttribute);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoForwarded(forwardedAttribute));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.setModified(true);
            }
        } else if (defaultMutableTreeNode.toString().contains("Pipes")) {
            PipeDialog pipeDialog = new PipeDialog(this.parent, null);
            if (pipeDialog.showDialog() == 0) {
                Pipe pipe = pipeDialog.getPipe();
                this.pogo_class.getPipes().add(pipe);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoPipe(pipe));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.setModified(true);
            }
        } else if (defaultMutableTreeNode.toString().contains("Attribute") && (attributeDialog = new AttributeDialog(this.parent, n = defaultMutableTreeNode.toString().startsWith("Scalar") ? 0 : (defaultMutableTreeNode.toString().startsWith("Spectrum") ? 1 : 2), bl)).showDialog() == 0) {
            Attribute attribute = attributeDialog.getAttribute();
            this.pogo_class.getAttributes().add(attribute);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PogoAttribute(attribute));
            String string = attribute.getAttType();
            defaultMutableTreeNode = string.equals("Scalar") ? (DefaultMutableTreeNode)this.root.getChildAt(3) : (string.equals("Spectrum") ? (DefaultMutableTreeNode)this.root.getChildAt(4) : (DefaultMutableTreeNode)this.root.getChildAt(5));
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.setModified(true);
        }
        if (defaultMutableTreeNode2 != null) {
            this.expandNode(defaultMutableTreeNode2);
        }
        ((PogoRoot)this.root.getUserObject()).isAbstract = this.checkIfAbstractClass();
        this.repaint();
    }

    DeletedObjects getDeletedObjects() {
        return this.deleted_objects;
    }

    RenamedObjects getRenamedObjects() {
        return this.renamed_objects;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        this.parent.fireClassHaveChanged();
    }

    DeviceClass getDeviceClass() {
        Object object;
        Object object2;
        Object object32;
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setAncestors(this.deviceClass.getAncestors());
        PogoDeviceClass pogoDeviceClass = deviceClass.getPogoDeviceClass();
        PogoRoot pogoRoot = (PogoRoot)this.root.getUserObject();
        if (pogoRoot.id == null) {
            this.editClass();
            pogoRoot = (PogoRoot)this.root.getUserObject();
            if (pogoRoot.id == null) {
                return null;
            }
        }
        pogoDeviceClass.setName(pogoRoot.name);
        pogoDeviceClass.getDescription().setDescription(pogoRoot.description);
        pogoDeviceClass.getDescription().setTitle(pogoRoot.title);
        pogoDeviceClass.getDescription().setSourcePath(pogoRoot.path);
        pogoDeviceClass.getDescription().setLicense(pogoRoot.license);
        pogoDeviceClass.getDescription().setCopyright(pogoRoot.copyright);
        pogoDeviceClass.getDescription().setIdentification(OAWutils.cloneClassIdentification(pogoRoot.id));
        pogoDeviceClass.getDescription().setLanguage(pogoRoot.language);
        EList<Inheritance> eList = pogoDeviceClass.getDescription().getInheritances();
        eList.clear();
        for (Object object32 : pogoRoot.inheritances) {
            object2 = OAWutils.factory.createInheritance();
            object2.setClassname(object32.getClassname());
            object2.setSourcePath(object32.getSourcePath());
            eList.add((Inheritance)object2);
        }
        EList<Property> eList2 = pogoDeviceClass.getClassProperties();
        object32 = pogoDeviceClass.getDeviceProperties();
        object2 = pogoDeviceClass.getCommands();
        EList<Command> eList3 = pogoDeviceClass.getDynamicCommands();
        EList<Attribute> eList4 = pogoDeviceClass.getAttributes();
        EList<Attribute> eList5 = pogoDeviceClass.getDynamicAttributes();
        EList<ForwardedAttribute> eList6 = pogoDeviceClass.getForwardedAttributes();
        EList<Pipe> eList7 = pogoDeviceClass.getPipes();
        EList<State> eList8 = pogoDeviceClass.getStates();
        block10: for (int i = 0; i < this.root.getChildCount(); ++i) {
            object = (DefaultMutableTreeNode)this.root.getChildAt(i);
            switch (i) {
                case 0: {
                    this.setPropertyToPogoDeviceClass(eList2, (DefaultMutableTreeNode)object);
                    continue block10;
                }
                case 1: {
                    this.setPropertyToPogoDeviceClass((EList<Property>)object32, (DefaultMutableTreeNode)object);
                    continue block10;
                }
                case 2: {
                    this.setCommandsToPogoDeviceClass((EList<Command>)object2, eList3, (DefaultMutableTreeNode)object);
                    continue block10;
                }
                case 8: {
                    this.setStateToPogoDeviceClass(eList8, (DefaultMutableTreeNode)object);
                    continue block10;
                }
                case 6: {
                    this.setForwardedToPogoDeviceClass(eList6, (DefaultMutableTreeNode)object);
                    continue block10;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.setAttributeToPogoDeviceClass(eList4, eList5, (DefaultMutableTreeNode)object);
                    continue block10;
                }
                case 7: {
                    this.setPipeToPogoDeviceClass(eList7, (DefaultMutableTreeNode)object);
                }
            }
        }
        if (pogoDeviceClass.getDynamicCommands().size() > 0 && pogoRoot.language.equals(PogoConst.strLang[2])) {
            Utils.popupError(this, "Dynamic commands are not supported in Python !");
            return null;
        }
        if (pogoDeviceClass.getForwardedAttributes().size() > 0 && pogoRoot.language.equals(PogoConst.strLang[2])) {
            Utils.popupError(this, "Forwarded attributes are not supported in Python !");
            return null;
        }
        DeviceClass.checkIfAbstractClass(pogoDeviceClass, true);
        EList<AdditionalFile> eList9 = pogoDeviceClass.getAdditionalFiles();
        object = this.deviceClass.getPogoDeviceClass().getAdditionalFiles();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            AdditionalFile additionalFile = (AdditionalFile)iterator.next();
            eList9.add(OAWutils.cloneAdditionalFile(additionalFile));
        }
        this.checkForPollingPeriodOverloaded(deviceClass.getPogoDeviceClass());
        return deviceClass;
    }

    private void checkForPollingPeriodOverloaded(PogoDeviceClass pogoDeviceClass) {
        EObject eObject;
        ArrayList<DeviceClass> arrayList = this.deviceClass.getAncestors();
        if (arrayList.isEmpty()) {
            return;
        }
        EList<OverlodedPollPeriodObject> eList = pogoDeviceClass.getOverlodedPollPeriodObject();
        EList<Attribute> eList2 = this.pogo_class.getAttributes();
        for (Attribute object32 : eList2) {
            for (DeviceClass deviceClass : arrayList) {
                EList<Attribute> eList3 = deviceClass.getPogoDeviceClass().getAttributes();
                for (Object object : eList3) {
                    if (object.getPolledPeriod() == null) {
                        object.setPolledPeriod("0");
                    }
                    if (!object.getName().equals(object32.getName()) || object32.getPolledPeriod().equals(object.getPolledPeriod())) continue;
                    eObject = OAWutils.factory.createOverlodedPollPeriodObject();
                    eObject.setName(object32.getName());
                    eObject.setType("attribute");
                    eObject.setPollPeriod(object32.getPolledPeriod());
                    eList.add((OverlodedPollPeriodObject)eObject);
                }
            }
        }
        EList<Command> eList3 = this.pogo_class.getCommands();
        Iterator iterator = eList3.iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            for (DeviceClass deviceClass : arrayList) {
                Object object;
                EList<Command> eList4 = deviceClass.getPogoDeviceClass().getCommands();
                object = eList4.iterator();
                while (object.hasNext()) {
                    eObject = (Command)object.next();
                    if (eObject.getPolledPeriod() == null) {
                        eObject.setPolledPeriod("0");
                    }
                    if (!eObject.getName().equals(command.getName()) || command.getPolledPeriod().equals(eObject.getPolledPeriod())) continue;
                    OverlodedPollPeriodObject overlodedPollPeriodObject = OAWutils.factory.createOverlodedPollPeriodObject();
                    overlodedPollPeriodObject.setName(command.getName());
                    overlodedPollPeriodObject.setType("command");
                    overlodedPollPeriodObject.setPollPeriod(command.getPolledPeriod());
                    eList.add(overlodedPollPeriodObject);
                }
            }
        }
    }

    private DefaultMutableTreeNode getCollectionNode(int n) {
        return (DefaultMutableTreeNode)this.root.getChildAt(n);
    }

    private void setPropertyToPogoDeviceClass(EList<Property> eList, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Property property = ((PogoProperty)defaultMutableTreeNode2.getUserObject()).value;
            eList.add(OAWutils.cloneProperty(property));
        }
    }

    private void setCommandsToPogoDeviceClass(EList<Command> eList, EList<Command> eList2, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Command command = ((PogoCommand)defaultMutableTreeNode2.getUserObject()).value;
            command.setExecMethod(Utils.buildCppExecuteMethodName(command.getName()));
            if (command.getPolledPeriod() == null || command.getPolledPeriod().length() == 0) {
                command.setPolledPeriod("0");
            }
            if (Utils.isTrue(command.getIsDynamic())) {
                eList2.add(OAWutils.cloneCommand(command));
                continue;
            }
            eList.add(OAWutils.cloneCommand(command));
        }
    }

    private void setAttributeToPogoDeviceClass(EList<Attribute> eList, EList<Attribute> eList2, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Attribute attribute = ((PogoAttribute)defaultMutableTreeNode2.getUserObject()).value;
            if (attribute.getPolledPeriod() == null || attribute.getPolledPeriod().length() == 0) {
                attribute.setPolledPeriod("0");
            }
            if (Utils.isTrue(attribute.getIsDynamic())) {
                eList2.add(OAWutils.cloneAttribute(attribute));
                continue;
            }
            eList.add(OAWutils.cloneAttribute(attribute));
        }
    }

    private void setStateToPogoDeviceClass(EList<State> eList, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            State state = ((PogoState)defaultMutableTreeNode2.getUserObject()).value;
            eList.add(OAWutils.cloneState(state));
        }
    }

    private void setForwardedToPogoDeviceClass(EList<ForwardedAttribute> eList, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ForwardedAttribute forwardedAttribute = ((PogoForwarded)defaultMutableTreeNode2.getUserObject()).value;
            eList.add(OAWutils.cloneForwardedAttribute(forwardedAttribute));
        }
    }

    private void setPipeToPogoDeviceClass(EList<Pipe> eList, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Pipe pipe = ((PogoPipe)defaultMutableTreeNode2.getUserObject()).value;
            eList.add(OAWutils.clonePipe(pipe));
        }
    }

    boolean itemAlreadyExists(String string, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == 2) {
            arrayList.add(2);
        } else if (n == 3 || n == 4 || n == 5) {
            arrayList.add(3);
            arrayList.add(4);
            arrayList.add(5);
        } else if (n == 7) {
            arrayList.add(7);
        } else if (n == 8) {
            arrayList.add(8);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getCollectionNode(n2);
            for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                if (!defaultMutableTreeNode3.toString().equals(string) || defaultMutableTreeNode3 == defaultMutableTreeNode) continue;
                return true;
            }
        }
        return false;
    }

    boolean propertyAlreadyExists(String string, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = bl ? this.getCollectionNode(1) : this.getCollectionNode(0);
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
            if (!defaultMutableTreeNode3.toString().equals(string) || defaultMutableTreeNode3 == defaultMutableTreeNode) continue;
            return true;
        }
        return false;
    }

    public void editStateMachine() {
        ArrayList<State> arrayList = this.getAllStates();
        ArrayList<Attribute> arrayList2 = this.getAllAttributes();
        ArrayList<Command> arrayList3 = this.getAllCommands();
        if (arrayList.isEmpty()) {
            PogoException.popup((Component)this, "There is no states defined !");
            return;
        }
        if (arrayList3.isEmpty() && arrayList2.isEmpty()) {
            PogoException.popup((Component)this, "There is no commands and no attributes defined !");
            return;
        }
        StateMachineDialog stateMachineDialog = new StateMachineDialog(this.parent, this.pogo_class);
        if (stateMachineDialog.showDialog() == 0) {
            this.pogo_class = stateMachineDialog.getPogoClass();
            this.setModified(true);
        }
    }

    private void summarize() {
        Object object = this.getSelectedObject();
        if (object instanceof PogoRoot) {
            JOptionPane.showMessageDialog(this.parent, this.summarizeClass((PogoRoot)object), "information Window", 1);
        } else if (object.toString().indexOf("Properties") > 0) {
            boolean bl = object.toString().startsWith("Device");
            ArrayList<Property> arrayList = this.getAllProperties(bl);
            PropertyDialog.popupSummary(this.parent, arrayList, bl);
        } else if (object.toString().equals("Commands")) {
            ArrayList<Command> arrayList = this.getAllCommands();
            CommandDialog.popupSummary(this.parent, arrayList);
        } else if (object.toString().indexOf("Attributes") > 0) {
            ArrayList<Attribute> arrayList = this.getAllAttributes();
            AttributeDialog.popupSummary(this.parent, arrayList);
        } else if (object.toString().equals("Pipes")) {
            ArrayList<Pipe> arrayList = this.getAllPipes();
            PipeDialog.popupSummary(this.parent, arrayList);
        } else if (object.toString().equals("States")) {
            ArrayList<State> arrayList = this.getAllStates();
            StateDialog.popupSummary(this.parent, arrayList);
        }
    }

    private String summarizeClass(PogoRoot pogoRoot) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(0);
        int n2 = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(1);
        int n3 = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(2);
        int n4 = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(3);
        int n5 = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(4);
        int n6 = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(5);
        int n7 = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(8);
        int n8 = defaultMutableTreeNode.getChildCount();
        StringBuilder stringBuilder = new StringBuilder(pogoRoot.toInfoString());
        stringBuilder.append("\n\n");
        if (n2 > 0) {
            stringBuilder.append(n2).append("  Class properties\n");
        }
        if (n3 > 0) {
            stringBuilder.append(n3).append("  Device properties\n");
        }
        if (n4 > 0) {
            stringBuilder.append(n4).append("  Commands\n");
        }
        if ((n = n5 + n6 + n7) > 0) {
            stringBuilder.append(n).append("  Attributes:\n");
            if (n5 > 0) {
                stringBuilder.append("    ").append(n5).append("  Scalars\n");
            }
            if (n6 > 0) {
                stringBuilder.append("    ").append(n6).append("  Spectrums\n");
            }
            if (n7 > 0) {
                stringBuilder.append("    ").append(n7).append("  Images\n");
            }
        }
        if (n8 > 0) {
            stringBuilder.append(n8).append("  States\n");
        }
        return stringBuilder.toString();
    }

    private ArrayList<Property> getAllProperties(boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        DefaultMutableTreeNode defaultMutableTreeNode = bl ? (DefaultMutableTreeNode)this.root.getChildAt(1) : (DefaultMutableTreeNode)this.root.getChildAt(0);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            PogoProperty pogoProperty = (PogoProperty)defaultMutableTreeNode2.getUserObject();
            arrayList.add(pogoProperty.value);
        }
        return arrayList;
    }

    private ArrayList<Command> getAllCommands() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(2);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            PogoCommand pogoCommand = (PogoCommand)defaultMutableTreeNode2.getUserObject();
            arrayList.add(pogoCommand.value);
        }
        return arrayList;
    }

    private ArrayList<Attribute> getAllAttributes() {
        PogoAttribute pogoAttribute;
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.root.getChildAt(3);
        for (n = 0; n < defaultMutableTreeNode2.getChildCount(); ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            pogoAttribute = (PogoAttribute)defaultMutableTreeNode.getUserObject();
            arrayList.add(pogoAttribute.value);
        }
        defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.root.getChildAt(4);
        for (n = 0; n < defaultMutableTreeNode2.getChildCount(); ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            pogoAttribute = (PogoAttribute)defaultMutableTreeNode.getUserObject();
            arrayList.add(pogoAttribute.value);
        }
        defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.root.getChildAt(5);
        for (n = 0; n < defaultMutableTreeNode2.getChildCount(); ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            pogoAttribute = (PogoAttribute)defaultMutableTreeNode.getUserObject();
            arrayList.add(pogoAttribute.value);
        }
        return arrayList;
    }

    private ArrayList<Pipe> getAllPipes() {
        ArrayList<Pipe> arrayList = new ArrayList<Pipe>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(7);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            PogoPipe pogoPipe = (PogoPipe)defaultMutableTreeNode2.getUserObject();
            arrayList.add(pogoPipe.value);
        }
        return arrayList;
    }

    private ArrayList<State> getAllStates() {
        ArrayList<State> arrayList = new ArrayList<State>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(8);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            PogoState pogoState = (PogoState)defaultMutableTreeNode2.getUserObject();
            arrayList.add(pogoState.value);
        }
        return arrayList;
    }

    String getClassFileName() {
        String string = ((PogoRoot)this.root.getUserObject()).path;
        if (string != null) {
            String string2 = ((PogoRoot)this.root.getUserObject()).name + ".xmi";
            return string + "/" + string2;
        }
        return null;
    }

    class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        NodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            if (defaultMutableTreeNode.toString().equals("State") || defaultMutableTreeNode.toString().equals("Status")) {
                return -1;
            }
            if (defaultMutableTreeNode2.toString().equals("State") || defaultMutableTreeNode2.toString().equals("Status")) {
                return -1;
            }
            return defaultMutableTreeNode.toString().compareTo(defaultMutableTreeNode2.toString());
        }
    }

    private class ClassTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private ClassTreePopupMenu(JTree jTree) {
            this.tree = jTree;
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ClassTreePopupMenu.this.menuActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        private void manageItemMenu(String string) {
            for (int i = 2; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JMenuItem)) continue;
                String string2 = menuLabels[i - 2];
                int n = string2.indexOf("Item");
                if (n > 0) {
                    string2 = string2.substring(0, n) + string + string2.substring(n + "Item".length());
                }
                ((JMenuItem)component).setText(string2);
            }
        }

        public void showMenu(MouseEvent mouseEvent, PogoRoot pogoRoot) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText("Class " + pogoRoot.name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.getComponent(8).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, PogoCollection pogoCollection) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.manageItemMenu(pogoCollection.toString());
            this.title.setText(pogoCollection.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(!pogoCollection.name.contains("Forwarded"));
            this.getComponent(4).setVisible(!pogoCollection.name.contains("Forwarded") && (pogoCollection.name.contains("Attribute") || pogoCollection.name.contains("Command")));
            this.getComponent(5).setVisible(pogoCollection.name.contains("Forwarded"));
            this.getComponent(6).setVisible(ClassTree.this.canPaste());
            this.getComponent(7).setVisible(true);
            this.getComponent(8).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, Object object, String string) {
            int n;
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.manageItemMenu(object.toString());
            this.title.setText(string);
            for (n = 0; n < menuLabels.length; ++n) {
                this.getComponent(2 + n).setVisible(false);
            }
            this.getComponent(9).setVisible(true);
            this.getComponent(10).setVisible(true);
            this.getComponent(11).setVisible(true);
            this.getComponent(12).setVisible(true);
            ((JMenuItem)this.getComponent(9)).setText("Edit " + object.toString());
            this.getComponent(13).setVisible(true);
            n = 0;
            if (object instanceof PogoProperty) {
                n = Utils.isTrue(((PogoProperty)object).value.getStatus().getConcreteHere()) ? 1 : 0;
            } else if (object instanceof PogoCommand) {
                n = Utils.isTrue(((PogoCommand)object).value.getStatus().getConcreteHere()) ? 1 : 0;
            } else if (object instanceof PogoAttribute) {
                n = Utils.isTrue(((PogoAttribute)object).value.getStatus().getConcreteHere());
            } else if (object instanceof PogoForwarded) {
                n = Utils.isTrue(((PogoForwarded)object).value.getStatus().getConcreteHere());
            } else if (object instanceof PogoPipe) {
                n = 1;
            } else if (object instanceof PogoState) {
                n = Utils.isTrue(((PogoState)object).value.getStatus().getConcreteHere());
            }
            this.getComponent(13).setEnabled(n != 0);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        private void menuActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    ClassTree.this.editClass();
                    break;
                }
                case 1: {
                    ClassTree.this.addItem(false);
                    break;
                }
                case 2: {
                    ClassTree.this.addItem(true);
                    break;
                }
                case 3: {
                    ClassTree.this.addItem(false);
                    break;
                }
                case 4: {
                    ClassTree.this.pasteItem();
                    break;
                }
                case 5: {
                    ClassTree.this.sortItems();
                    break;
                }
                case 6: {
                    ClassTree.this.summarize();
                    break;
                }
                case 7: {
                    ClassTree.this.editItem();
                    break;
                }
                case 8: {
                    ClassTree.this.copyItem();
                    break;
                }
                case 9: {
                    ClassTree.this.cloneItem();
                    break;
                }
                case 10: {
                    ClassTree.this.removeSelectedItem();
                    break;
                }
                case 11: {
                    ClassTree.this.editSourceCode();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Utils utils = Utils.getInstance();
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (n == 0) {
                PogoRoot pogoRoot = (PogoRoot)object2;
                if (pogoRoot.isAbstract) {
                    this.setFont(PogoConst.rootFont_abstract);
                } else {
                    this.setFont(PogoConst.rootFont_concrete);
                }
                this.setIcon(utils.rootIcon);
                this.setToolTipText(pogoRoot.toInfoString());
            } else if (object2 instanceof PogoProperty) {
                ((PogoProperty)object2).manageDisplay(this);
            } else if (object2 instanceof PogoCommand) {
                ((PogoCommand)object2).manageDisplay(this);
                if (Utils.isTrue(((PogoCommand)object2).value.getIsDynamic())) {
                    this.setBackgroundNonSelectionColor(dynamicBG);
                }
            } else if (object2 instanceof PogoAttribute) {
                ((PogoAttribute)object2).manageDisplay(this);
                if (Utils.isTrue(((PogoAttribute)object2).value.getIsDynamic())) {
                    this.setBackgroundNonSelectionColor(dynamicBG);
                }
            } else if (object2 instanceof PogoForwarded) {
                ((PogoForwarded)object2).manageDisplay(this);
            } else if (object2 instanceof PogoPipe) {
                ((PogoPipe)object2).manageDisplay(this);
            } else if (object2 instanceof PogoState) {
                PogoState pogoState = (PogoState)object2;
                pogoState.manageDisplay(this);
                this.setBackgroundNonSelectionColor(Utils.getColor4State(pogoState.toString()));
                this.setForeground(Utils.getForeground4State(pogoState.toString()));
            } else if (object2 instanceof PogoCollection) {
                this.setFont(PogoConst.collecFont);
                this.setIcon(((PogoCollection)object2).icon);
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private class PogoState {
        State value;

        private PogoState(State state) {
            this.value = state;
        }

        private String toInfoString() {
            String string = this.value.getDescription();
            string = string != null && string.length() > 0 ? Utils.strReplace(string, "\\n", "\n") : "No Description.";
            return Utils.buildToolTip("State:  " + this.value.getName(), string);
        }

        private void manageDisplay(TangoRenderer tangoRenderer) {
            InheritanceStatus inheritanceStatus = this.value.getStatus();
            tangoRenderer.setIcon(ClassTree.this.inherit_utils.getIcon(inheritanceStatus));
            tangoRenderer.setFont(ClassTree.this.inherit_utils.getLeafFont(inheritanceStatus));
            if (inheritanceStatus != null && inheritanceStatus.getHasChanged() != null) {
                tangoRenderer.setForeground(Color.red);
            } else {
                tangoRenderer.setForeground(Color.black);
            }
            tangoRenderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoPipe {
        Pipe value;

        private PogoPipe(Pipe pipe) {
            this.value = pipe;
        }

        private String toInfoString() {
            String string = "Pipe:  " + this.value.getName();
            return Utils.buildToolTip(string, Utils.strReplace(this.value.getDescription(), "\\n", "\n"));
        }

        private void manageDisplay(TangoRenderer tangoRenderer) {
            tangoRenderer.setIcon(Utils.getInstance().overloadedIcon);
            tangoRenderer.setFont(PogoConst.leafFont_concrete);
            tangoRenderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoForwarded {
        ForwardedAttribute value;

        private PogoForwarded(ForwardedAttribute forwardedAttribute) {
            this.value = forwardedAttribute;
        }

        private String toInfoString() {
            String string = this.value.getLabel();
            string = string != null && string.length() > 0 ? Utils.strReplace(string, "\\n", "\n") : "No Label.";
            return Utils.buildToolTip("Label:  " + this.value.getName(), string);
        }

        private void manageDisplay(TangoRenderer tangoRenderer) {
            InheritanceStatus inheritanceStatus = this.value.getStatus();
            tangoRenderer.setIcon(ClassTree.this.inherit_utils.getIcon(inheritanceStatus));
            tangoRenderer.setFont(ClassTree.this.inherit_utils.getLeafFont(inheritanceStatus));
            if (inheritanceStatus != null && inheritanceStatus.getHasChanged() != null) {
                tangoRenderer.setForeground(Color.red);
            } else {
                tangoRenderer.setForeground(Color.black);
            }
            tangoRenderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoCommand {
        Command value;

        private PogoCommand(Command command) {
            this.value = command;
        }

        private String toInfoString() {
            String string = this.value.getDescription();
            string = string != null && string.length() > 0 ? Utils.strReplace(string, "\\n", "\n") : "No Description.";
            String string2 = "Command:  ";
            if (Utils.isTrue(this.value.getIsDynamic())) {
                string2 = "Dynamic " + string2;
            }
            return Utils.buildToolTip(string2 + this.value.getName(), string);
        }

        private void manageDisplay(TangoRenderer tangoRenderer) {
            InheritanceStatus inheritanceStatus = this.value.getStatus();
            tangoRenderer.setIcon(ClassTree.this.inherit_utils.getIcon(inheritanceStatus));
            tangoRenderer.setFont(ClassTree.this.inherit_utils.getLeafFont(inheritanceStatus));
            if (inheritanceStatus != null && Utils.isTrue(inheritanceStatus.getHasChanged())) {
                tangoRenderer.setForeground(Color.red);
            } else if (Utils.isExpert(this.value)) {
                tangoRenderer.setForeground(Color.blue);
            } else {
                tangoRenderer.setForeground(Color.black);
            }
            tangoRenderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoAttribute {
        Attribute value;
        int attType;

        private PogoAttribute(Attribute attribute) {
            this.value = attribute;
            this.attType = Utils.isEquals(attribute.getAttType(), "Spectrum") ? 4 : (Utils.isEquals(attribute.getAttType(), "Image") ? 5 : 3);
        }

        private String toInfoString() {
            String string = this.value.getProperties() == null || this.value.getProperties().getDescription() == null || this.value.getProperties().getDescription().isEmpty() ? "No Description." : Utils.strReplace(this.value.getProperties().getDescription(), "\\n", "\n");
            String string2 = "Attribute:  ";
            if (Utils.isTrue(this.value.getIsDynamic())) {
                string2 = "Dynamic " + string2;
            }
            return Utils.buildToolTip(string2 + this.value.getName(), string);
        }

        private void manageDisplay(TangoRenderer tangoRenderer) {
            InheritanceStatus inheritanceStatus = this.value.getStatus();
            tangoRenderer.setIcon(ClassTree.this.inherit_utils.getIcon(inheritanceStatus));
            tangoRenderer.setFont(ClassTree.this.inherit_utils.getLeafFont(inheritanceStatus));
            if (inheritanceStatus != null && Utils.isTrue(inheritanceStatus.getHasChanged())) {
                tangoRenderer.setForeground(Color.red);
            } else if (Utils.isExpert(this.value)) {
                tangoRenderer.setForeground(Color.blue);
            } else {
                tangoRenderer.setForeground(Color.black);
            }
            tangoRenderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoProperty {
        Property value;
        boolean is_dev;

        private PogoProperty(Property property, boolean bl) {
            this.value = property;
            this.is_dev = bl;
        }

        private String toInfoString() {
            String string = (this.is_dev ? "Device" : "Class") + " property:  " + this.value.getName();
            return Utils.buildToolTip(string, Utils.strReplace(this.value.getDescription(), "\\n", "\n"));
        }

        private void manageDisplay(TangoRenderer tangoRenderer) {
            InheritanceStatus inheritanceStatus = this.value.getStatus();
            tangoRenderer.setIcon(ClassTree.this.inherit_utils.getIcon(inheritanceStatus));
            tangoRenderer.setFont(ClassTree.this.inherit_utils.getLeafFont(inheritanceStatus));
            if (inheritanceStatus != null && inheritanceStatus.getHasChanged() != null) {
                tangoRenderer.setForeground(Color.red);
            } else {
                tangoRenderer.setForeground(Color.black);
            }
            tangoRenderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoCollection {
        String name;
        ImageIcon icon;

        private PogoCollection(String string, ImageIcon imageIcon) {
            this.name = string;
            this.icon = imageIcon;
        }

        public String toString() {
            return this.name;
        }
    }

    class PogoRoot {
        private String name;
        private String description;
        private String title;
        private String language;
        private String path;
        private String license;
        private String copyright;
        private boolean isAbstract;
        private ArrayList<Inheritance> inheritances = new ArrayList();
        private ClassIdentification id;

        private PogoRoot(PogoDeviceClass pogoDeviceClass) {
            this.name = pogoDeviceClass.getName();
            this.description = pogoDeviceClass.getDescription().getDescription();
            this.title = pogoDeviceClass.getDescription().getTitle();
            this.language = pogoDeviceClass.getDescription().getLanguage();
            this.path = pogoDeviceClass.getDescription().getSourcePath();
            this.license = pogoDeviceClass.getDescription().getLicense();
            this.copyright = pogoDeviceClass.getDescription().getCopyright();
            this.isAbstract = DeviceClass.checkIfAbstractClass(pogoDeviceClass, false);
            this.id = pogoDeviceClass.getDescription().getIdentification();
            for (Inheritance inheritance : pogoDeviceClass.getDescription().getInheritances()) {
                this.inheritances.add(inheritance);
            }
        }

        private String toInfoString() {
            String string = this.language + " Class :  " + this.name;
            if (this.isAbstract) {
                string = string + "  (class is abstract !)";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.path != null && this.path.length() > 0) {
                stringBuilder.append("Read at:   ").append(this.path);
            }
            stringBuilder.append("\nInherited from: ").append(this.inheritances.get(0).getClassname());
            if (!DeviceClass.isDefaultInheritance(this.inheritances.get(0))) {
                stringBuilder.append("\nRead at:   ").append(this.inheritances.get(0).getSourcePath());
            } else {
                stringBuilder.append("  the default Tango device object.\n");
            }
            stringBuilder.append("\n\nDescription:\n");
            stringBuilder.append(Utils.strReplace(this.description, "\\n", "\n")).append("\n");
            return Utils.buildToolTip(string, stringBuilder.toString());
        }

        public String toString() {
            return ClassTree.this.pogo_class.getName();
        }
    }
}

