/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.xtend.XtendResourceParser;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ecoreInference.IXtext2EcorePostProcessor;

public class XtendXtext2EcorePostProcessor
implements IXtext2EcorePostProcessor {
    private static final Logger logger = Logger.getLogger(XtendXtext2EcorePostProcessor.class);
    private ExecutionContext executionContext;
    private Resource xtendFile;

    public void process(GeneratedMetamodel metamodel) {
        Resource xtendFile = this.loadXtendFile(metamodel);
        if (xtendFile != null) {
            ExecutionContext ctx = this.getExecutionContext(metamodel);
            ctx = ctx.cloneWithResource(xtendFile);
            ResourceLoader currentThreadResourceLoader = null;
            try {
                try {
                    currentThreadResourceLoader = ResourceLoaderFactory.getCurrentThreadResourceLoader();
                    ResourceLoaderFactory.setCurrentThreadResourceLoader(this.getResourceLoader(metamodel));
                    Object[] params = new Object[]{metamodel};
                    Extension extension = ctx.getExtension("process", params);
                    if (extension != null) {
                        extension.evaluate(params, ctx);
                    }
                }
                catch (EvaluationException e) {
                    logger.error("Error encountered processing metamodel " + metamodel.getName() + " with " + xtendFile.getFullyQualifiedName(), e);
                    ResourceLoaderFactory.setCurrentThreadResourceLoader(currentThreadResourceLoader);
                }
            }
            finally {
                ResourceLoaderFactory.setCurrentThreadResourceLoader(currentThreadResourceLoader);
            }
        }
    }

    protected ResourceLoader getResourceLoader(GeneratedMetamodel metamodel) {
        return ResourceLoaderFactory.createResourceLoader();
    }

    protected ExecutionContext getExecutionContext(GeneratedMetamodel metamodel) {
        if (this.executionContext == null) {
            ExecutionContextImpl executionContext = new ExecutionContextImpl();
            executionContext.registerMetaModel(new EmfRegistryMetaModel());
            executionContext.registerMetaModel(new JavaBeansMetaModel());
            this.executionContext = executionContext;
        }
        return this.executionContext;
    }

    protected Resource loadXtendFile(GeneratedMetamodel metamodel) {
        block8: {
            if (this.xtendFile == null) {
                String extension = this.getExtensionName(metamodel);
                try {
                    URIConverter uriConverter;
                    URI uri = this.getXtendFileLocation(metamodel);
                    if (uri == null || !(uriConverter = metamodel.eResource().getResourceSet().getURIConverter()).exists(uri, null)) break block8;
                    InputStream in = uriConverter.createInputStream(uri);
                    try {
                        XtendResourceParser parser = new XtendResourceParser();
                        this.xtendFile = parser.parse(new InputStreamReader(in), String.valueOf(extension) + '.' + "ext");
                        this.fireXtendFileLoaded();
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (ClasspathUriResolutionException uri) {
                }
                catch (Exception e) {
                    logger.error("Could not parse " + extension, e);
                }
            }
        }
        return this.xtendFile;
    }

    protected void fireXtendFileLoaded() {
    }

    protected final void clearCachedXtendFile() {
        this.xtendFile = null;
    }

    protected String getExtensionName(GeneratedMetamodel metamodel) {
        Grammar grammar = (Grammar)metamodel.eContainer();
        String extension = String.valueOf(grammar.getName().replace(".", "::")) + "PostProcessor";
        return extension;
    }

    protected URI getXtendFileLocation(GeneratedMetamodel metamodel) {
        URI uri = metamodel.eResource().getURI();
        if (!uri.isHierarchical() || uri.isRelative()) {
            return null;
        }
        uri = URI.createURI(Strings.lastToken(this.getExtensionName(metamodel), "::")).appendFileExtension("ext").resolve(uri);
        return uri;
    }
}

