/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.sequencer.IAssignmentFinder;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.TransientValueUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ContextFinder
implements IContextFinder {
    @Inject
    protected IAssignmentFinder assignmentFinder;
    protected List<IGrammarConstraintProvider.IConstraintContext> constraintContexts;
    protected Map<Pair<EObject, EClass>, IGrammarConstraintProvider.IConstraint> constraints;
    @Inject
    protected IGrammarAccess grammar;
    @Inject
    protected IGrammarConstraintProvider grammarConstraintProvider;
    @Inject
    protected TransientValueUtil transientValueUtil;
    @Inject
    protected ITransientValueService transientValues;
    @Inject
    protected ISemanticNodeProvider nodesProvider;

    protected Iterable<AbstractElement> findAssignedElements(EObject obj, EStructuralFeature feature, Iterable<AbstractElement> candidates) {
        if (feature.isMany()) {
            HashSet<AbstractElement> r = Sets.newHashSet();
            ISemanticNodeProvider.INodesForEObjectProvider nodes = this.nodesProvider.getNodesForSemanticObject(obj, null);
            switch (this.transientValues.isListTransient(obj, feature)) {
                case SOME: {
                    List values1 = (List)obj.eGet(feature);
                    int j = 0;
                    int i = 0;
                    while (i < values1.size()) {
                        if (!this.transientValues.isValueInListTransient(obj, i, feature)) {
                            Object value = values1.get(i);
                            INode node = nodes.getNodeForMultiValue(feature, i, j, value);
                            Iterables.addAll(r, this.assignmentFinder.findAssignmentsByValue(obj, candidates, value, node));
                            ++j;
                        }
                        ++i;
                    }
                    return r;
                }
                case NO: {
                    List values2 = (List)obj.eGet(feature);
                    int i = 0;
                    while (i < values2.size()) {
                        Object value = values2.get(i);
                        INode node = nodes.getNodeForMultiValue(feature, i, i, value);
                        Iterables.addAll(r, this.assignmentFinder.findAssignmentsByValue(obj, candidates, value, node));
                        ++i;
                    }
                    return r;
                }
            }
            return Collections.emptyList();
        }
        if (this.transientValues.isValueTransient(obj, feature) == ITransientValueService.ValueTransient.YES) {
            return Collections.emptyList();
        }
        Object value = obj.eGet(feature);
        INode node = this.nodesProvider.getNodesForSemanticObject(obj, null).getNodeForSingelValue(feature, value);
        return this.assignmentFinder.findAssignmentsByValue(obj, candidates, value, node);
    }

    protected Iterable<EObject> findContextsByContainer(EObject semanticObject, Iterable<EObject> contextCandidates) {
        HashSet<Object> result;
        if (semanticObject.eResource() != null && semanticObject.eResource().getContents().contains(semanticObject)) {
            return Collections.singleton(this.getRootContext());
        }
        EReference ref = semanticObject.eContainmentFeature();
        if (ref == null || contextCandidates != null && Iterables.size(contextCandidates) < 2) {
            return contextCandidates;
        }
        Map<IGrammarConstraintProvider.IConstraint, List<EObject>> containerConstraints = this.getConstraints(semanticObject.eContainer().eClass());
        int refID = semanticObject.eContainer().eClass().getFeatureID(ref);
        HashSet<EObject> childContexts = Sets.newHashSet();
        for (IGrammarConstraintProvider.IConstraint constraint : Lists.newArrayList(containerConstraints.keySet())) {
            if (constraint.getFeatures()[refID] == null) {
                containerConstraints.remove(constraint);
                continue;
            }
            childContexts.addAll(constraint.getFeatures()[refID].getCalledContexts());
        }
        if (contextCandidates != null) {
            result = Sets.newHashSet(contextCandidates);
            result.retainAll(childContexts);
        } else {
            result = childContexts;
        }
        if (result.size() < 2) {
            return result;
        }
        Iterable<EObject> filteredContexts = this.findContextsByContainer(semanticObject.eContainer(), Iterables.concat(containerConstraints.values()));
        childContexts = Sets.newHashSet();
        for (Map.Entry<IGrammarConstraintProvider.IConstraint, List<EObject>> e : Lists.newArrayList(containerConstraints.entrySet())) {
            if (!this.intersect(filteredContexts, (Iterable<EObject>)e.getValue())) continue;
            childContexts.addAll(e.getKey().getFeatures()[refID].getCalledContexts());
        }
        result.retainAll(childContexts);
        return result;
    }

    @Override
    public Iterable<EObject> findContextsByContents(EObject semanticObject, Iterable<EObject> contextCandidates) {
        if (semanticObject == null) {
            throw new NullPointerException();
        }
        this.initConstraints();
        Map<IGrammarConstraintProvider.IConstraint, List<EObject>> constraints = contextCandidates != null ? this.getConstraints(semanticObject, contextCandidates) : this.getConstraints(semanticObject.eClass());
        if (constraints.size() < 2) {
            return Iterables.concat(constraints.values());
        }
        for (IGrammarConstraintProvider.IConstraint cand : Lists.newArrayList(constraints.keySet())) {
            if (this.isValidValueQuantity(cand, semanticObject)) continue;
            constraints.remove(cand);
        }
        if (constraints.size() < 2) {
            return Iterables.concat(constraints.values());
        }
        for (EStructuralFeature feat : semanticObject.eClass().getEAllStructuralFeatures()) {
            if (this.transientValueUtil.isTransient(semanticObject, feat) != ITransientValueService.ValueTransient.NO) continue;
            constraints.keySet().retainAll(this.findContextsByValue(semanticObject, feat, constraints.keySet()));
            if (constraints.size() >= 2) continue;
            return Iterables.concat(constraints.values());
        }
        return Iterables.concat(constraints.values());
    }

    @Override
    public Iterable<EObject> findContextsByContentsAndContainer(EObject semanticObject, Iterable<EObject> contextCandidates) {
        this.initConstraints();
        contextCandidates = this.findContextsByContainer(semanticObject, contextCandidates);
        if (contextCandidates != null && Iterables.size(contextCandidates) < 2) {
            return contextCandidates;
        }
        return this.findContextsByContents(semanticObject, contextCandidates);
    }

    protected Collection<IGrammarConstraintProvider.IConstraint> findContextsByValue(EObject semanicObj, EStructuralFeature feature, Iterable<IGrammarConstraintProvider.IConstraint> constraints) {
        HashMultimap<IGrammarConstraintProvider.IConstraint, AbstractElement> contexts = HashMultimap.create();
        int refID = semanicObj.eClass().getFeatureID(feature);
        for (IGrammarConstraintProvider.IConstraint constraint : constraints) {
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = constraint.getFeatures()[refID].getAssignments();
            int n = iConstraintElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
                contexts.put(constraint, ass.getGrammarElement());
                ++n2;
            }
        }
        HashSet<AbstractElement> ass = Sets.newHashSet(this.findAssignedElements(semanicObj, feature, contexts.values()));
        for (IGrammarConstraintProvider.IConstraint constraint : constraints) {
            if (!Collections.disjoint(contexts.get(constraint), ass)) continue;
            contexts.removeAll(constraint);
        }
        return contexts.keySet();
    }

    protected Map<IGrammarConstraintProvider.IConstraint, List<EObject>> getConstraints(EClass cls) {
        HashMap<IGrammarConstraintProvider.IConstraint, List<EObject>> result = Maps.newHashMap();
        for (IGrammarConstraintProvider.IConstraintContext cc : this.constraintContexts) {
            for (IGrammarConstraintProvider.IConstraint constraint : cc.getConstraints()) {
                if (constraint.getType() != cls) continue;
                ArrayList<EObject> ctxs = (ArrayList<EObject>)result.get(constraint);
                if (ctxs == null) {
                    ctxs = Lists.newArrayList();
                    result.put(constraint, ctxs);
                }
                ctxs.add(cc.getContext());
            }
        }
        return result;
    }

    protected Map<IGrammarConstraintProvider.IConstraint, List<EObject>> getConstraints(EObject semanticObject, Iterable<EObject> contextCandidates) {
        HashMap<IGrammarConstraintProvider.IConstraint, List<EObject>> result = Maps.newHashMap();
        for (EObject ctx : contextCandidates) {
            IGrammarConstraintProvider.IConstraint constraint = this.constraints.get(Tuples.create(ctx, semanticObject.eClass()));
            if (ctx == null) continue;
            ArrayList<EObject> ctxs = (ArrayList<EObject>)result.get(constraint);
            if (ctxs == null) {
                ctxs = Lists.newArrayList();
                result.put(constraint, ctxs);
            }
            ctxs.add(ctx);
        }
        return result;
    }

    protected EObject getRootContext() {
        for (AbstractRule rule : this.grammar.getGrammar().getRules()) {
            if (!GrammarUtil.isEObjectRule(rule)) continue;
            return rule;
        }
        throw new RuntimeException("There is no parser rule in the grammar.");
    }

    protected void initConstraints() {
        if (this.constraintContexts == null) {
            this.constraints = Maps.newHashMap();
            this.constraintContexts = this.grammarConstraintProvider.getConstraints(this.grammar.getGrammar());
            for (IGrammarConstraintProvider.IConstraintContext ctx : this.constraintContexts) {
                for (IGrammarConstraintProvider.IConstraint constraint : ctx.getConstraints()) {
                    this.constraints.put(Tuples.create(ctx.getContext(), constraint.getType()), constraint);
                }
            }
        }
    }

    protected boolean intersect(Iterable<EObject> it1, Iterable<EObject> it2) {
        for (EObject i1 : it1) {
            for (EObject i2 : it2) {
                if (i1 != i2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isMandatory(IGrammarConstraintProvider.IFeatureInfo feature) {
        if (feature == null) {
            return false;
        }
        IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = feature.getAssignments();
        int n = iConstraintElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammarConstraintProvider.IConstraintElement ce = iConstraintElementArray[n2];
            if (!ce.isOptionalRecursive(null)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isValidValueQuantity(IGrammarConstraintProvider.IConstraint constraint, EObject semanicObj) {
        if (constraint == null) {
            return false;
        }
        int featureID = 0;
        while (featureID < semanicObj.eClass().getFeatureCount()) {
            IGrammarConstraintProvider.IFeatureInfo featureInfo = constraint.getFeatures()[featureID];
            EStructuralFeature structuralFeature = semanicObj.eClass().getEStructuralFeature(featureID);
            ITransientValueService.ValueTransient trans = this.transientValueUtil.isTransient(semanicObj, structuralFeature);
            if (trans == ITransientValueService.ValueTransient.NO && featureInfo == null) {
                return false;
            }
            if (trans == ITransientValueService.ValueTransient.YES && this.isMandatory(featureInfo)) {
                return false;
            }
            ++featureID;
        }
        return true;
    }
}

