/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedScope
extends AbstractScope {
    private Map<QualifiedName, IEObjectDescription> elements;

    public static IScope createScope(IScope parent, Iterable<IEObjectDescription> descriptions, boolean ignoreCase) {
        LinkedHashMap<QualifiedName, IEObjectDescription> map = null;
        for (IEObjectDescription description : descriptions) {
            QualifiedName name;
            IEObjectDescription previous;
            if (map == null) {
                map = new LinkedHashMap<QualifiedName, IEObjectDescription>(4);
            }
            if ((previous = map.put(name = ignoreCase ? description.getName().toLowerCase() : description.getName(), description)) == null) continue;
            map.put(name, previous);
        }
        if (map == null || map.isEmpty()) {
            return parent;
        }
        return new MapBasedScope(parent, (Map<QualifiedName, IEObjectDescription>)map, ignoreCase);
    }

    public static IScope createScope(IScope parent, Collection<IEObjectDescription> descriptions) {
        if (descriptions.size() == 1) {
            IEObjectDescription description = Iterables.getOnlyElement(descriptions);
            return new MapBasedScope(parent, Collections.singletonMap(description.getName(), description), false);
        }
        if (descriptions.isEmpty()) {
            return parent;
        }
        return MapBasedScope.createScope(parent, descriptions, false);
    }

    public static IScope createScope(IScope parent, Iterable<IEObjectDescription> descriptions) {
        return MapBasedScope.createScope(parent, descriptions, false);
    }

    protected MapBasedScope(IScope parent, Map<QualifiedName, IEObjectDescription> elements, boolean ignoreCase) {
        super(parent, ignoreCase);
        this.elements = elements;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return this.elements.values();
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        IEObjectDescription result = null;
        result = this.isIgnoreCase() ? this.elements.get(name.toLowerCase()) : this.elements.get(name);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(result);
    }

    @Override
    protected boolean isShadowed(IEObjectDescription fromParent) {
        if (this.isIgnoreCase()) {
            boolean result = this.elements.containsKey(fromParent.getName().toLowerCase());
            return result;
        }
        boolean result = this.elements.containsKey(fromParent.getName());
        return result;
    }
}

