/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.xtext.builder.trace.AbstractTrace;

public class ZipFileAwareTrace
extends AbstractTrace {
    private IProject project;
    private URI uri;
    private IPath zipFilePath;

    public IProject getLocalProject() {
        return this.project;
    }

    public URI getLocalURI() {
        return this.uri;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    protected void setUri(URI uri) {
        this.uri = uri;
    }

    protected IStorage findStorage(URI uri, IProject project) {
        return null;
    }

    protected void setZipFilePath(IPath zipFilePath) {
        this.zipFilePath = zipFilePath;
    }

    protected URI resolvePath(URI path) {
        IResource member = this.getWorkspace().getRoot().findMember(this.zipFilePath);
        if (member != null) {
            return URI.createURI("archive:platform:/resource" + member.getFullPath().toString() + "!/" + path);
        }
        return URI.createURI("archive:file:" + this.zipFilePath.toString() + "!/" + path);
    }

    protected InputStream getContents(URI uri, IProject project) throws CoreException {
        JavaModelManager modelManager = JavaModelManager.getJavaModelManager();
        ZipFile zipFile = modelManager.getZipFile(this.zipFilePath);
        try {
            ZipEntry zipEntry = zipFile.getEntry(uri.toString());
            if (zipEntry != null) {
                byte[] contents = Util.getZipEntryByteContent((ZipEntry)zipEntry, (ZipFile)zipFile);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents);
                return byteArrayInputStream;
            }
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "", e.getMessage(), e));
        }
        finally {
            modelManager.closeZipFile(zipFile);
        }
        return null;
    }
}

