/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.ImportDeclaration;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImportDeclaration
extends ImportDeclaration {
    public ExtensionImportDeclaration(Identifier importString) {
        super(importString);
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                return;
            }
            String importStringValue = this.getImportString().toString();
            XtendFile xf = (XtendFile)ctx.getResourceManager().loadResource(importStringValue, "ext");
            if (xf == null) {
                String msg = "Error while importing extension: Resource " + importStringValue + " not found.";
                issues.add(new AnalysationIssue(AnalysationIssue.RESOURCE_NOT_FOUND, msg, this));
            } else {
                HashSet<AnalysationIssue> tempIssues = new HashSet<AnalysationIssue>();
                xf.analyze(ctx, tempIssues);
                boolean noErrors = true;
                for (AnalysationIssue issue : tempIssues) {
                    if (!issue.isError()) continue;
                    noErrors = false;
                    break;
                }
                if (!noErrors) {
                    String msg = "Imported extension resource " + importStringValue + " has errors.";
                    issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, msg, this, true));
                }
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, null);
            }
        }
    }
}

