/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core;

import java.net.URL;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowContextDefaultImpl;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.MWEPlugin;
import org.eclipse.emf.mwe.internal.core.Workflow;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowFactory;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowEngine {
    private WorkflowContextDefaultImpl wfContext = new WorkflowContextDefaultImpl();
    private ProgressMonitor monitor;
    private static final Log logger = LogFactory.getLog(WorkflowEngine.class);
    private Map<String, String> params;
    private Workflow workflow;

    public boolean run(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams, Map<String, ?> externalSlotContents) {
        boolean configOK = this.prepare(workFlowFile, theMonitor, theParams);
        IssuesImpl issues = new IssuesImpl();
        if (configOK) {
            return this.executeWorkflow(externalSlotContents, issues);
        }
        return false;
    }

    public boolean prepare(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams) {
        IssuesImpl issues;
        block10: {
            if (workFlowFile == null) {
                throw new NullPointerException("workflowFile is null");
            }
            this.monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
            this.params = theParams;
            logger.info("--------------------------------------------------------------------------------------");
            logger.info("EMF Modeling Workflow Engine " + this.getVersion());
            logger.info("(c) 2005-2009 openarchitectureware.org and contributors");
            logger.info("--------------------------------------------------------------------------------------");
            logger.info("running workflow: " + workFlowFile);
            logger.info("");
            if (logger.isDebugEnabled() && !this.params.isEmpty()) {
                logger.debug("Params:" + this.params.toString());
            }
            issues = new IssuesImpl();
            try {
                WorkflowFactory factory = this.getWorkflowFactory();
                try {
                    this.workflow = factory.parseInitAndCreate(workFlowFile, this.params, this.getConverters(), issues);
                }
                catch (IllegalArgumentException illegalArg) {
                    if (illegalArg.getMessage().startsWith("Couldn't load file")) {
                        throw new ConfigurationException(illegalArg.getMessage());
                    }
                    throw illegalArg;
                }
                this.logIssues(logger, issues);
                if (!issues.hasErrors()) break block10;
                logger.error("Workflow interrupted because of configuration errors.");
                return false;
            }
            catch (ConfigurationException ex) {
                logger.fatal(ex.getMessage(), ex);
                this.logIssues(logger, issues);
                return false;
            }
        }
        if (this.workflow != null) {
            this.workflow.checkConfiguration(issues);
        }
        this.logIssues(logger, issues);
        if (issues.hasErrors()) {
            logger.error("Workflow interrupted because of configuration errors.");
            return false;
        }
        return true;
    }

    protected WorkflowFactory getWorkflowFactory() {
        return new WorkflowFactory();
    }

    private Map<Class<?>, Converter<?>> getConverters() {
        Map<Class<?>, Converter<?>> result = this.getCustomConverters();
        Map<Class<?>, Converter<?>> defaults = WorkflowFactory.getDefaultConverter();
        if (result == null) {
            result = defaults;
        } else {
            for (Map.Entry<Class<?>, Converter<?>> record : defaults.entrySet()) {
                if (result.containsKey(record.getKey())) continue;
                result.put(record.getKey(), record.getValue());
            }
        }
        return result;
    }

    protected Map<Class<?>, Converter<?>> getCustomConverters() {
        return null;
    }

    public boolean executeWorkflow(Map<?, ?> externalSlotContents, Issues issues) {
        try {
            this.wfContext = new WorkflowContextDefaultImpl();
            this.addExternalSlotContents(externalSlotContents);
            long time = System.currentTimeMillis();
            this.monitor.started(this.workflow, this.wfContext);
            this.workflow.invoke(this.wfContext, this.monitor, issues);
            this.monitor.finished(this.workflow, this.wfContext);
            long duration = System.currentTimeMillis() - time;
            logger.info("workflow completed in " + duration + "ms!");
            return issues.getErrors().length <= 0;
            {
            }
        }
        catch (Exception e) {
            if (e.getClass().getName().indexOf("Interrupt") > -1) {
                logger.error("Workflow interrupted. Reason: " + e.getMessage());
            } else {
                logger.error(e.getMessage(), e);
            }
        }
        finally {
            this.logIssues(logger, issues);
        }
        return false;
    }

    private void addExternalSlotContents(Map<?, ?> slotContents) {
        if (slotContents == null) {
            return;
        }
        for (Object name : slotContents.keySet()) {
            String key = (String)name;
            this.wfContext.set(key, slotContents.get(key));
        }
    }

    private void logIssues(Log logger, Issues issues) {
        MWEDiagnostic[] issueArray;
        MWEDiagnostic[] mWEDiagnosticArray = issueArray = issues.getIssues();
        int n = issueArray.length;
        int n2 = 0;
        while (n2 < n) {
            MWEDiagnostic issue = mWEDiagnosticArray[n2];
            if (issue.getSeverity() == 4) {
                logger.error(((Object)issue).toString());
            }
            if (issue.getSeverity() == 2) {
                logger.warn(((Object)issue).toString());
            }
            if (issue.getSeverity() == 1) {
                logger.info(((Object)issue).toString());
            }
            ++n2;
        }
    }

    public WorkflowContext getContext() {
        return this.wfContext;
    }

    private String getVersion() {
        try {
            URL url = new URL(MWEPlugin.INSTANCE.getBaseURL() + "META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            String version = manifest.getMainAttributes().getValue("Bundle-Version");
            int lastPoint = version.lastIndexOf(46);
            return String.valueOf(version.substring(0, lastPoint)) + ", Build " + version.substring(lastPoint + 1);
        }
        catch (Exception e) {
            logger.warn("Couldn't compute version of mwe.core bundle.", e);
            return "unkown version";
        }
    }
}

