/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.python;

import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;

public class PyUtils {
    static String deviceImpl() {
        return "PyTango.Device_4Impl";
    }

    String methodName(Command command) {
        if (command.getName().equals("State")) {
            return "dev_state";
        }
        if (command.getName().equals("Status")) {
            return "dev_status";
        }
        return command.getName();
    }

    String returnMethodCode(Command command) {
        if (command.getName().equals("State")) {
            return "if argout != PyTango.DevState.ALARM:\n    " + PyUtils.deviceImpl() + ".dev_state(self)\n" + "return self.get_state()";
        }
        if (command.getName().equals("Status")) {
            return "self.set_status(self.argout)\nself.__status = " + PyUtils.deviceImpl() + ".dev_status(self)\n" + "return self.__status";
        }
        if (!command.getArgout().getType().toString().contains("Void")) {
            return "return argout";
        }
        return "";
    }

    String addDynamicAttributeExample(PogoDeviceClass cls, Attribute attribute) {
        StringBuilder sb = new StringBuilder("self.add_attribute(");
        sb.append("my").append(attribute.getName()).append(",");
        if (StringUtils.isRead(attribute)) {
            sb.append(cls.getName()).append(".read_").append(attribute.getName());
        } else {
            sb.append("None");
        }
        sb.append(", ");
        if (StringUtils.isWrite(attribute)) {
            sb.append(cls.getName()).append(".write_").append(attribute.getName());
        } else {
            sb.append("None");
        }
        sb.append(", ");
        if (attribute.getReadExcludedStates().size() > 0) {
            sb.append(cls.getName()).append(".is_").append(attribute.getName()).append("_allowed");
        } else {
            sb.append("None");
        }
        sb.append(")");
        return sb.toString();
    }

    String methodTest(Command cmd, String defVal) {
        if (cmd.getName().equals("State")) {
            return "self.device.State()";
        }
        if (cmd.getName().equals("Status")) {
            return "self.device.Status()";
        }
        if (!cmd.getArgin().getType().equals("VoidTypeImpl")) {
            return "self.device." + cmd.getName() + "(" + defVal + ")";
        }
        return "self.device." + cmd.getName() + "()";
    }
}

