/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.html;

import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppTypeDefinitions;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.java.JavaTypeDefinitions;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.common.util.EList;

public class HtmlUtils
extends StringUtils {
    private static final String[] propertyHeaders = new String[]{"Name", "Description", "Type", "Default Value"};
    private static final String[] stateHeaders = new String[]{"Name", "Description"};
    private static final String[] commandHeaders = new String[]{"Name", "Input type", "Output type", "Level", "Description"};
    private static final String[] attributeHeaders = new String[]{"Name", "Inherited", "Abstract", "Attr. type", "R/W type", "Data type", "Level", "Description"};

    String getValue(String s) {
        if (HtmlUtils.isSet(s)) {
            return s;
        }
        return "Not set";
    }

    String htmlFileHeader(PogoDeviceClass cls) {
        return this.htmlFileHeader(cls, null);
    }

    String htmlFileHeader(PogoDeviceClass cls, String item) {
        String singleCote = "&lsquo;";
        String s = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<html>\n<head>\n<title> " + cls.getName() + " Tango Class ";
        s = item == null ? String.valueOf(s) + "User" + singleCote + "s Guide" : String.valueOf(s) + item;
        s = String.valueOf(s) + " </title>\n</head>\n<body text=\"Black\" bgcolor=\"White\" link=\"Blue\" vlink=\"Purple\" alink=\"Red\">\n";
        return s;
    }

    String htmlTitle(String text) {
        return "<font size=\"+1\"><u><b> " + text + " </b></u></font>";
    }

    String htmlPageTitle(String text) {
        return "<center><h2><u><b> " + text + " </b></u></h2></center>";
    }

    String htmlIdContact(ClassIdentification id) {
        return String.valueOf(id.getEmailDomain()) + " - " + id.getAuthor();
    }

    String htmlClassFamily(ClassIdentification id) {
        String s = id.getClassFamily();
        if (id.getSiteSpecific() == null || id.getSiteSpecific().length() == 0) {
            return s;
        }
        return String.valueOf(s) + "(specfic " + id.getSiteSpecific() + ")";
    }

    String htmlStringWithBreak(String s) {
        return this.htmlStringWithBreak(s, "");
    }

    String htmlStringWithBreak(String s, String tag) {
        return s.replaceAll("\n", "<Br>\n" + tag);
    }

    String htmlList2String(EList<String> list) {
        return this.htmlList2String(list, "");
    }

    String htmlList2String(EList<String> list, String tag) {
        if (list.size() == 0) {
            return "none";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String s : list) {
            if (list.size() < 6) {
                sb.append(s).append(" <br>");
                if (i++ >= list.size() - 1) continue;
                sb.append("\n" + tag);
                continue;
            }
            sb.append(s);
            if (i++ >= list.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    String htmlInheritance(PogoDeviceClass cls) {
        InheritanceUtils util = new InheritanceUtils();
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        String tangoDoc = "http://www.esrf.eu/computing/cs/tango/tango_doc/kernel_doc/";
        String language = cls.getDescription().getLanguage();
        if (language.toLowerCase().equals("cpp")) {
            tangoDoc = String.valueOf(tangoDoc) + "cpp_doc/";
        } else if (language.toLowerCase().equals("java")) {
            tangoDoc = String.valueOf(tangoDoc) + "tango_java_api/";
        } else if (language.toLowerCase().equals("java")) {
            tangoDoc = "http://www.tango-controls.org/static/PyTango/latest/doc/html/index.html";
        }
        StringBuffer sb = new StringBuffer("<ul><li> <a href=\"" + tangoDoc + "\" target=\"new\"> Tango::DeviceImpl</a></li>\n");
        if (inheritances != null) {
            int i = 0;
            while (i < inheritances.size()) {
                Inheritance inheritance = (Inheritance)inheritances.get(i);
                if (util.isInheritanceClass(inheritance)) {
                    sb.append("<ul> <li> ").append(inheritance.getClassname()).append("</li>\n");
                }
                ++i;
            }
            sb.append("<ul> <li> ").append(cls.getName()).append("</li>\n");
            i = 0;
            while (i < 6 - inheritances.size()) {
                sb.append("<br>\n");
                ++i;
            }
        } else {
            sb.append("<ul><li> ").append(cls.getName()).append(" <.li>\n</ul></ul>\n<br><br><br><br><br>");
        }
        return sb.toString();
    }

    String htmlTableHeader(String[] headers, String title) {
        StringBuffer sb = new StringBuffer("<Table Border=2 Cellpadding=3 CELLSPACING=0>\n");
        sb.append("\t<tr bgcolor=\"#CCCCFF\" class=\"TableHeadingColor\">\n");
        sb.append("\t<td colspan=" + headers.length + "> <font size=+1> <center><b> " + title);
        sb.append(" </b></font></center></td>\n");
        if (headers != null && headers.length > 0) {
            sb.append("\t<tr bgcolor=\"#CCCCFF\" class=\"TableHeadingColor\">\n");
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                sb.append(this.htmlTableCell("<center><b> " + header + " </b></center>"));
                ++n2;
            }
        }
        sb.append("\t</tr>\n");
        return sb.toString();
    }

    String htmlTableCell(String s) {
        return "\t\t<td> " + s + " </td>\n";
    }

    private String htmlTableCell(EList<String> list) {
        StringBuffer sb = new StringBuffer("<font size=\"-1\"> ");
        for (String str : list) {
            sb.append(" <li> ").append(str).append(" </li> ");
        }
        sb.append("</font>");
        return this.htmlTableCell(sb.toString());
    }

    String htmlTableLine(String[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t<tr>\n");
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(this.htmlTableCell(s));
            ++n2;
        }
        sb.append("\t</tr>\n");
        return sb.toString();
    }

    String htmlPropertyTable(EList<Property> properties, String title) {
        if (properties.size() == 0) {
            return this.htmlTitle("There is no " + title.toLowerCase());
        }
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(propertyHeaders, title));
        for (Property property : properties) {
            String desc = HtmlUtils.checkSpecialChars(property.getDescription());
            desc = this.htmlStringWithBreak(desc, "\t\t\t");
            String strType = JavaTypeDefinitions.javaPropType(property.getType());
            String defValues = this.htmlList2String(property.getDefaultPropValue(), "\t\t\t");
            sb.append(this.htmlTableLine(new String[]{property.getName(), desc, strType, HtmlUtils.checkSpecialChars(defValues)}));
        }
        sb.append("</table>");
        return sb.toString();
    }

    String htmlStatesTable(EList<State> states, String className) {
        if (states.size() == 0) {
            return this.htmlTitle("There is no state defined");
        }
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(stateHeaders, String.valueOf(className) + " Class States"));
        for (State state : states) {
            String desc = HtmlUtils.checkSpecialChars(state.getDescription());
            desc = this.htmlStringWithBreak(desc, "\t\t\t");
            sb.append(this.htmlTableLine(new String[]{state.getName(), desc}));
        }
        sb.append("</table>");
        return sb.toString();
    }

    String htmlCommandsTable(EList<Command> commands, String className) {
        if (commands.size() == 0) {
            return this.htmlTitle("There is no command defined.");
        }
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(commandHeaders, String.valueOf(className) + " Class Commands"));
        for (Command command : commands) {
            String name = "<a href=\"Cmd" + command.getName() + ".html\"> " + command.getName() + " </a>";
            String desc = HtmlUtils.checkSpecialChars(command.getDescription());
            if ((desc = this.htmlStringWithBreak(desc, "\t\t\t")).length() == 0) {
                desc = "None.";
            }
            String argin = CppTypeDefinitions.cppTypeEnum(command.getArgin().getType());
            String argout = CppTypeDefinitions.cppTypeEnum(command.getArgout().getType());
            if (argin.startsWith("Tango::")) {
                argin = argin.substring(7);
            }
            if (argout.startsWith("Tango::")) {
                argout = argout.substring(7);
            }
            sb.append(this.htmlTableLine(new String[]{name, argin, argout, command.getDisplayLevel(), desc}));
        }
        sb.append("</table>");
        return sb.toString();
    }

    String htmlOneCommandTable(Command command) {
        String argin = CppTypeDefinitions.cppTypeEnum(command.getArgin().getType());
        String argout = CppTypeDefinitions.cppTypeEnum(command.getArgout().getType());
        String abstr = HtmlUtils.isTrue(command.getStatus().getConcreteHere()) ? "false" : "true";
        String title = String.valueOf(command.getName()) + " Definition";
        String poll = "Not polled";
        if (HtmlUtils.isSet(command.getPolledPeriod()) && !command.getPolledPeriod().equals("0")) {
            poll = command.getPolledPeriod();
        }
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(new String[0], title));
        String arginDesc = HtmlUtils.checkSpecialChars(command.getArgin().getDescription());
        String argoutDesc = HtmlUtils.checkSpecialChars(command.getArgout().getDescription());
        sb.append(this.htmlTableLine(new String[]{"Input Argument", argin, this.htmlStringWithBreak(arginDesc)}));
        sb.append(this.htmlTableLine(new String[]{"Output Argument", argout, this.htmlStringWithBreak(argoutDesc)}));
        sb.append(this.htmlTableLine(new String[]{"DisplayLevel", command.getDisplayLevel(), ".."}));
        sb.append(this.htmlTableLine(new String[]{"Inherited", command.getStatus().getInherited(), ".."}));
        sb.append(this.htmlTableLine(new String[]{"Abstract", abstr, ".."}));
        sb.append(this.htmlTableLine(new String[]{"Polling Period", poll, ".."}));
        sb.append("<Tr BGCOLOR=\"#CCCCFF\"><Td><Hr></Td><Td><Hr></Td><Td><Hr></Td></Tr>\n");
        if (command.getExcludedStates().size() == 0) {
            sb.append(this.htmlTableLine(new String[]{"Command allowed for", "All states", ".."}));
        } else {
            sb.append("\t<tr>\n");
            sb.append(this.htmlTableCell("Command NOT allowed for"));
            sb.append(this.htmlTableCell(command.getExcludedStates()));
            sb.append(this.htmlTableCell(".."));
            sb.append("\t</tr>\n");
        }
        sb.append("</table>");
        return sb.toString();
    }

    String htmlAttributesTable(EList<Attribute> attributes, String className, boolean dynamic) {
        if (attributes.size() == 0) {
            if (dynamic) {
                return this.htmlTitle("There is no dynamic attribute defined.");
            }
            return this.htmlTitle("There is no attribute defined.");
        }
        String title = String.valueOf(className) + " Class" + (dynamic ? " Dynamic Attributes" : " Attributes");
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(attributeHeaders, title));
        for (Attribute attribute : attributes) {
            String name = "<a href=\"Attr" + attribute.getName() + ".html\"> " + attribute.getName() + " </a>";
            String desc = HtmlUtils.checkSpecialChars(attribute.getProperties().getDescription());
            desc = this.htmlStringWithBreak(desc, "\t\t\t");
            String dataType = CppTypeDefinitions.cppTypeEnum(attribute.getDataType());
            String abstr = HtmlUtils.isTrue(attribute.getStatus().getConcreteHere()) ? "false" : "true";
            sb.append(this.htmlTableLine(new String[]{name, attribute.getStatus().getInherited(), abstr, attribute.getAttType(), attribute.getRwType(), dataType, attribute.getDisplayLevel(), desc}));
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String attrSize(Attribute attribute) {
        if (attribute.getAttType().equals("Scalar")) {
            return "";
        }
        if (attribute.getAttType().equals("Spectrum")) {
            return "  ( " + attribute.getMaxX() + " )";
        }
        return "  ( " + attribute.getMaxX() + " x " + attribute.getMaxY() + " )";
    }

    String htmlOneAttributeDefinitionTable(Attribute attribute) {
        String title = "Attribute Definition";
        String dataType = CppTypeDefinitions.cppTypeEnum(attribute.getDataType());
        String abstr = HtmlUtils.isTrue(attribute.getStatus().getConcreteHere()) ? "false" : "true";
        String poll = "Not polled";
        if (HtmlUtils.isSet(attribute.getPolledPeriod()) && !attribute.getPolledPeriod().equals("0")) {
            poll = attribute.getPolledPeriod();
        }
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(new String[0], title));
        sb.append(this.htmlTableLine(new String[]{"Attribute Type", String.valueOf(attribute.getAttType()) + this.attrSize(attribute)}));
        sb.append(this.htmlTableLine(new String[]{"R/W Type", attribute.getRwType()}));
        sb.append(this.htmlTableLine(new String[]{"Data Type", dataType}));
        sb.append(this.htmlTableLine(new String[]{"Display Level", attribute.getDisplayLevel()}));
        sb.append(this.htmlTableLine(new String[]{"Inherited", attribute.getStatus().getInherited()}));
        sb.append(this.htmlTableLine(new String[]{"Abstract", abstr}));
        sb.append(this.htmlTableLine(new String[]{"Polling Period", poll}));
        sb.append(this.htmlTableLine(new String[]{"Memorized", this.getValue(attribute.getMemorized())}));
        if (HtmlUtils.isTrue(attribute.getMemorized())) {
            sb.append(this.htmlTableLine(new String[]{"Write hardware at init.", this.getValue(attribute.getMemorizedAtInit())}));
        }
        sb.append("<Tr BGCOLOR=\"#CCCCFF\"><Td><Hr></Td><Td><Hr></Td></Tr>\n");
        if (attribute.getRwType().contains("READ")) {
            if (attribute.getReadExcludedStates().size() == 0) {
                sb.append(this.htmlTableLine(new String[]{"Read allowed for", "All states"}));
            } else {
                sb.append("\t<tr>\n");
                sb.append(this.htmlTableCell("Read NOT allowed for"));
                sb.append(this.htmlTableCell(attribute.getReadExcludedStates()));
                sb.append("\t</tr>\n");
            }
        }
        if (attribute.getRwType().contains("WRITE")) {
            if (attribute.getWriteExcludedStates().size() == 0) {
                sb.append(this.htmlTableLine(new String[]{"Write allowed for", "All states"}));
            } else {
                sb.append("\t<tr>\n");
                sb.append(this.htmlTableCell("Write NOT allowed for"));
                sb.append(this.htmlTableCell(attribute.getWriteExcludedStates()));
                sb.append("\t</tr>\n");
            }
        }
        sb.append("</table>");
        return sb.toString();
    }

    String htmlOneAttributePropertiesTable(Attribute attribute) {
        String title = "Attribute Properties";
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(new String[0], title));
        AttrProperties properties = attribute.getProperties();
        sb.append(this.htmlTableLine(new String[]{"label", HtmlUtils.checkSpecialChars(properties.getLabel())}));
        sb.append(this.htmlTableLine(new String[]{"unit", properties.getUnit()}));
        sb.append(this.htmlTableLine(new String[]{"standard unit", properties.getStandardUnit()}));
        sb.append(this.htmlTableLine(new String[]{"display unit", properties.getDisplayUnit()}));
        sb.append(this.htmlTableLine(new String[]{"format", properties.getFormat()}));
        sb.append(this.htmlTableLine(new String[]{"max_value", properties.getMaxValue()}));
        sb.append(this.htmlTableLine(new String[]{"min_value", properties.getMinValue()}));
        sb.append(this.htmlTableLine(new String[]{"max_alarm", properties.getMaxAlarm()}));
        sb.append(this.htmlTableLine(new String[]{"min_alarm", properties.getMinAlarm()}));
        sb.append(this.htmlTableLine(new String[]{"max_warning", properties.getMaxWarning()}));
        sb.append(this.htmlTableLine(new String[]{"min_warning", properties.getMinWarning()}));
        sb.append(this.htmlTableLine(new String[]{"delta_time", properties.getDeltaTime()}));
        sb.append(this.htmlTableLine(new String[]{"delta_val", properties.getDeltaValue()}));
        sb.append("</table>");
        return sb.toString();
    }

    String htmlOneAttributeEventCriteriaTable(Attribute attribute) {
        EventCriteria evChangeCriteria = attribute.getEventCriteria();
        EventCriteria evArchiveCriteria = attribute.getEvArchiveCriteria();
        String title = "Attribute Event Criteria";
        StringBuffer sb = new StringBuffer(this.htmlTableHeader(new String[0], title));
        sb.append(this.htmlEventCriteriaLine(evChangeCriteria, "Periodic", 0));
        sb.append(this.htmlEventCriteriaLine(evChangeCriteria, "Relative Change", 1));
        sb.append(this.htmlEventCriteriaLine(evChangeCriteria, "Absolute Change", 2));
        sb.append("<Tr BGCOLOR=\"#CCCCFF\"><Td><Hr></Td><Td><Hr></Td></Tr>\n");
        sb.append(this.htmlEventCriteriaLine(evArchiveCriteria, "Archive Periodic", 0));
        sb.append(this.htmlEventCriteriaLine(evArchiveCriteria, "Archive Relative Change", 1));
        sb.append(this.htmlEventCriteriaLine(evArchiveCriteria, "Archive Absolute Change", 2));
        sb.append("<Tr BGCOLOR=\"#CCCCFF\"><Td><Hr></Td><Td><Hr></Td></Tr>\n");
        sb.append(this.htmlFireEventLine(attribute.getChangeEvent(), "Push Change event by user code", true));
        if (attribute.getChangeEvent() != null && HtmlUtils.isTrue(attribute.getChangeEvent().getFire())) {
            sb.append(this.htmlFireEventLine(attribute.getChangeEvent(), "<ul> Criteria checked by TANGO", false));
        }
        sb.append("<Tr BGCOLOR=\"#CCCCFF\"><Td> </Td><Td> </Td></Tr>\n");
        sb.append(this.htmlFireEventLine(attribute.getArchiveEvent(), "Push Archive event by user code", true));
        if (attribute.getArchiveEvent() != null && HtmlUtils.isTrue(attribute.getArchiveEvent().getFire())) {
            sb.append(this.htmlFireEventLine(attribute.getArchiveEvent(), "<ul> Criteria checked by TANGO", false));
        }
        sb.append("<Tr BGCOLOR=\"#CCCCFF\"><Td> </Td><Td> </Td></Tr>\n");
        sb.append(this.htmlFireEventLine(attribute.getDataReadyEvent(), "Push DataReady event by user code", true));
        if (attribute.getDataReadyEvent() != null && HtmlUtils.isTrue(attribute.getDataReadyEvent().getFire())) {
            sb.append(this.htmlFireEventLine(attribute.getDataReadyEvent(), "<li> Criteria checked by TANGO </li>", false));
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String htmlEventCriteriaLine(EventCriteria criteria, String text, int fieldNum) {
        String[] array = new String[]{text, "Not set"};
        if (criteria != null) {
            switch (fieldNum) {
                case 0: {
                    array[1] = this.getValue(criteria.getPeriod());
                    break;
                }
                case 1: {
                    array[1] = this.getValue(criteria.getRelChange());
                    break;
                }
                case 2: {
                    array[1] = this.getValue(criteria.getAbsChange());
                }
            }
        }
        return this.htmlTableLine(array);
    }

    private String htmlFireEventLine(FireEvents events, String text, boolean fire) {
        String[] array = new String[]{text, "Not set"};
        if (events != null) {
            array[1] = fire ? this.getValue(events.getFire()) : this.getValue(events.getLibCheckCriteria());
        }
        return this.htmlTableLine(array);
    }

    String htmlFullDocummentTitleAndContents(PogoDeviceClass cls) {
        StringBuffer sb = new StringBuffer(this.htmlPageTitle(String.valueOf(cls.getName()) + " Tango " + cls.getDescription().getLanguage() + " Class"));
        sb.append("\t<br><br>\n");
        sb.append("\t<ul>\n");
        sb.append("\t\t" + this.htmlTitle("Contents :"));
        sb.append("\n\t\t<ul>\n");
        sb.append("\t\t\t<li> <a href=\"FullDocument.html#description\">  Description  </a>\n");
        sb.append("\t\t\t<li> <a href=\"FullDocument.html#properties\">   Properties   </a>\n");
        sb.append("\t\t\t<li> <a href=\"FullDocument.html#commands\">     Commands     </a>\n");
        sb.append("\t\t\t<ul>\n");
        for (Command command : cls.getCommands()) {
            sb.append("\t\t\t\t<li> <a href=\"FullDocument.html#cmd" + command.getName() + "\"> " + command.getName() + " </a>\n");
        }
        sb.append("\t\t\t</ul>\n");
        sb.append("\t\t\t<li> <a href=\"FullDocument.html#attributes\">   Attributes   </a>\n");
        sb.append("\t\t\t<ul>\n");
        for (Attribute attribute : cls.getAttributes()) {
            sb.append("\t\t\t\t<li> <a href=\"FullDocument.html#attr" + attribute.getName() + "\"> " + attribute.getName() + " </a>\n");
        }
        for (Attribute attribute : cls.getDynamicAttributes()) {
            sb.append("\t\t\t\t<li> <a href=\"FullDocument.html#attr" + attribute.getName() + "\"> " + attribute.getName() + " (dynamic) </a>\n");
        }
        sb.append("\t\t\t</ul>\n");
        sb.append("\t\t\t<li> <a href=\"FullDocument.html#states\">       States       </a>\n");
        sb.append("\t\t</ul>\n");
        sb.append("\t</ul>\n");
        sb.append("\t<hr>\n");
        return sb.toString();
    }

    String addDescriptionFromPogo6IfExists(PogoDeviceClass cls) {
        String fileName = String.valueOf(cls.getDescription().getSourcePath()) + "/doc_html/Description.html";
        if (new File(fileName).exists()) {
            try {
                String code = HtmlUtils.readFile(fileName);
                int start = code.indexOf("user_guide.pdf");
                if (start > 0) {
                    start = code.indexOf("\n", start) + 1;
                } else {
                    start = code.toUpperCase().indexOf("<HR WIDTH=\"100%\">");
                    if (start > 0) {
                        start = code.indexOf("\n", start) + 1;
                    } else {
                        start = code.toUpperCase().indexOf("</TABLE>");
                        if (start > 0) {
                            start = code.indexOf("\n", start) + 1;
                        }
                    }
                }
                if (start > 0) {
                    int end = code.indexOf("<!--- html Footer --->", start);
                    if (end < 0) {
                        end = code.indexOf("ESRF - Software Engineering Group");
                        if (end < 0) {
                            return code.substring(start);
                        }
                        int end2 = code.toLowerCase().lastIndexOf("<center>", end);
                        if (end2 < 0) {
                            return code.substring(start, end);
                        }
                        return code.substring(start, end2);
                    }
                    return code.substring(start, end);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return "";
    }

    void retrieveProtectedDescriptionPart(PogoDeviceClass cls) {
        try {
            String fileName = String.valueOf(cls.getDescription().getSourcePath()) + "/doc_html/ClassDescription.html";
            String prText = this.getProtectedRegionContent(fileName, "./doc_html/index.html");
            if (prText != null) {
                fileName = String.valueOf(cls.getDescription().getSourcePath()) + "/doc_html/FullDocument.html";
                this.insertInProtectedRegion(fileName, "./doc_html/FullDocument.html", String.valueOf(prText) + " Added !!");
            }
        }
        catch (Exception e) {
            System.out.println("No Documentation.html file found !");
        }
    }

    static boolean isFromClasses2www() {
        String str = System.getenv("Classes2www");
        return str != null && str.equals("true");
    }

    static String generateHtmlTangoBannerFile() {
        String code = "";
        try {
            int end;
            String fullCode;
            int start;
            URL url = new URL("http://www.esrf.fr/computing/cs/tango/TangoBanner.html");
            InputStream inputStream = url.openStream();
            int nb = inputStream.available();
            byte[] inStr = new byte[nb];
            nb = inputStream.read(inStr);
            if (nb > 0 && (start = (fullCode = new String(inStr).toLowerCase()).indexOf("<table")) > 0 && (end = fullCode.indexOf("</body>")) > 0) {
                code = fullCode.substring(start, end);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    static String checkSpecialChars(String desc) {
        if (desc == null) {
            return "";
        }
        if (desc.isEmpty()) {
            return desc;
        }
        int pos = 0;
        while ((pos = desc.indexOf(38, pos)) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "&amp;" + desc.substring(pos + 1);
            pos += 2;
        }
        while ((pos = desc.indexOf(39)) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "`" + desc.substring(pos + 1);
        }
        while ((pos = desc.indexOf(34)) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "&quot;" + desc.substring(pos + 1);
        }
        while ((pos = desc.indexOf(" >")) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "&gt; " + desc.substring(pos + 2);
        }
        while ((pos = desc.indexOf("< ")) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "&lt; " + desc.substring(pos + 2);
        }
        while ((pos = desc.indexOf("/*")) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "/ *" + desc.substring(pos + 2);
        }
        while ((pos = desc.indexOf("*/")) >= 0) {
            desc = String.valueOf(desc.substring(0, pos)) + "* /" + desc.substring(pos + 2);
        }
        return desc;
    }
}

