/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.State;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class DeviceStateMachine {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;

    public CharSequence generateStateMachineSourceFile(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fileHeader = this.fileHeader(cls);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<State> _states = cls.getStates();
        String _statesTable = CppStringUtils.statesTable(_states);
        _builder.append((Object)_statesTable, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("_ns");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("//=================================================");
        _builder.newLine();
        _builder.append("//\t\tAttributes Allowed Methods");
        _builder.newLine();
        _builder.append("//=================================================");
        _builder.newLine();
        CharSequence _attributesStateMachine = this.attributesStateMachine(cls);
        _builder.append((Object)_attributesStateMachine, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<Pipe> _pipes = cls.getPipes();
        int _size = _pipes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("//=================================================");
            _builder.newLine();
            _builder.append("//\t\tpipe Allowed Methods");
            _builder.newLine();
            _builder.append("//=================================================");
            _builder.newLine();
            CharSequence _pipeStateMachine = this.pipeStateMachine(cls);
            _builder.append((Object)_pipeStateMachine, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("//=================================================");
        _builder.newLine();
        _builder.append("//\t\tCommands Allowed Methods");
        _builder.newLine();
        _builder.append("//=================================================");
        _builder.newLine();
        CharSequence _commandsStateMachine = this.commandsStateMachine(cls);
        _builder.append((Object)_commandsStateMachine, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        String _name_1 = cls.getName();
        String _plus = String.valueOf(_name_1) + "StateAllowed";
        String _plus_1 = String.valueOf(_plus) + ".AdditionalMethods";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1, "Additional Methods", true);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}\t//\tEnd of namespace");
        _builder.newLine();
        return _builder;
    }

    public CharSequence fileHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = cls.getName();
        String _plus = String.valueOf(_name) + "StateMachine";
        String _openProtectedArea = this._protectedArea.openProtectedArea(_plus, ".cpp");
        _builder.append((Object)_openProtectedArea, "");
        _builder.newLineIfNotEmpty();
        String _stateMachineFileHeader = this._headers.stateMachineFileHeader(cls);
        _builder.append((Object)_stateMachineFileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append(".h>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _stateMachineFileName = this._headers.stateMachineFileName(cls);
        String _closeProtectedArea = this._protectedArea.closeProtectedArea(cls, _stateMachineFileName);
        _builder.append((Object)_closeProtectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence commandsStateMachine(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _commands = cls.getCommands();
        for (Command command : _commands) {
            boolean _equals_4;
            String _name_1;
            boolean _equals_2;
            boolean _equals_3;
            boolean _equals_1;
            boolean _and = false;
            String _name = command.getName();
            boolean _equals = _name.equals("State");
            boolean bl = _equals_1 = !_equals;
            _and = !_equals_1 ? false : (_equals_3 = !(_equals_2 = (_name_1 = command.getName()).equals("Status")));
            if (!_and) continue;
            boolean _overrides = this._inheritanceUtils.overrides(command);
            boolean bl2 = _equals_4 = !_overrides;
            if (!_equals_4) continue;
            CharSequence _commandStateMachine = this.commandStateMachine(cls, command);
            _builder.append((Object)_commandStateMachine, "");
            _builder.newLineIfNotEmpty();
        }
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        for (Command command_1 : _dynamicCommands) {
            boolean _equals_5;
            boolean _overrides_1 = this._inheritanceUtils.overrides(command_1);
            boolean bl = _equals_5 = !_overrides_1;
            if (!_equals_5) continue;
            CharSequence _commandStateMachine_1 = this.commandStateMachine(cls, command_1);
            _builder.append((Object)_commandStateMachine_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence commandStateMachine(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _name = command.getName();
        String _plus = "is_" + _name;
        String _plus_1 = String.valueOf(_plus) + "_allowed";
        String _name_1 = command.getName();
        String _plus_2 = "Execution allowed for " + _name_1;
        String _plus_3 = String.valueOf(_plus_2) + " attribute";
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, _plus_1, _plus_3);
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append("bool ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("::is_");
        String _name_3 = command.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("_allowed(TANGO_UNUSED(const CORBA::Any &any))");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        EList<String> _excludedStates = command.getExcludedStates();
        boolean _isEmpty = _excludedStates.isEmpty();
        if (_isEmpty) {
            _builder.append("\t");
            _builder.append("//\tNot any excluded states for ");
            String _name_4 = command.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append(" command.");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name_5 = command.getName();
            String _plus_4 = String.valueOf(_name_5) + "StateAllowed";
            String _protectedArea = this._protectedArea.protectedArea(cls, _plus_4);
            _builder.append((Object)_protectedArea, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("//\tCompare device state with not allowed states.");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (");
            EList<String> _excludedStates_1 = command.getExcludedStates();
            String _ifContentFromList = this._cppStringUtils.ifContentFromList(_excludedStates_1);
            _builder.append((Object)_ifContentFromList, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            String _name_6 = command.getName();
            String _plus_5 = String.valueOf(_name_6) + "StateAllowed";
            String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_5);
            _builder.append((Object)_protectedArea_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributesStateMachine(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attribute : _attributes) {
            boolean _equals;
            boolean _alreadyOverloaded = this._inheritanceUtils.alreadyOverloaded(attribute);
            boolean bl = _equals = !_alreadyOverloaded;
            if (!_equals) continue;
            CharSequence _attributeStateMachine = this.attributeStateMachine(cls, attribute);
            _builder.append((Object)_attributeStateMachine, "");
            _builder.newLineIfNotEmpty();
        }
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attribute_1 : _dynamicAttributes) {
            CharSequence _attributeStateMachine_1 = this.attributeStateMachine(cls, attribute_1);
            _builder.append((Object)_attributeStateMachine_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeStateMachine(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _name = attribute.getName();
        String _plus = "is_" + _name;
        String _plus_1 = String.valueOf(_plus) + "_allowed";
        String _name_1 = attribute.getName();
        String _plus_2 = "Execution allowed for " + _name_1;
        String _plus_3 = String.valueOf(_plus_2) + " attribute";
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, _plus_1, _plus_3);
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append("bool ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("::is_");
        String _name_3 = attribute.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("_allowed(TANGO_UNUSED(Tango::AttReqType type))");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        boolean _isWrite = StringUtils.isWrite(attribute);
        if (_isWrite) {
            EList<String> _writeExcludedStates = attribute.getWriteExcludedStates();
            boolean _isEmpty = _writeExcludedStates.isEmpty();
            if (_isEmpty) {
                _builder.append("\t");
                _builder.append("//\tNot any excluded states for ");
                String _name_4 = attribute.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append(" attribute in Write access.");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _name_5 = attribute.getName();
                String _plus_4 = String.valueOf(_name_5) + "StateAllowed_WRITE";
                String _protectedArea = this._protectedArea.protectedArea(cls, _plus_4);
                _builder.append((Object)_protectedArea, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("//\tCheck access type.");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if ( type!=Tango::READ_REQ )");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("//\tCompare device state with not allowed states for WRITE ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (");
                EList<String> _writeExcludedStates_1 = attribute.getWriteExcludedStates();
                String _ifContentFromList = this._cppStringUtils.ifContentFromList(_writeExcludedStates_1);
                _builder.append((Object)_ifContentFromList, "\t\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _name_6 = attribute.getName();
                String _plus_5 = String.valueOf(_name_6) + "StateAllowed_WRITE";
                String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_5);
                _builder.append((Object)_protectedArea_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return true;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                boolean _isRead = StringUtils.isRead(attribute);
                if (_isRead) {
                    _builder.append("\t");
                    _builder.append("else");
                    _builder.newLine();
                }
            }
        }
        _builder.newLine();
        boolean _isRead_1 = StringUtils.isRead(attribute);
        if (_isRead_1) {
            EList<String> _readExcludedStates = attribute.getReadExcludedStates();
            boolean _isEmpty_1 = _readExcludedStates.isEmpty();
            if (_isEmpty_1) {
                _builder.append("\t");
                _builder.append("//\tNot any excluded states for ");
                String _name_7 = attribute.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append(" attribute in read access.");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _name_8 = attribute.getName();
                String _plus_6 = String.valueOf(_name_8) + "StateAllowed_READ";
                String _protectedArea_2 = this._protectedArea.protectedArea(cls, _plus_6);
                _builder.append((Object)_protectedArea_2, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("//\tCheck access type.");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if ( type==Tango::READ_REQ )");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("//\tCompare device state with not allowed states for READ ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (");
                EList<String> _readExcludedStates_1 = attribute.getReadExcludedStates();
                String _ifContentFromList_1 = this._cppStringUtils.ifContentFromList(_readExcludedStates_1);
                _builder.append((Object)_ifContentFromList_1, "\t\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _name_9 = attribute.getName();
                String _plus_7 = String.valueOf(_name_9) + "StateAllowed_READ";
                String _protectedArea_3 = this._protectedArea.protectedArea(cls, _plus_7);
                _builder.append((Object)_protectedArea_3, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return true;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence pipeStateMachine(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Pipe> _pipes = cls.getPipes();
        for (Pipe pipe : _pipes) {
            EList<String> _readExcludedStates;
            boolean _isEmpty_1;
            String _name = pipe.getName();
            String _plus = "is_" + _name;
            String _plus_1 = String.valueOf(_plus) + "_allowed";
            String _name_1 = pipe.getName();
            String _plus_2 = "Execution allowed for " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " pipe";
            String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, _plus_1, _plus_3);
            _builder.append((Object)_simpleMethodHeader, "");
            _builder.newLineIfNotEmpty();
            _builder.append("bool ");
            String _name_2 = cls.getName();
            _builder.append((Object)_name_2, "");
            _builder.append("::is_");
            String _name_3 = pipe.getName();
            _builder.append((Object)_name_3, "");
            _builder.append("_allowed(TANGO_UNUSED(Tango::PipeReqType type))");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            String _rwType = pipe.getRwType();
            boolean _contains = _rwType.contains("WRITE");
            if (_contains) {
                EList<String> _writeExcludedStates = pipe.getWriteExcludedStates();
                boolean _isEmpty = _writeExcludedStates.isEmpty();
                if (_isEmpty) {
                    _builder.append("\t");
                    _builder.append("//\tNot any excluded states for ");
                    String _name_4 = pipe.getName();
                    _builder.append((Object)_name_4, "\t");
                    _builder.append(" pipe in Write access.");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _name_5 = pipe.getName();
                    String _plus_4 = String.valueOf(_name_5) + "StateAllowed_WRITE";
                    String _protectedArea = this._protectedArea.protectedArea(cls, _plus_4);
                    _builder.append((Object)_protectedArea, "\t");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("//\tCheck access type.");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("if ( type==Tango::WRITE_REQ )");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("//\tCompare device state with not allowed states for WRITE ");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (");
                    EList<String> _writeExcludedStates_1 = pipe.getWriteExcludedStates();
                    String _ifContentFromList = this._cppStringUtils.ifContentFromList(_writeExcludedStates_1);
                    _builder.append((Object)_ifContentFromList, "\t\t");
                    _builder.append(")");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    String _name_6 = pipe.getName();
                    String _plus_5 = String.valueOf(_name_6) + "StateAllowed_WRITE";
                    String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_5);
                    _builder.append((Object)_protectedArea_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("return false;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return true;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("else");
                    _builder.newLine();
                }
            }
            if (_isEmpty_1 = (_readExcludedStates = pipe.getReadExcludedStates()).isEmpty()) {
                _builder.append("\t");
                _builder.append("//\tNot any excluded states for ");
                String _name_7 = pipe.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append(" pipe in read access.");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _name_8 = pipe.getName();
                String _plus_6 = String.valueOf(_name_8) + "StateAllowed_READ";
                String _protectedArea_2 = this._protectedArea.protectedArea(cls, _plus_6);
                _builder.append((Object)_protectedArea_2, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("//\tCheck access type.");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if ( type==Tango::READ_REQ )");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("//\tCompare device state with not allowed states for READ ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (");
                EList<String> _readExcludedStates_1 = pipe.getReadExcludedStates();
                String _ifContentFromList_1 = this._cppStringUtils.ifContentFromList(_readExcludedStates_1);
                _builder.append((Object)_ifContentFromList_1, "\t\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _name_9 = pipe.getName();
                String _plus_7 = String.valueOf(_name_9) + "StateAllowed_READ";
                String _protectedArea_3 = this._protectedArea.protectedArea(cls, _plus_7);
                _builder.append((Object)_protectedArea_3, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("return true;");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }
}

