/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import pogo.appli.MultiLineCellRenderer;

public class MultiLineCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    MyTextArea textArea;
    JTable table;

    public MultiLineCellEditor(JTable ta) {
        this.table = ta;
        MultiLineCellRenderer renderer = new MultiLineCellRenderer();
        this.table.setDefaultRenderer(String.class, renderer);
        this.textArea = new MyTextArea();
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    private int cellHeight(int row, int col) {
        if (row == this.table.getEditingRow() && col == this.table.getEditingColumn()) {
            return this.textArea.getPreferredSize().height;
        }
        return this.table.getDefaultRenderer(String.class).getTableCellRendererComponent((JTable)this.table, (Object)this.table.getModel().getValueAt((int)row, (int)col), (boolean)false, (boolean)false, (int)row, (int)col).getPreferredSize().height;
    }

    void updateRow(int row) {
        int maxHeight = 1;
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            int ch = this.cellHeight(row, j);
            if (ch <= maxHeight) continue;
            maxHeight = ch;
        }
        this.table.setRowHeight(row, maxHeight);
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textArea.rowEditing = row;
        this.textArea.columnEditing = column;
        this.textArea.setEditable(column != 0);
        this.textArea.ingoreChange = true;
        this.textArea.setText(table.getValueAt(row, column).toString());
        this.textArea.ingoreChange = false;
        return this.textArea;
    }

    class MyTextArea
    extends JTextArea
    implements DocumentListener {
        boolean ingoreChange = true;
        int rowEditing;
        int columnEditing;

        MyTextArea() {
            this.getDocument().addDocumentListener(this);
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent e) {
                    MyTextArea.this.requestFocus();
                }

                @Override
                public void ancestorMoved(AncestorEvent e) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent e) {
                }
            });
        }

        public void updateField() {
            if (!this.ingoreChange) {
                MultiLineCellEditor.this.table.setValueAt(this.getText(), this.rowEditing, this.columnEditing);
                MultiLineCellEditor.this.updateRow(this.rowEditing);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateField();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateField();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

