/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.JOptionPane;
import pogo.appli.GenerateDialog;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoGeneJava;
import pogo.gene.PogoGenePython;

public class GenerateThread
extends Thread
implements PogoDefs,
PogoAppliDefs {
    private PogoClass pogo;
    private int item;
    private PogoAppli parent;
    private GenerateDialog dialog;
    private int exiting;

    public GenerateThread(PogoAppli parent, PogoClass pogo, int item, int exiting) {
        this.parent = parent;
        this.pogo = pogo;
        this.item = item;
        this.exiting = exiting;
        int ratio = item == 1 && pogo.language == 0 ? 7 : 20;
        this.dialog = new GenerateDialog((Frame)parent, ratio);
    }

    @Override
    public void run() {
        try {
            switch (this.item) {
                case 0: {
                    if (this.pogo.language == 2) {
                        PogoGenePython gene = new PogoGenePython(this.pogo);
                        gene.generate();
                        this.dialog.stop();
                        if (this.exiting == 1) {
                            JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                        }
                        break;
                    }
                    if (this.pogo.language == 0) {
                        PogoGeneJava gene = new PogoGeneJava(this.pogo);
                        gene.generate(this.item);
                        this.dialog.stop();
                        if (this.exiting == 1) {
                            JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                        }
                        break;
                    }
                    if (this.pogo.language == 1) {
                        PogoGeneCpp gene = new PogoGeneCpp(this.pogo);
                        gene.generate(this.item);
                        this.dialog.stop();
                        if (this.exiting == 1) {
                            JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                        }
                        break;
                    }
                    PopupError.show((Component)this.parent, "Language not supported.");
                    break;
                }
                case 2: 
                case 3: {
                    if (this.pogo.language == 2) {
                        this.dialog.stop();
                        PopupError.show((Component)this.parent, "No Makefile for python language.");
                        break;
                    }
                    if (this.pogo.language == 0) {
                        PogoGeneJava gene = new PogoGeneJava(this.pogo);
                        gene.generate(this.item);
                        this.dialog.stop();
                        JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                        break;
                    }
                    if (this.pogo.language != 1) break;
                    PogoGeneCpp gene = new PogoGeneCpp(this.pogo);
                    gene.generate(this.item);
                    this.dialog.stop();
                    JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                    break;
                }
                case 1: {
                    new PogoGeneDoc(this.pogo).generate();
                    this.dialog.stop();
                    if (this.exiting != 1) break;
                    JOptionPane.showMessageDialog(this.parent, "Html Documentation Generated in :\n" + this.pogo.projectFiles.getDocHtml(), "Message Window", 1);
                }
            }
        }
        catch (Exception ex) {
            this.dialog.stop();
            if (this.exiting == 1) {
                JOptionPane.showMessageDialog(this.parent, ex.toString(), "Error Window", 0);
            }
            ex.printStackTrace();
        }
        this.parent.setCursor(new Cursor(0));
    }
}

