/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class StateDialog
extends JDialog {
    private JTextArea descText;
    private JComboBox<String> typeComboBox;
    private PogoGUI pogo_gui;
    private InheritanceStatus orig_status;
    private int retVal = 0;
    private static int[] columnSize = new int[]{140, 40, 400};
    private static String[] columnTitle = new String[]{"Name", "Inherited", "Description"};

    public StateDialog(PogoGUI pogoGUI, State state) {
        super((Frame)pogoGUI, true);
        this.pogo_gui = pogoGUI;
        this.initComponents();
        ComboBoxRenderer comboBoxRenderer = new ComboBoxRenderer();
        this.typeComboBox.setRenderer(comboBoxRenderer);
        for (String string : TangoConst.Tango_DevStateName) {
            this.typeComboBox.addItem(string);
        }
        this.setState(state);
        this.manageInheritanceStatus(state);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void manageInheritanceStatus(State state) {
        if (state != null) {
            this.orig_status = state.getStatus();
            if (Utils.isTrue(this.orig_status.getInherited())) {
                this.setEditable(false);
            } else {
                this.setEditable(true);
            }
        } else {
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
        }
    }

    private void setNotEditable(JComboBox<String> jComboBox) {
        String string = (String)jComboBox.getSelectedItem();
        if (string != null) {
            jComboBox.removeAllItems();
            jComboBox.addItem(string);
        }
    }

    private void setEditable(boolean bl) {
        if (!bl) {
            this.setNotEditable(this.typeComboBox);
        }
    }

    private void initComponents() {
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Edit State Window");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StateDialog.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        JButton jButton = new JButton();
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.setText("Cancel");
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("State Name:    ");
        jLabel.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(" ");
        jLabel2.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("State Description:  ");
        jLabel3.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.descText = new JTextArea();
        this.descText.setColumns(80);
        this.descText.setPreferredSize(new Dimension(1000, 400));
        this.descText.setMinimumSize(new Dimension(0, 100));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(500, 150));
        jScrollPane.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        this.typeComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel2.add(this.typeComboBox, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose(2);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.typeComboBox.getSelectedItem().toString();
            if (this.pogo_gui.itemAlreadyExists(string, 8)) {
                throw new PogoException("State \"" + string + "\" Already Exists !");
            }
            this.doClose(0);
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(2);
    }

    private void doClose(int n) {
        this.retVal = n;
        this.setVisible(false);
        this.dispose();
    }

    private void setState(State state) {
        if (state != null) {
            for (String string : TangoConst.Tango_DevStateName) {
                if (!string.equals(state.getName())) continue;
                this.typeComboBox.setSelectedItem(string);
            }
            this.descText.setText(state.getDescription());
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public State getState() {
        State state = OAWutils.factory.createState();
        state.setName(this.typeComboBox.getSelectedItem().toString());
        state.setDescription(Utils.strReplaceSpecialCharToCode(this.descText.getText()));
        state.setStatus(this.orig_status);
        return state;
    }

    public static State cloneState(State state) {
        State state2 = OAWutils.cloneState(state);
        InheritanceStatus inheritanceStatus = state2.getStatus();
        if (!Utils.isTrue(inheritanceStatus.getAbstract())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        if (Utils.isTrue(inheritanceStatus.getInherited())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        state2.setStatus(inheritanceStatus);
        return state2;
    }

    public static void popupSummary(JFrame jFrame, ArrayList<State> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = StateDialog.buildSummary(arrayList);
        String string = Integer.toString(arrayList.size()) + "  States";
        PopupTable popupTable = new PopupTable(jFrame, string, columnTitle, arrayList2);
        popupTable.setPreferredSize(columnSize, arrayList.size());
        popupTable.setVisible(true);
    }

    private static ArrayList<ArrayList<String>> buildSummary(ArrayList<State> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        for (State state : arrayList) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(state.getName());
            InheritanceStatus inheritanceStatus = state.getStatus();
            arrayList3.add(Utils.strBoolean(inheritanceStatus.getInherited()));
            arrayList3.add(Utils.strReplace(state.getDescription(), "\\n", "\n"));
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }

    private class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(Utils.getColor4State(string).darker());
                this.setForeground(Utils.getForeground4State(string));
            } else {
                this.setBackground(Utils.getColor4State(string));
                this.setForeground(Utils.getForeground4State(string));
            }
            jList.setSelectionBackground(Utils.getColor4State(string));
            jList.setSelectionForeground(Utils.getForeground4State(string));
            return this;
        }
    }
}

