/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public class ToStringHelper {
    private static final ThreadLocal<IdentityHashMap<Object, Boolean>> currentlyProcessed = new ThreadLocal<IdentityHashMap<Object, Boolean>>(){

        @Override
        protected IdentityHashMap<Object, Boolean> initialValue() {
            return new IdentityHashMap<Object, Boolean>();
        }
    };

    private static boolean startProcessing(Object x) {
        IdentityHashMap<Object, Boolean> identityHashMap = currentlyProcessed.get();
        return identityHashMap.put(x, Boolean.TRUE) == null;
    }

    private static void endProcessing(Object x) {
        IdentityHashMap<Object, Boolean> identityHashMap = currentlyProcessed.get();
        identityHashMap.remove(x);
    }

    public String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> clazz = obj.getClass();
        if (!ToStringHelper.startProcessing(obj)) {
            return this.toSimpleReferenceString(obj);
        }
        try {
            List<Field> fields = this.getAllDeclaredFields(clazz);
            IndentationAwareStringBuilder sb = new IndentationAwareStringBuilder();
            sb.append(clazz.getSimpleName()).append(" [").increaseIndent();
            for (Field f : fields) {
                this.addField(f, obj, sb);
            }
            sb.decreaseIndent();
            if (!fields.isEmpty()) {
                sb.newLine();
            }
            sb.append("]");
            String string = sb.toString();
            return string;
        }
        finally {
            ToStringHelper.endProcessing(obj);
        }
    }

    private String toSimpleReferenceString(Object obj) {
        return String.valueOf(obj.getClass().getSimpleName()) + "@" + System.identityHashCode(obj);
    }

    protected void addField(Field field, Object obj, IndentationAwareStringBuilder sb) {
        if (!Modifier.isStatic(field.getModifiers())) {
            try {
                field.setAccessible(true);
                Object value = field.get(obj);
                sb.newLine().append(field.getName()).append(" = ");
                this.internalToString(value, sb);
            }
            catch (Exception e) {
                sb.append(" // ERROR problems serializing field " + field.getName() + " : " + e.getClass().getSimpleName());
            }
        }
    }

    protected void internalToString(Object object, IndentationAwareStringBuilder sb) {
        if (object == null) {
            sb.append("null");
        } else if (object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            String simpleName = object.getClass().isAnonymousClass() ? "AnonymousIterable" : object.getClass().getSimpleName();
            sb.append(simpleName).append(" (");
            sb.increaseIndent();
            boolean wasEmpty = true;
            while (iterator.hasNext()) {
                wasEmpty = false;
                sb.newLine();
                this.internalToString(iterator.next(), sb);
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.decreaseIndent();
            if (!wasEmpty) {
                sb.newLine();
            }
            sb.append(")");
        } else if (object instanceof Object[]) {
            sb.append(Arrays.toString((Object[])object));
        } else if (object instanceof byte[]) {
            sb.append(Arrays.toString((byte[])object));
        } else if (object instanceof char[]) {
            sb.append(Arrays.toString((char[])object));
        } else if (object instanceof int[]) {
            sb.append(Arrays.toString((int[])object));
        } else if (object instanceof boolean[]) {
            sb.append(Arrays.toString((boolean[])object));
        } else if (object instanceof long[]) {
            sb.append(Arrays.toString((long[])object));
        } else if (object instanceof float[]) {
            sb.append(Arrays.toString((float[])object));
        } else if (object instanceof double[]) {
            sb.append(Arrays.toString((double[])object));
        } else if (object instanceof CharSequence) {
            sb.append("\"").append(object.toString().replace("\n", "\\n")).append("\"");
        } else if (object instanceof Enum) {
            sb.append(((Enum)object).name());
        } else {
            sb.append(object.toString());
        }
    }

    protected List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        do {
            Collections.addAll(result, clazz.getDeclaredFields());
        } while ((clazz = clazz.getSuperclass()) != null);
        return result;
    }

    private static class IndentationAwareStringBuilder {
        private StringBuilder builder = new StringBuilder();
        private int indentation = 0;
        private String indentationString = "  ";
        private String newLineString = "\n";

        private IndentationAwareStringBuilder() {
        }

        public IndentationAwareStringBuilder increaseIndent() {
            ++this.indentation;
            return this;
        }

        public IndentationAwareStringBuilder decreaseIndent() {
            --this.indentation;
            return this;
        }

        public IndentationAwareStringBuilder append(CharSequence string) {
            if (this.indentation > 0) {
                String replacement = String.valueOf(this.newLineString) + Strings.repeat(this.indentationString, this.indentation);
                String indented = string.toString().replace(this.newLineString, replacement);
                this.builder.append(indented);
            } else {
                this.builder.append(string);
            }
            return this;
        }

        public IndentationAwareStringBuilder newLine() {
            this.builder.append(this.newLineString).append(Strings.repeat(this.indentationString, this.indentation));
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

