/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.validation.CheckType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidationDiagnostic
implements Diagnostic {
    private final String message;
    private final EObject source;
    private final int severity;
    private final CheckType checkType;
    private final String issueCode;
    private final String[] issueData;

    protected AbstractValidationDiagnostic(int severity, String message, EObject source, CheckType checkType, String issueCode, String ... issueData) {
        if (Arrays.contains(issueData, null)) {
            throw new NullPointerException("issueData may not contain null");
        }
        this.source = source;
        this.severity = severity;
        this.message = message;
        this.issueCode = issueCode;
        this.checkType = checkType;
        this.issueData = issueData;
    }

    @Override
    public List<Diagnostic> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int getCode() {
        return 0;
    }

    @Override
    public String getSource() {
        return this.source == null ? "" : this.source.toString();
    }

    public EObject getSourceEObject() {
        return this.source;
    }

    @Override
    public Throwable getException() {
        return null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public String getIssueCode() {
        return this.issueCode;
    }

    public String[] getIssueData() {
        return this.issueData;
    }

    public CheckType getCheckType() {
        return this.checkType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Diagnostic ");
        result.append(AbstractValidationDiagnostic.severityToStr(this.severity));
        if (this.issueCode != null) {
            result.append(" code=");
            result.append(this.issueCode);
        }
        result.append(" \"");
        result.append(this.message);
        result.append("\"");
        if (this.getSourceEObject() != null) {
            result.append(" at ");
            result.append(EmfFormatter.objPath(this.getSourceEObject()));
        }
        return result.toString();
    }

    public static String severityToStr(int severity) {
        switch (severity) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
        }
        return Integer.toHexString(severity);
    }
}

