/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.SimpleAttributeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scopes {
    public static Iterable<IEObjectDescription> selectCompatible(Iterable<IEObjectDescription> exportedObjects, final EClass clazz) {
        return Iterables.filter(exportedObjects, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                return EcoreUtil2.isAssignableFrom(clazz, input.getEClass());
            }
        });
    }

    public static IScope scopeFor(Iterable<? extends EObject> elements) {
        return Scopes.scopeFor(elements, IScope.NULLSCOPE);
    }

    public static IScope scopeFor(Iterable<? extends EObject> elements, IScope outer) {
        return Scopes.scopeFor(elements, QualifiedName.wrapper(SimpleAttributeResolver.NAME_RESOLVER), outer);
    }

    public static <T extends EObject> IScope scopeFor(Iterable<? extends T> elements, Function<T, QualifiedName> nameComputation, IScope outer) {
        return new SimpleScope(outer, Scopes.scopedElementsFor(elements, nameComputation));
    }

    public static Iterable<IEObjectDescription> scopedElementsFor(Iterable<? extends EObject> elements) {
        return Scopes.scopedElementsFor(elements, QualifiedName.wrapper(SimpleAttributeResolver.NAME_RESOLVER));
    }

    public static <T extends EObject> Iterable<IEObjectDescription> scopedElementsFor(Iterable<? extends T> elements, final Function<T, QualifiedName> nameComputation) {
        Iterable transformed = Iterables.transform(elements, new Function<T, IEObjectDescription>(){

            @Override
            public IEObjectDescription apply(T from) {
                QualifiedName qualifiedName = (QualifiedName)nameComputation.apply(from);
                if (qualifiedName != null) {
                    return new EObjectDescription(qualifiedName, (EObject)from, null);
                }
                return null;
            }
        });
        return Iterables.filter(transformed, Predicates.notNull());
    }

    public static <T> Multimap<T, IEObjectDescription> index(Iterable<IEObjectDescription> descriptions, Function<IEObjectDescription, T> indexer) {
        ArrayList<IEObjectDescription> list = Lists.newArrayList(descriptions);
        LinkedHashMultimap multimap = LinkedHashMultimap.create(list.size(), 1);
        for (IEObjectDescription desc : list) {
            multimap.put(indexer.apply(desc), desc);
        }
        return multimap;
    }

    public static Multimap<QualifiedName, IEObjectDescription> index(Iterable<IEObjectDescription> descriptions) {
        return Scopes.index(descriptions, new Function<IEObjectDescription, QualifiedName>(){

            @Override
            public QualifiedName apply(IEObjectDescription from) {
                return from.getName().toLowerCase();
            }
        });
    }

    public static Iterable<IEObjectDescription> filterDuplicates(Iterable<IEObjectDescription> filtered) {
        LinkedHashMap<QualifiedName, IEObjectDescription> result = Maps.newLinkedHashMap();
        for (IEObjectDescription e : filtered) {
            QualifiedName qualifiedName = e.getName();
            if (result.containsKey(qualifiedName)) {
                result.put(qualifiedName, null);
                continue;
            }
            result.put(qualifiedName, e);
        }
        return Iterables.filter(result.values(), Predicates.notNull());
    }
}

