/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.splitting;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrParserSplitter {
    public static final int FIELDS_PER_CLASS = 1000;
    public static final Pattern DECLARATION_PATTERN = Pattern.compile("public static final BitSet (FOLLOW_.*?)(\\s*=.*;)", 0);
    public static final Pattern REFERENCE_PATTERN = Pattern.compile("(?<!BitSet )(FOLLOW_[\\w]+)", 0);
    private final String content;
    private Map<String, Integer> fields = new HashMap<String, Integer>();
    private List<ExtractedClass> extractedClasses = new ArrayList<ExtractedClass>();
    private final int fieldsPerClass;

    public AntlrParserSplitter(String content) {
        this(content, 1000);
    }

    public AntlrParserSplitter(String content, int fieldsPerClass) {
        this.content = content;
        this.fieldsPerClass = fieldsPerClass;
    }

    public String transform() {
        this.fields.clear();
        this.extractedClasses.clear();
        Matcher m = REFERENCE_PATTERN.matcher(this.content);
        StringBuffer result = new StringBuffer();
        int lastMatch = 0;
        while (m.find()) {
            String field = m.group();
            this.registerField(field);
            m.appendReplacement(result, this.getTransformedReference(field));
            lastMatch = m.end();
        }
        m = DECLARATION_PATTERN.matcher(this.content);
        if (m.find(lastMatch)) {
            result.append(this.content.subSequence(lastMatch, m.start()));
            ExtractedClass ec = new ExtractedClass(this.extractedClasses.size());
            do {
                ec.addDeclaration(m.group());
                if (!ec.isFull()) continue;
                this.extractedClasses.add(ec.finalized());
                ec = new ExtractedClass(this.extractedClasses.size());
            } while (m.find());
            if (ec.hasContent()) {
                this.extractedClasses.add(ec.finalized());
            }
        }
        result.append("\n");
        for (ExtractedClass ec : this.getExtractedClasses()) {
            result.append(ec.getContent());
            result.append("\n");
        }
        result.append("\n}");
        return result.toString();
    }

    public List<ExtractedClass> getExtractedClasses() {
        return Collections.unmodifiableList(this.extractedClasses);
    }

    private String getTransformedReference(String field) {
        int idx = this.fields.get(field);
        return String.valueOf(this.getExtractedClassName(idx / this.fieldsPerClass)) + "." + field;
    }

    private String getExtractedClassName(int i) {
        return String.format("FollowSets%03d", i);
    }

    private void registerField(String field) {
        if (!this.fields.containsKey(field)) {
            this.fields.put(field, this.fields.size());
        }
    }

    public class ExtractedClass {
        private static final String INDENT = "    ";
        private static final String INDENT2 = "        ";
        private final int index;
        private StringBuilder content;
        private int declarationCount;
        private boolean finalized;

        public ExtractedClass(int index) {
            this.index = index;
            this.content = this.createContent();
        }

        public boolean isFull() {
            return this.declarationCount >= AntlrParserSplitter.this.fieldsPerClass;
        }

        public void addDeclaration(String declaration) {
            Preconditions.checkState(!this.finalized, "already finalized");
            this.content.append(INDENT2);
            this.content.append(declaration.trim());
            this.content.append("\n");
            ++this.declarationCount;
        }

        private StringBuilder createContent() {
            StringBuilder result = new StringBuilder();
            result.append(INDENT);
            result.append("private static class ");
            result.append(this.getName());
            result.append(" {\n");
            return result;
        }

        public boolean hasContent() {
            return this.declarationCount > 0;
        }

        public ExtractedClass finalized() {
            Preconditions.checkState(!this.finalized);
            this.content.append(INDENT);
            this.content.append("}\n");
            this.finalized = true;
            return this;
        }

        public String getName() {
            return AntlrParserSplitter.this.getExtractedClassName(this.index);
        }

        public String getContent() {
            return this.content.toString();
        }
    }
}

