/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceMarkers {
    public static final String MARKER_ID = "org.eclipse.xtext.builder.traceFilePath";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_GENERATOR_NAME = "generatorName";
    public static final String DEFAULT_GENERATOR_NAME = "default";

    protected IMarker[] findTraceMarkers(IFile file) throws CoreException {
        if (!file.exists()) {
            return new IMarker[0];
        }
        IMarker[] markers = file.findMarkers(MARKER_ID, false, 1);
        return markers;
    }

    public List<IPath> findTraceFiles(IFile sourceFile) throws CoreException {
        return this.findTraceFiles(sourceFile, DEFAULT_GENERATOR_NAME);
    }

    public List<IPath> findTraceFiles(IFile sourceFile, String generatorName) throws CoreException {
        ArrayList<IPath> result = Lists.newArrayList();
        IMarker[] iMarkerArray = this.findTraceMarkers(sourceFile);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            String portablePath;
            String markerGeneratorName;
            IMarker marker = iMarkerArray[n2];
            if (marker.exists() && generatorName.equals(markerGeneratorName = marker.getAttribute(ATTR_GENERATOR_NAME, DEFAULT_GENERATOR_NAME)) && (portablePath = marker.getAttribute(ATTR_PATH, null)) != null) {
                result.add(Path.fromPortableString(portablePath));
            }
            ++n2;
        }
        return result;
    }

    public void installMarker(IFile sourceFile, IPath ... traceFileLocations) throws CoreException {
        this.installMarker(sourceFile, DEFAULT_GENERATOR_NAME, traceFileLocations);
    }

    public void installMarker(IFile sourceFile, String generatorName, IPath[] traceFileLocations) throws CoreException {
        if (!sourceFile.exists()) {
            return;
        }
        IMarker[] markers = this.findTraceMarkers(sourceFile);
        Object[] objectArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String markerGeneratorName;
            IMarker marker = objectArray[n2];
            if (marker.exists() && generatorName.equals(markerGeneratorName = marker.getAttribute(ATTR_GENERATOR_NAME, DEFAULT_GENERATOR_NAME))) {
                marker.delete();
            }
            ++n2;
        }
        objectArray = traceFileLocations;
        n = traceFileLocations.length;
        n2 = 0;
        while (n2 < n) {
            Object traceFileLocation = objectArray[n2];
            IMarker marker = sourceFile.createMarker(MARKER_ID);
            marker.setAttribute(ATTR_PATH, traceFileLocation.toPortableString());
            if (!DEFAULT_GENERATOR_NAME.equals(generatorName)) {
                marker.setAttribute(ATTR_GENERATOR_NAME, generatorName);
            }
            ++n2;
        }
    }
}

