/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildContext;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.RegistryBuilderParticipant;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.internal.Stopwatches;

public class XtextBuilder
extends IncrementalProjectBuilder {
    private static final Logger log = Logger.getLogger(XtextBuilder.class);
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private RegistryBuilderParticipant participant;
    @Inject
    private QueuedBuildData queuedBuildData;

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        block15: {
            long startTime = System.currentTimeMillis();
            Stopwatches.StoppedTask task = Stopwatches.forTask(String.format("XtextBuilder.build[%s]", this.getKindAsString(kind)));
            try {
                try {
                    task.start();
                    if (monitor != null) {
                        final String taskName = String.valueOf(Messages.XtextBuilder_Building) + this.getProject().getName() + ": ";
                        monitor = new ProgressMonitorWrapper(monitor){

                            public void subTask(String name) {
                                super.subTask(String.valueOf(taskName) + name);
                            }
                        };
                    }
                    SubMonitor progress = SubMonitor.convert(monitor, 1);
                    if (kind == 6) {
                        this.fullBuild(progress.newChild(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                    } else {
                        IResourceDelta delta = this.getDelta(this.getProject());
                        if (delta == null || this.isOpened(delta)) {
                            this.fullBuild(progress.newChild(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                        } else {
                            this.incrementalBuild(delta, progress.newChild(1));
                        }
                    }
                }
                catch (CoreException e) {
                    log.error(e.getMessage(), e);
                    throw e;
                }
                catch (OperationCanceledException e) {
                    this.forgetLastBuiltState();
                    throw e;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    if (monitor != null) {
                        monitor.done();
                    }
                    log.info("Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms");
                    task.stop();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (monitor != null) {
                    monitor.done();
                }
                log.info("Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms");
                task.stop();
                throw throwable;
            }
            if (monitor != null) {
                monitor.done();
            }
            log.info("Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms");
            task.stop();
        }
        return this.getProject().getReferencedProjects();
    }

    private String getKindAsString(int kind) {
        if (kind == 6) {
            return "FULL";
        }
        if (kind == 15) {
            return "CLEAN";
        }
        if (kind == 10) {
            return "INCREMENTAL";
        }
        if (kind == 9) {
            return "AUTO";
        }
        return "UNKOWN:" + kind;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        final SubMonitor progress = SubMonitor.convert(monitor, Messages.XtextBuilder_CollectingResources, 10);
        progress.subTask(Messages.XtextBuilder_CollectingResources);
        if (this.queuedBuildData.needRebuild(this.getProject())) {
            this.needRebuild();
        }
        final ToBeBuilt toBeBuilt = new ToBeBuilt();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (delta.getResource() instanceof IProject) {
                    return delta.getResource() == XtextBuilder.this.getProject();
                }
                if (delta.getResource() instanceof IStorage) {
                    if (delta.getKind() == 2) {
                        return XtextBuilder.this.toBeBuiltComputer.removeStorage(null, toBeBuilt, (IStorage)((Object)delta.getResource()));
                    }
                    if (delta.getKind() == 1 || delta.getKind() == 4) {
                        return XtextBuilder.this.toBeBuiltComputer.updateStorage(null, toBeBuilt, (IStorage)((Object)delta.getResource()));
                    }
                }
                return true;
            }
        };
        delta.accept(visitor);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.worked(2);
        this.doBuild(toBeBuilt, progress.newChild(8), IXtextBuilderParticipant.BuildType.INCREMENTAL);
    }

    protected void doBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException {
        if (new BuildData(this.getProject().getName(), null, toBeBuilt, this.queuedBuildData).isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert(monitor, 2);
        ResourceSet resourceSet = this.getResourceSetProvider().get(this.getProject());
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        if (resourceSet instanceof ResourceSetImpl) {
            ((ResourceSetImpl)resourceSet).setURIResourceMap(Maps.<URI, Resource>newHashMap());
        }
        BuildData buildData = new BuildData(this.getProject().getName(), resourceSet, toBeBuilt, this.queuedBuildData);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.update(buildData, progress.newChild(1));
        if (this.participant != null) {
            this.participant.build(new BuildContext(this, resourceSet, deltas, type), progress.newChild(1));
            this.getProject().getWorkspace().checkpoint(false);
        } else {
            progress.worked(1);
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    protected void fullBuild(IProgressMonitor monitor, boolean isRecoveryBuild) throws CoreException {
        SubMonitor progress = SubMonitor.convert(monitor, 10);
        IProject project = this.getProject();
        ToBeBuilt toBeBuilt = isRecoveryBuild ? this.toBeBuiltComputer.updateProjectNewResourcesOnly(project, progress.newChild(2)) : this.toBeBuiltComputer.updateProject(project, progress.newChild(2));
        this.doBuild(toBeBuilt, progress.newChild(8), isRecoveryBuild ? IXtextBuilderParticipant.BuildType.RECOVERY : IXtextBuilderParticipant.BuildType.FULL);
    }

    protected boolean isOpened(IResourceDelta delta) {
        return delta.getResource() instanceof IProject && (delta.getFlags() & 0x4000) != 0 && ((IProject)delta.getResource()).isOpen();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert(monitor, 10);
        try {
            ToBeBuilt toBeBuilt = this.toBeBuiltComputer.removeProject(this.getProject(), progress.newChild(2));
            this.doClean(toBeBuilt, progress.newChild(8));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void doClean(ToBeBuilt toBeBuilt, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert(monitor, 2);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.clean(toBeBuilt.getToBeDeleted(), progress.newChild(1));
        if (this.participant != null) {
            this.participant.build(new BuildContext(this, this.getResourceSetProvider().get(this.getProject()), deltas, IXtextBuilderParticipant.BuildType.CLEAN), progress.newChild(1));
        } else {
            progress.worked(1);
        }
    }
}

