/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.internal.about.ProductInfoPage;

public abstract class ProductInfoDialog
extends InstallationDialog {
    ProductInfoPage page;
    String title;
    String helpContextId;

    protected ProductInfoDialog(Shell shell) {
        super(shell, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void initializeDialog(ProductInfoPage page, String title, String helpContextId) {
        this.page = page;
        this.title = title;
        this.helpContextId = helpContextId;
    }

    @Override
    protected void createFolderItems(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(this.title);
        Composite control = new Composite(folder, 2048);
        control.setLayout(new GridLayout());
        item.setControl(control);
        this.page.createControl(control);
        item.setData(this.page);
        item.setData("ID", this.page.getId());
        this.page.setPageContainer(this);
        item.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                ProductInfoDialog.this.page.dispose();
            }
        });
        control.layout(true, true);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButtons(this.page);
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(newShell, this.helpContextId);
        }
    }

    @Override
    protected String pageToId(InstallationPage page) {
        Assert.isLegal(page == this.page);
        return this.page.getId();
    }
}

