/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.perspectiveswitcher;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.event.EventHandler;

public class PerspectiveSwitcher {
    public static final String PERSPECTIVE_SWITCHER_ID = "org.eclipse.e4.ui.PerspectiveSwitcher";
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private MWindow window;
    @Inject
    private Logger logger;
    private MToolControl psME;
    private ToolBar psTB;
    private Composite comp;
    private Image backgroundImage;
    private Image perspectiveImage;
    Color borderColor;
    Color curveColor;
    Control toolParent;
    IPropertyChangeListener propertyChangeListener;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (PerspectiveSwitcher.this.psME == null || !(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor(changedElement);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                return;
            }
            MPerspectiveStack perspStack = (MPerspectiveStack)changedElement;
            if (!perspStack.isToBeRendered()) {
                return;
            }
            MPerspective selElement = (MPerspective)perspStack.getSelectedElement();
            ToolItem[] toolItemArray = PerspectiveSwitcher.this.psTB.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem ti;
                ti.setSelection((ti = toolItemArray[n2]).getData() == selElement);
                ++n2;
            }
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (PerspectiveSwitcher.this.psME == null || !(changedElement instanceof MPerspective)) {
                return;
            }
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor(changedElement);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                return;
            }
            MPerspective persp = (MPerspective)changedElement;
            if (!persp.getParent().isToBeRendered()) {
                return;
            }
            if (changedElement.isToBeRendered()) {
                PerspectiveSwitcher.this.addPerspectiveItem(persp);
            } else {
                PerspectiveSwitcher.this.removePerspectiveItem(persp);
            }
        }
    };
    private EventHandler labelHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (PerspectiveSwitcher.this.psME == null || !(changedElement instanceof MPerspective)) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            Object newValue = event.getProperty("NewValue");
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor(changedElement);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                return;
            }
            MPerspective perspective = (MPerspective)changedElement;
            if (!perspective.isToBeRendered()) {
                return;
            }
            ToolItem[] toolItemArray = PerspectiveSwitcher.this.psTB.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem ti = toolItemArray[n2];
                if (ti.getData() == perspective) {
                    this.updateToolItem(ti, attName, newValue);
                }
                ++n2;
            }
            PerspectiveSwitcher.this.fixSize();
        }

        private void updateToolItem(ToolItem ti, String attName, Object newValue) {
            block13: {
                boolean showText = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR");
                if (showText && "label".equals(attName)) {
                    String newName = (String)newValue;
                    ti.setText(newName);
                } else if ("tooltip".equals(attName)) {
                    String newTTip = (String)newValue;
                    ti.setToolTipText(newTTip);
                } else if ("iconURI".equals(attName)) {
                    Image currentImage = ti.getImage();
                    String uri = (String)newValue;
                    URL url = null;
                    try {
                        try {
                            url = new URL(uri);
                            ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
                            if (descriptor == null) {
                                ti.setImage(null);
                                break block13;
                            }
                            ti.setImage(descriptor.createImage());
                        }
                        catch (IOException e) {
                            ti.setImage(null);
                            PerspectiveSwitcher.this.logger.warn((Throwable)e);
                            if (currentImage != null) {
                                currentImage.dispose();
                            }
                        }
                    }
                    finally {
                        if (currentImage != null) {
                            currentImage.dispose();
                        }
                    }
                }
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            block6: {
                block5: {
                    MWindow switcherWin;
                    if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                        return;
                    }
                    Object changedObj = event.getProperty("ChangedElement");
                    if (PerspectiveSwitcher.this.psME == null || !(changedObj instanceof MPerspectiveStack)) {
                        return;
                    }
                    MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)changedObj);
                    if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                        return;
                    }
                    if (!UIEvents.isADD((org.osgi.service.event.Event)event)) break block5;
                    for (Object o : UIEvents.asIterable((org.osgi.service.event.Event)event, (String)"NewValue")) {
                        MPerspective added = (MPerspective)o;
                        if (!added.isToBeRendered()) continue;
                        PerspectiveSwitcher.this.addPerspectiveItem(added);
                    }
                    break block6;
                }
                if (!UIEvents.isREMOVE((org.osgi.service.event.Event)event)) break block6;
                for (Object o : UIEvents.asIterable((org.osgi.service.event.Event)event, (String)"OldValue")) {
                    MPerspective removed = (MPerspective)o;
                    if (!removed.isToBeRendered()) continue;
                    PerspectiveSwitcher.this.removePerspectiveItem(removed);
                }
            }
        }
    };
    protected Point downPos = null;
    protected ToolItem dragItem = null;
    protected boolean dragging = false;
    protected Shell dragShell = null;

    @PostConstruct
    void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toBeRenderedHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectionHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.labelHandler);
        this.setPropertyChangeListener();
    }

    @PreDestroy
    void cleanUp() {
        if (this.perspectiveImage != null) {
            this.perspectiveImage.dispose();
            this.perspectiveImage = null;
        }
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.labelHandler);
        PrefUtil.getAPIPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        MTrimBar bar;
        this.psME = toolControl;
        MElementContainer meParent = this.psME.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar && ((bar = (MTrimBar)meParent).getSide() == SideValue.RIGHT || bar.getSide() == SideValue.LEFT)) {
            orientation = 512;
        }
        this.comp = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginRight = 8;
        layout.marginLeft = 8;
        layout.marginBottom = 4;
        layout.marginTop = 6;
        this.comp.setLayout(layout);
        this.psTB = new ToolBar(this.comp, 0x800040 | 131072 + orientation);
        this.comp.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                PerspectiveSwitcher.this.paint(e);
            }
        });
        this.toolParent = (Control)toolControl.getParent().getWidget();
        this.toolParent.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                if (PerspectiveSwitcher.this.borderColor == null || PerspectiveSwitcher.this.borderColor.isDisposed()) {
                    PerspectiveSwitcher.this.borderColor = e.display.getSystemColor(2);
                }
                e.gc.setForeground(PerspectiveSwitcher.this.borderColor);
                Rectangle bounds = ((Control)e.widget).getBounds();
                e.gc.drawLine(0, bounds.height - 1, bounds.width, bounds.height - 1);
            }
        });
        this.comp.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.dispose();
            }
        });
        this.psTB.addMenuDetectListener(new MenuDetectListener(){

            @Override
            public void menuDetected(MenuDetectEvent e) {
                ToolBar tb = (ToolBar)e.widget;
                Point p = new Point(e.x, e.y);
                p = PerspectiveSwitcher.this.psTB.getDisplay().map(null, (Control)PerspectiveSwitcher.this.psTB, p);
                ToolItem item = tb.getItem(p);
                if (item == null) {
                    E4Util.message("  ToolBar menu");
                } else {
                    MPerspective persp = (MPerspective)item.getData();
                    if (persp == null) {
                        E4Util.message("  Add button Menu");
                    } else {
                        PerspectiveSwitcher.this.openMenuFor(item, persp);
                    }
                }
            }
        });
        this.psTB.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.disposeTBImages();
            }
        });
        this.psTB.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                ToolItem item;
                if (e.childID >= 0 && e.childID < PerspectiveSwitcher.this.psTB.getItemCount() && (item = PerspectiveSwitcher.this.psTB.getItem(e.childID)) != null) {
                    e.result = item.getToolTipText();
                }
            }
        });
        this.hookupDnD(this.psTB);
        ToolItem createItem = new ToolItem(this.psTB, 8);
        createItem.setImage(this.getOpenPerspectiveImage());
        createItem.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
        createItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PerspectiveSwitcher.this.selectPerspective();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                PerspectiveSwitcher.this.selectPerspective();
            }
        });
        new ToolItem(this.psTB, 2);
        MPerspectiveStack stack = this.getPerspectiveStack();
        if (stack != null) {
            for (MPerspective persp : stack.getChildren()) {
                if (!persp.isToBeRendered()) continue;
                this.addPerspectiveItem(persp);
            }
        }
    }

    private void track(MouseEvent e) {
        if (this.dragShell == null) {
            this.createFeedback();
        }
        Rectangle b = this.dragItem.getBounds();
        Point p = new Point(e.x, e.y);
        p = this.dragShell.getDisplay().map((Control)this.dragItem.getParent(), null, p);
        this.dragShell.setLocation(p.x - b.width / 2, p.y - b.height / 2);
        ToolBar bar = (ToolBar)e.widget;
        ToolItem curItem = bar.getItem(new Point(e.x, e.y));
        if (curItem != null && curItem.getData() instanceof MPerspective) {
            this.psTB.setCursor(this.psTB.getDisplay().getSystemCursor(21));
        } else {
            this.psTB.setCursor(this.psTB.getDisplay().getSystemCursor(20));
        }
    }

    private void createFeedback() {
        this.dragShell = new Shell(262152);
        this.dragShell.setAlpha(175);
        ToolBar dragTB = new ToolBar(this.dragShell, 131072);
        ToolItem newTI = new ToolItem(dragTB, 16);
        newTI.setText(this.dragItem.getText());
        newTI.setImage(this.dragItem.getImage());
        dragTB.pack();
        this.dragShell.pack();
        this.dragShell.setVisible(true);
    }

    private void hookupDnD(ToolBar bar) {
        bar.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (PerspectiveSwitcher.this.dragItem == null) {
                    return;
                }
                ToolBar bar = (ToolBar)e.widget;
                ToolItem curItem = bar.getItem(new Point(e.x, e.y));
                if (curItem != null && curItem.getData() instanceof MPerspective) {
                    Rectangle bounds = curItem.getBounds();
                    Point center = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
                    boolean atStart = (PerspectiveSwitcher.this.psTB.getStyle() & 0x100) != 0 ? e.x < center.x : e.y < center.y;
                    MPerspective dragPersp = (MPerspective)PerspectiveSwitcher.this.dragItem.getData();
                    int dragPerspIndex = dragPersp.getParent().getChildren().indexOf(dragPersp);
                    MPerspective dropPersp = (MPerspective)curItem.getData();
                    int dropPerspIndex = dropPersp.getParent().getChildren().indexOf(dropPersp);
                    if (!atStart) {
                        ++dropPerspIndex;
                    }
                    if (dropPerspIndex > dragPerspIndex) {
                        --dropPerspIndex;
                    }
                    if (dropPerspIndex != dragPerspIndex) {
                        MElementContainer parent = dragPersp.getParent();
                        boolean selected = dragPersp == parent.getSelectedElement();
                        parent.getChildren().remove(dragPersp);
                        parent.getChildren().add(dropPerspIndex, dragPersp);
                        if (selected) {
                            parent.setSelectedElement((MUIElement)dragPersp);
                        }
                    }
                }
                PerspectiveSwitcher.this.dragItem = null;
                PerspectiveSwitcher.this.downPos = null;
                PerspectiveSwitcher.this.dragging = false;
                PerspectiveSwitcher.this.psTB.setCursor(null);
                if (PerspectiveSwitcher.this.dragShell != null && !PerspectiveSwitcher.this.dragShell.isDisposed()) {
                    PerspectiveSwitcher.this.dragShell.dispose();
                }
                PerspectiveSwitcher.this.dragShell = null;
            }

            @Override
            public void mouseDown(MouseEvent e) {
                ToolBar bar = (ToolBar)e.widget;
                PerspectiveSwitcher.this.downPos = new Point(e.x, e.y);
                ToolItem downItem = bar.getItem(PerspectiveSwitcher.this.downPos);
                if (downItem != null && downItem.getData() instanceof MPerspective) {
                    PerspectiveSwitcher.this.dragItem = downItem;
                }
            }

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        bar.addDragDetectListener(new DragDetectListener(){

            @Override
            public void dragDetected(DragDetectEvent e) {
                if (PerspectiveSwitcher.this.dragItem != null) {
                    PerspectiveSwitcher.this.dragging = true;
                    PerspectiveSwitcher.this.track(e);
                }
            }
        });
        bar.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent e) {
                if (PerspectiveSwitcher.this.dragging) {
                    PerspectiveSwitcher.this.track(e);
                }
            }
        });
    }

    private Image getOpenPerspectiveImage() {
        if (this.perspectiveImage == null || this.perspectiveImage.isDisposed()) {
            ImageDescriptor desc = WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE");
            this.perspectiveImage = desc.createImage();
        }
        return this.perspectiveImage;
    }

    MPerspectiveStack getPerspectiveStack() {
        List psList = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (psList.size() > 0) {
            return (MPerspectiveStack)psList.get(0);
        }
        return null;
    }

    private ToolItem addPerspectiveItem(MPerspective persp) {
        Image image;
        ImageDescriptor desc;
        int perspIndex = persp.getParent().getChildren().indexOf(persp);
        int index = perspIndex + 2;
        final ToolItem psItem = index < this.psTB.getItemCount() ? new ToolItem(this.psTB, 16, index) : new ToolItem(this.psTB, 16);
        psItem.setData(persp);
        IPerspectiveDescriptor descriptor = this.getDescriptorFor(persp.getElementId());
        boolean foundImage = false;
        if (descriptor != null && (desc = descriptor.getImageDescriptor()) != null && (image = desc.createImage(false)) != null) {
            psItem.setImage(image);
            psItem.addListener(12, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    Image currentImage = psItem.getImage();
                    if (currentImage != null) {
                        currentImage.dispose();
                    }
                }
            });
            foundImage = true;
            psItem.setToolTipText(persp.getLocalizedLabel());
        }
        if (!foundImage || PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
            psItem.setText(persp.getLocalizedLabel());
            psItem.setToolTipText(persp.getLocalizedTooltip());
        }
        psItem.setSelection(persp == persp.getParent().getSelectedElement());
        psItem.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)e.widget.getData();
                persp.getParent().setSelectedElement((MUIElement)persp);
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)e.widget.getData();
                persp.getParent().setSelectedElement((MUIElement)persp);
            }
        });
        psItem.addListener(35, new Listener(){

            @Override
            public void handleEvent(Event event) {
                MPerspective persp = (MPerspective)event.widget.getData();
                PerspectiveSwitcher.this.openMenuFor(psItem, persp);
            }
        });
        this.fixSize();
        return psItem;
    }

    private IPerspectiveDescriptor getDescriptorFor(String id) {
        IPerspectiveRegistry perspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        if (perspectiveRegistry instanceof PerspectiveRegistry) {
            return ((PerspectiveRegistry)perspectiveRegistry).findPerspectiveWithId(id, false);
        }
        return perspectiveRegistry.findPerspectiveWithId(id);
    }

    private void selectPerspective() {
        ParameterizedCommand command = this.commandService.createCommand("org.eclipse.ui.perspectives.showPerspective", Collections.EMPTY_MAP);
        this.handlerService.executeHandler(command);
    }

    private void openMenuFor(ToolItem item, MPerspective persp) {
        final Menu menu = new Menu(this.psTB);
        menu.setData(persp);
        if (persp.getParent().getSelectedElement() == persp) {
            this.addSaveAsItem(menu);
            this.addResetItem(menu);
        }
        if (persp.isVisible()) {
            this.addCloseItem(menu);
        }
        new MenuItem(menu, 2);
        this.addShowTextItem(menu);
        Rectangle bounds = item.getBounds();
        Point point = this.psTB.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuHidden(MenuEvent e) {
                PerspectiveSwitcher.this.psTB.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menu.dispose();
                    }
                });
            }

            @Override
            public void menuShown(MenuEvent e) {
            }
        });
    }

    private void addCloseItem(final Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.WorkbenchWindow_close);
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)menu.getData();
                if (persp != null) {
                    PerspectiveSwitcher.this.closePerspective(persp);
                }
            }
        });
    }

    private void closePerspective(MPerspective persp) {
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)persp);
        WorkbenchPage page = (WorkbenchPage)win.getContext().get(IWorkbenchPage.class);
        String perspectiveId = persp.getElementId();
        IPerspectiveDescriptor desc = this.getDescriptorFor(perspectiveId);
        page.closePerspective(desc, perspectiveId, true, false);
    }

    private void addSaveAsItem(Menu menu) {
        MenuItem saveAsMenuItem = new MenuItem(menu, 26);
        saveAsMenuItem.setText(WorkbenchMessages.PerspectiveBar_saveAs);
        final IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        workbenchWindow.getWorkbench().getHelpSystem().setHelp(saveAsMenuItem, "org.eclipse.ui.save_perspective_action_context");
        saveAsMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                    return;
                }
                IHandlerService handlerService = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
                IStatus status = Status.OK_STATUS;
                try {
                    handlerService.executeCommand("org.eclipse.ui.window.savePerspective", null);
                }
                catch (ExecutionException e) {
                    status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                }
                catch (NotDefinedException e) {
                    status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                }
                catch (NotEnabledException e) {
                    status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                }
                catch (NotHandledException notHandledException) {}
                if (!status.isOK()) {
                    StatusManager.getManager().handle(status, 3);
                }
            }
        });
    }

    private void addResetItem(Menu menu) {
        MenuItem resetMenuItem = new MenuItem(menu, 26);
        resetMenuItem.setText(WorkbenchMessages.PerspectiveBar_reset);
        final IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        workbenchWindow.getWorkbench().getHelpSystem().setHelp(resetMenuItem, "org.eclipse.ui.reset_perspective_action_context");
        resetMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                    return;
                }
                IHandlerService handlerService = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
                IStatus status = Status.OK_STATUS;
                try {
                    handlerService.executeCommand("org.eclipse.ui.window.resetPerspective", null);
                }
                catch (ExecutionException e) {
                    status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                }
                catch (NotDefinedException e) {
                    status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                }
                catch (NotEnabledException e) {
                    status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                }
                catch (NotHandledException notHandledException) {}
                if (!status.isOK()) {
                    StatusManager.getManager().handle(status, 3);
                }
            }
        });
    }

    private void addShowTextItem(Menu menu) {
        final MenuItem showtextMenuItem = new MenuItem(menu, 32);
        showtextMenuItem.setText(WorkbenchMessages.PerspectiveBar_showText);
        showtextMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                boolean preference = showtextMenuItem.getSelection();
                if (preference != PrefUtil.getAPIPreferenceStore().getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
                    PrefUtil.getInternalPreferenceStore().setValue("overridepresentation", true);
                }
                PrefUtil.getAPIPreferenceStore().setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", preference);
                PerspectiveSwitcher.this.changeShowText(preference);
            }
        });
        showtextMenuItem.setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
    }

    private void setPropertyChangeListener() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                    Object newValue = propertyChangeEvent.getNewValue();
                    boolean showText = true;
                    if (newValue instanceof Boolean) {
                        showText = (Boolean)newValue;
                    } else if ("false".equals(newValue)) {
                        showText = false;
                    }
                    PerspectiveSwitcher.this.changeShowText(showText);
                }
            }
        };
        PrefUtil.getAPIPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void changeShowText(boolean showText) {
        ToolItem[] items = this.psTB.getItems();
        int i = 0;
        while (i < items.length) {
            MPerspective persp = (MPerspective)items[i].getData();
            if (persp != null) {
                if (showText) {
                    if (persp.getLabel() != null) {
                        items[i].setText(persp.getLocalizedLabel());
                    }
                    items[i].setToolTipText(persp.getLocalizedTooltip());
                } else {
                    Image image = items[i].getImage();
                    if (image != null) {
                        items[i].setText("");
                        items[i].setToolTipText(persp.getLocalizedLabel());
                    }
                }
            }
            ++i;
        }
        this.fixSize();
    }

    private void fixSize() {
        this.psTB.pack();
        this.psTB.getParent().pack();
        this.psTB.getShell().layout(new Control[]{this.psTB}, 4);
    }

    private void removePerspectiveItem(MPerspective toRemove) {
        ToolItem psItem = this.getItemFor(toRemove);
        if (psItem != null) {
            psItem.dispose();
        }
        this.fixSize();
    }

    protected ToolItem getItemFor(MPerspective persp) {
        if (this.psTB == null) {
            return null;
        }
        ToolItem[] toolItemArray = this.psTB.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem ti = toolItemArray[n2];
            if (ti.getData() == persp) {
                return ti;
            }
            ++n2;
        }
        return null;
    }

    void paint(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.comp.getSize();
        if (this.curveColor == null || this.curveColor.isDisposed()) {
            this.curveColor = e.display.getSystemColor(2);
        }
        int h = size.y;
        int[] nArray = new int[10];
        nArray[1] = h - 1;
        nArray[2] = 1;
        nArray[3] = h - 1;
        nArray[4] = 2;
        nArray[5] = h - 2;
        nArray[6] = 2;
        nArray[7] = 1;
        nArray[8] = 3;
        int[] simpleCurve = nArray;
        gc.setForeground(this.curveColor);
        gc.setAdvanced(true);
        if (gc.getAdvanced()) {
            gc.setAntialias(1);
        }
        gc.drawPolyline(simpleCurve);
        Rectangle bounds = ((Control)e.widget).getBounds();
        bounds.y = 0;
        bounds.x = 0;
        Region r = new Region();
        r.add(bounds);
        int[] simpleCurveClose = new int[simpleCurve.length + 4];
        System.arraycopy(simpleCurve, 0, simpleCurveClose, 0, simpleCurve.length);
        int index = simpleCurve.length;
        simpleCurveClose[index++] = bounds.width;
        simpleCurveClose[index++] = 0;
        simpleCurveClose[index++] = bounds.width;
        simpleCurveClose[index++] = bounds.height;
        r.subtract(simpleCurveClose);
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.intersect(clipping);
        gc.setClipping(r);
        Image b = this.toolParent.getBackgroundImage();
        if (b != null && !b.isDisposed()) {
            gc.drawImage(b, 0, 0);
        }
        r.dispose();
        clipping.dispose();
    }

    void resize() {
        Point size = this.comp.getSize();
        Image oldBackgroundImage = this.backgroundImage;
        this.backgroundImage = new Image((Device)this.comp.getDisplay(), size.x, size.y);
        GC gc = new GC(this.backgroundImage);
        this.comp.getParent().drawBackground(gc, 0, 0, size.x, size.y, 0, 0);
        Color background = this.comp.getBackground();
        Color border = this.comp.getDisplay().getSystemColor(18);
        RGB backgroundRGB = background.getRGB();
        Color gradientTop = new Color(this.comp.getDisplay(), backgroundRGB.red + 12, backgroundRGB.green + 10, backgroundRGB.blue + 10);
        int h = size.y;
        int curveStart = 0;
        int curve_width = 5;
        int[] nArray = new int[14];
        nArray[1] = h;
        nArray[2] = 1;
        nArray[3] = h;
        nArray[4] = 2;
        nArray[5] = h - 1;
        nArray[6] = 3;
        nArray[7] = h - 2;
        nArray[8] = 3;
        nArray[9] = 2;
        nArray[10] = 4;
        nArray[11] = 1;
        nArray[12] = 5;
        int[] curve = nArray;
        int[] line1 = new int[curve.length + 4];
        int index = 0;
        int x = curveStart;
        line1[index++] = x + 1;
        line1[index++] = h;
        int i = 0;
        while (i < curve.length / 2) {
            line1[index++] = x + curve[2 * i];
            line1[index++] = curve[2 * i + 1];
            ++i;
        }
        line1[index++] = x + curve_width;
        line1[index++] = 0;
        int[] line2 = new int[line1.length];
        index = 0;
        int i2 = 0;
        while (i2 < line1.length / 2) {
            line2[index] = line1[index++] - 1;
            line2[index] = line1[index++];
            ++i2;
        }
        gc.setForeground(gradientTop);
        gc.setBackground(background);
        gc.drawLine(4, 0, size.x, 0);
        gc.drawLine(3, 1, size.x, 1);
        gc.fillGradientRectangle(2, 2, size.x - 2, size.y - 3, true);
        gc.setForeground(background);
        gc.drawLine(2, size.y - 1, size.x, size.y - 1);
        gradientTop.dispose();
        gc.setForeground(border);
        gc.drawPolyline(line2);
        gc.dispose();
        this.comp.setBackgroundImage(this.backgroundImage);
        if (oldBackgroundImage != null) {
            oldBackgroundImage.dispose();
        }
    }

    void dispose() {
        this.cleanUp();
        if (this.backgroundImage != null) {
            this.comp.setBackgroundImage(null);
            this.backgroundImage.dispose();
            this.backgroundImage = null;
        }
    }

    void disposeTBImages() {
        ToolItem[] items = this.psTB.getItems();
        int i = 0;
        while (i < items.length) {
            Image image = items[i].getImage();
            if (image != null) {
                items[i].setImage(null);
                image.dispose();
            }
            ++i;
        }
    }

    public void setKeylineColor(Color borderColor, Color curveColor) {
        this.borderColor = borderColor;
        this.curveColor = curveColor;
    }
}

