/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.projects.VC12;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;

public class VC12Utils {
    public String includeFilesPath(int nBits) {
        StringBuffer sb = new StringBuffer();
        String tangoIncludes = "$(TANGO_ROOT)\\win" + nBits + "\\include\\vc12;";
        String tangoclasses = "$(TANGO_ROOT)\\classes\\win" + nBits + "\\include\\vc12;";
        sb.append("<AdditionalIncludeDirectories>\n");
        sb.append("    ..;").append(tangoIncludes).append(tangoclasses).append("TemplateAbstractPath;%(AdditionalIncludeDirectories)\n");
        sb.append("</AdditionalIncludeDirectories>\n");
        return sb.toString();
    }

    public String sourceFileList(PogoDeviceClass cls) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildFileLine(String.valueOf(cls.getName()) + ".cpp"));
        sb.append(this.buildFileLine(String.valueOf(cls.getName()) + "Class.cpp"));
        sb.append(this.buildFileLine(String.valueOf(cls.getName()) + "StateMachine.cpp"));
        if (cls.getDynamicAttributes().size() > 0) {
            sb.append(this.buildFileLine(String.valueOf(cls.getName()) + "DynAttrUtils.cpp"));
        }
        for (AdditionalFile file : cls.getAdditionalFiles()) {
            String fileName = this.getOnlyFileName(file.getPath());
            if (fileName == null) continue;
            sb.append(this.buildFileLine(fileName));
        }
        return sb.toString();
    }

    public String includeFileList(PogoDeviceClass cls) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildIncludeFileLine(String.valueOf(cls.getName()) + ".h"));
        sb.append(this.buildIncludeFileLine(String.valueOf(cls.getName()) + "Class.h"));
        return sb.toString();
    }

    public String buildFileLine(String fileName) {
        return "<ClCompile Include=\"..\\" + fileName + "\" />\n";
    }

    public String buildIncludeFileLine(String fileName) {
        return "<ClInclude Include=\"..\\" + fileName + "\"> </ClInclude>\n";
    }

    private String getOnlyFileName(String pathName) {
        int pos = pathName.lastIndexOf(47);
        if (pos < 0) {
            pos = pathName.lastIndexOf(92);
        }
        if (pos < 0) {
            return null;
        }
        return pathName.substring(pos + 1);
    }

    private String tangoLibraryName(String libName, String mode, boolean shared) {
        return String.valueOf(libName) + (shared ? "_rt" : "") + mode + ".lib;";
    }

    public String tangoLibraries(String mode, boolean shared) {
        return String.valueOf(this.tangoLibraryName("omniORB4", mode, shared)) + this.tangoLibraryName("omniDynamic4", mode, shared) + this.tangoLibraryName("COS4", mode, shared) + this.tangoLibraryName("omnithread", mode, shared) + this.tangoLibraryName("tango", mode, false) + this.tangoLibraryName("log4tango", mode, false) + this.tangoLibraryName("zmq", mode, false);
    }

    public String windowsLibraries() {
        return "comctl32.lib;ws2_32.lib;mswsock.lib;advapi32.lib;";
    }

    public String libraryList(PogoDeviceClass cls, String mode, boolean shared, boolean itself) {
        return "<AdditionalDependencies>\n\t" + (itself ? String.valueOf(cls.getName()) + mode + ".lib;" : "") + this.tangoLibraries(mode, shared) + this.windowsLibraries() + "%(AdditionalDependencies)\n" + "</AdditionalDependencies>";
    }

    public String tangoLibraryPath(int nBits, boolean shared) {
        String dll = shared ? "_dll" : "";
        return "$(TANGO_ROOT)\\win" + nBits + "\\lib\\vc12" + dll + ";$(TANGO_ROOT)\\classes\\win" + nBits + "\\lib\\vc12" + dll;
    }

    public String libraryPath(int nBits, boolean shared) {
        String dll = shared ? "_dll" : "";
        return "<AdditionalLibraryDirectories>\n\t..\\lib\\win" + nBits + "\\vc12" + dll + ";" + this.tangoLibraryPath(nBits, shared) + ";%(AdditionalLibraryDirectories)\n" + "</AdditionalLibraryDirectories>";
    }
}

